/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.util;

public final class Checks {
    public static void checkArgument(boolean condition, String message, Object ... args) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void checkState(boolean condition, String message, Object ... args) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static void checkNotNullState(Object object, String message, Object ... args) {
        Checks.checkState(object != null, message, args);
    }

    public static void checkMinMax(int min, int max) {
        Checks.checkMin(min);
        Checks.checkMax(max);
        Checks.checkArgument(min <= max, "min > max", new Object[0]);
    }

    public static int checkMin(int min) {
        Checks.checkNonNegative(min, "min < 0");
        return min;
    }

    public static int checkMax(int max) {
        Checks.checkNonNegative(max, "max < 0");
        return max;
    }

    public static int checkNonNegative(int n, String message) {
        Checks.checkArgument(n >= 0, message, new Object[0]);
        return n;
    }
}

