/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.util;

import org.codehaus.jparsec.annotations.Private;

public final class IntList {
    private int[] buf;
    private int len = 0;

    public int[] toArray() {
        int[] ret = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            ret[i] = this.buf[i];
        }
        return ret;
    }

    public IntList(int capacity) {
        this.buf = new int[capacity];
    }

    public IntList() {
        this(10);
    }

    public int size() {
        return this.len;
    }

    private void checkIndex(int i) {
        if (i < 0 || i >= this.len) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
    }

    public int get(int i) {
        this.checkIndex(i);
        return this.buf[i];
    }

    public int set(int i, int val) {
        this.checkIndex(i);
        int old = this.buf[i];
        this.buf[i] = val;
        return old;
    }

    @Private
    static int calcSize(int expectedSize, int factor) {
        int rem = expectedSize % factor;
        return expectedSize / factor * factor + (rem > 0 ? factor : 0);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.buf.length) {
            int factor = this.buf.length / 2 + 1;
            this.grow(IntList.calcSize(capacity - this.buf.length, factor));
        }
    }

    private void grow(int l) {
        int[] nbuf = new int[this.buf.length + l];
        for (int i = 0; i < this.buf.length; ++i) {
            nbuf[i] = this.buf[i];
        }
        this.buf = nbuf;
    }

    public IntList add(int i) {
        this.ensureCapacity(this.len + 1);
        this.buf[this.len++] = i;
        return this;
    }
}

