/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;

public class AddressingHeaderFault
extends AxisFault {
    private static final long serialVersionUID = -7037754917195807959L;
    private static final String NS = "http://www.w3.org/2005/08/addressing";
    private static final QName INVALID_ADDRESSING_HEADER = new QName("http://www.w3.org/2005/08/addressing", "InvalidAddressingHeader");
    public static final QName INVALID_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "InvalidAddress");
    public static final QName INVALID_CARDINALITY = new QName("http://www.w3.org/2005/08/addressing", "InvalidCardinality");
    public static final QName HEADER_REQUIRED = new QName("http://www.w3.org/2005/08/addressing", "MessageAddressingHeaderRequired");
    public static final QName INVALID_EPR = new QName("http://www.w3.org/2005/08/addressing", "InvalidEPR");
    public static final QName MISSING_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "MissingAddressInEPR");
    public static final QName DUPLICATE_MSGID = new QName("http://www.w3.org/2005/08/addressing", "DuplicateMessageID");
    public static final QName ACTION_MISMATCH = new QName("http://www.w3.org/2005/08/addressing", "ActionMismatch");
    public static final QName PROBLEM_HEADER = new QName("http://www.w3.org/2005/08/addressing", "ProblemHeaderQName");
    public static final QName FAULT_DETAIL = new QName("http://www.w3.org/2005/08/addressing", "FaultDetail");

    public AddressingHeaderFault(String faultString) {
        this(faultString, null, null);
    }

    public AddressingHeaderFault(QName subSubCode, String problemHeader) {
        this(AddressingHeaderFault.buildMessage(subSubCode, problemHeader), subSubCode, problemHeader);
    }

    public AddressingHeaderFault(String faultString, QName subSubCode, String problemHeader) {
        MessageContext mc = MessageContext.getCurrentContext();
        if (mc == null || mc.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            this.setFaultCode(Constants.FAULT_SOAP12_SENDER);
            if (HEADER_REQUIRED.equals(subSubCode)) {
                this.addFaultSubCode(HEADER_REQUIRED);
            } else {
                this.addFaultSubCode(INVALID_ADDRESSING_HEADER);
                if (subSubCode != null) {
                    this.addFaultSubCode(subSubCode);
                }
            }
            if (problemHeader != null) {
                this.addFaultDetail(PROBLEM_HEADER, "wsa:" + problemHeader);
            }
        } else {
            if (subSubCode != null && subSubCode.equals(HEADER_REQUIRED)) {
                this.setFaultCode(HEADER_REQUIRED);
            } else {
                this.setFaultCode(INVALID_ADDRESSING_HEADER);
            }
            if (problemHeader != null) {
                try {
                    SOAPHeaderElement detailHeader = new SOAPHeaderElement(FAULT_DETAIL);
                    MessageElement problemEl = new MessageElement(PROBLEM_HEADER, (Object)("wsa:" + problemHeader));
                    detailHeader.addChild(problemEl);
                    this.addHeader(detailHeader);
                }
                catch (SOAPException e) {
                    log.error((Object)e);
                }
            }
        }
        this.setFaultString(faultString);
    }

    public AddressingHeaderFault(String faultString, String problemHeader) {
        this(faultString, null, problemHeader);
    }

    private static String buildMessage(QName code, String header) {
        String localName;
        String string = localName = code == null ? INVALID_ADDRESSING_HEADER.getLocalPart() : code.getLocalPart();
        if ("InvalidCardinality".equals(localName)) {
            return "Duplicate " + header + " header";
        }
        return "Error in " + header + " header";
    }
}

