/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaderFault;
import org.apache.axis.message.addressing.AddressingHeaderItem;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.FaultTo;
import org.apache.axis.message.addressing.From;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.Recipient;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.axis.message.addressing.ReplyTo;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingHeaders {
    private static final Log LOG = LogFactory.getLog(AddressingHeaders.class);
    public boolean isW3CVersion;
    private Action action;
    private ReplyTo replyTo;
    private To to;
    private FaultTo faultTo;
    private From from;
    private Recipient recipient;
    private MessageID messageID;
    private List<RelatesTo> relatesTo;
    private ReferencePropertiesType referenceProperties;
    private ReferenceParametersType referenceParameters;
    private boolean setMustUnderstand;
    private AddressingHeaderFault addrHeaderFault;

    public AddressingHeaders() {
        this.referenceProperties = new ReferencePropertiesType();
        this.referenceParameters = new ReferenceParametersType();
        this.relatesTo = new ArrayList<RelatesTo>();
    }

    public AddressingHeaders(EndpointReference epr) {
        this.to = new To(epr.getAddress());
        this.referenceProperties = epr.getProperties();
        this.referenceParameters = epr.getParameters();
    }

    public AddressingHeaders(SOAPEnvelope env) throws Exception {
        this(env, null, true, false, true, new ArrayList<QName>(0));
    }

    public AddressingHeaders(SOAPEnvelope env, boolean process, boolean remove) throws Exception {
        this(env, null, process, remove, true, new ArrayList<QName>(0));
    }

    public AddressingHeaders(SOAPEnvelope env, String actorURI, boolean process, boolean remove) throws Exception {
        this(env, actorURI, process, remove, true, new ArrayList<QName>(0));
    }

    public AddressingHeaders(SOAPEnvelope env, String actorURI, boolean process, boolean remove, boolean setMustUnderstand, boolean allowNonSpecificActions, List<QName> refPropsQNames) throws Exception {
        this();
        this.setMustUnderstand = setMustUnderstand;
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return;
        }
        Iterator iter = header.examineHeaderElements(actorURI);
        while (iter.hasNext()) {
            javax.xml.soap.SOAPHeaderElement elem = (javax.xml.soap.SOAPHeaderElement)iter.next();
            if (!this.addHeader(elem, allowNonSpecificActions, refPropsQNames)) continue;
            if (remove) {
                elem.detachNode();
            }
            if (!process || !(elem instanceof SOAPHeaderElement)) continue;
            ((SOAPHeaderElement)elem).setProcessed(true);
        }
    }

    public AddressingHeaders(SOAPEnvelope env, String actorURI, boolean process, boolean remove, boolean setMustUnderstand, List<QName> refPropsQNames) throws Exception {
        this(env, actorURI, process, remove, setMustUnderstand, false, refPropsQNames);
    }

    private void addAction(javax.xml.soap.SOAPHeaderElement elem, boolean allowNonSpecificActions) throws URI.MalformedURIException {
        MessageContext msgContext = MessageContext.getCurrentContext();
        if (msgContext != null) {
            msgContext.setProperty("addressing.namespace.URI", (Object)elem.getElementName().getURI());
        }
        if (this.action != null) {
            this.addrHeaderFault = new AddressingHeaderFault("duplicate Action header", AddressingHeaderFault.INVALID_CARDINALITY, "Action");
        }
        URI uri = new URI(TextExtractor.getText((SOAPElement)elem), allowNonSpecificActions);
        this.action = new Action(uri);
    }

    private boolean addHeader(javax.xml.soap.SOAPHeaderElement headerElement, boolean allowNonSpecificActions, List<QName> refPropsQNames) throws URI.MalformedURIException {
        Name name = headerElement.getElementName();
        AddressingVersion version = AddressingUtils.getAddressingVersion(name.getURI());
        if (version != null) {
            this.isW3CVersion = version.isW3C();
            String localName = name.getLocalName();
            if (localName.equals("MessageID")) {
                this.addMessageID(headerElement);
            } else if (localName.equals("To")) {
                this.addTo(headerElement);
            } else if (localName.equals("Action")) {
                this.addAction(headerElement, allowNonSpecificActions);
            } else if (localName.equals("From")) {
                this.addFrom(headerElement);
            } else if (localName.equals("ReplyTo")) {
                this.addReplyTo(headerElement);
            } else if (localName.equals("FaultTo")) {
                this.addFaultTo(headerElement);
            } else if (localName.equals("Recipient")) {
                this.recipient = new Recipient(headerElement);
            } else if (localName.equals("RelatesTo")) {
                this.relatesTo.add(new RelatesTo((SOAPElement)headerElement));
            } else if (localName.equals("FaultDetail")) {
                LOG.debug((Object)"Not done yet");
            } else {
                this.addrHeaderFault = new AddressingHeaderFault("Unsupported addressing header: " + localName, localName);
            }
            return true;
        }
        this.isW3CVersion = false;
        return this.checkReferenceP(headerElement, refPropsQNames);
    }

    private void addFaultTo(javax.xml.soap.SOAPHeaderElement elem) throws URI.MalformedURIException {
        if (this.faultTo == null) {
            this.faultTo = new FaultTo(elem);
        } else {
            this.faultTo = null;
            this.addrHeaderFault = new AddressingHeaderFault(AddressingHeaderFault.INVALID_CARDINALITY, "FaultTo");
        }
    }

    private void addFrom(javax.xml.soap.SOAPHeaderElement elem) throws URI.MalformedURIException {
        if (this.from == null) {
            this.from = new From(elem);
        } else {
            this.addrHeaderFault = new AddressingHeaderFault(AddressingHeaderFault.INVALID_CARDINALITY, "From");
        }
    }

    private void addMessageID(javax.xml.soap.SOAPHeaderElement elem) throws URI.MalformedURIException {
        if (this.messageID == null) {
            this.messageID = new MessageID(elem);
        } else {
            this.addrHeaderFault = new AddressingHeaderFault(AddressingHeaderFault.INVALID_CARDINALITY, "MessageID");
        }
    }

    public void addReferenceParameter(Element param) {
        if (this.referenceParameters == null) {
            this.referenceParameters = new ReferenceParametersType();
        }
        this.referenceParameters.add(param);
    }

    public void addReferenceParameter(MessageElement param) {
        if (this.referenceParameters == null) {
            this.referenceParameters = new ReferenceParametersType();
        }
        this.referenceParameters.add(param);
    }

    public void addReferenceProperty(Element prop) {
        if (this.referenceProperties == null) {
            this.referenceProperties = new ReferencePropertiesType();
        }
        this.referenceProperties.add(prop);
    }

    public void addReferenceProperty(MessageElement prop) {
        if (this.referenceProperties == null) {
            this.referenceProperties = new ReferencePropertiesType();
        }
        this.referenceProperties.add(prop);
    }

    public void addRelatesTo(String uri, QName type) throws URI.MalformedURIException {
        this.relatesTo.add(new RelatesTo(uri, type));
    }

    public void addRelatesTo(String uri, String type) throws URI.MalformedURIException {
        this.relatesTo.add(new RelatesTo(uri, type));
    }

    private void addReplyTo(javax.xml.soap.SOAPHeaderElement elem) throws URI.MalformedURIException {
        if (this.replyTo == null) {
            this.replyTo = new ReplyTo(elem);
        } else {
            this.addrHeaderFault = new AddressingHeaderFault(AddressingHeaderFault.INVALID_CARDINALITY, "ReplyTo");
        }
    }

    private void addTo(javax.xml.soap.SOAPHeaderElement elem) throws URI.MalformedURIException {
        if (this.to == null) {
            this.to = new To(elem);
        } else {
            this.addrHeaderFault = new AddressingHeaderFault(AddressingHeaderFault.INVALID_CARDINALITY, "To");
        }
    }

    private boolean checkReferenceP(javax.xml.soap.SOAPHeaderElement headerElement, List<QName> refPropQNames) {
        Name name = headerElement.getElementName();
        QName elementName = new QName(name.getURI(), name.getLocalName());
        if (refPropQNames == null || refPropQNames.contains(elementName)) {
            this.referenceProperties.add(headerElement);
            return true;
        }
        return false;
    }

    public Action getAction() {
        return this.action;
    }

    public AxisFault getAddrHeaderFault() {
        return this.addrHeaderFault;
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public ReferenceParametersType getReferenceParameters() {
        return this.referenceParameters;
    }

    public ReferencePropertiesType getReferenceProperties() {
        return this.referenceProperties;
    }

    public List<RelatesTo> getRelatesTo() {
        return this.relatesTo;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public To getTo() {
        return this.to;
    }

    public boolean isSetMustUnderstand() {
        return this.setMustUnderstand;
    }

    private javax.xml.soap.SOAPHeaderElement makeSOAPHeader(Object refP) throws SOAPException {
        javax.xml.soap.SOAPHeaderElement element;
        if (refP instanceof javax.xml.soap.SOAPHeaderElement) {
            element = (javax.xml.soap.SOAPHeaderElement)refP;
        } else if (refP instanceof MessageElement) {
            MessageElement msgElement = (MessageElement)refP;
            try {
                element = new SOAPHeaderElement(msgElement.getAsDOM());
            }
            catch (SOAPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SOAPException((Throwable)e);
            }
        } else if (refP instanceof Element) {
            Element refPropElement = (Element)refP;
            element = new SOAPHeaderElement(refPropElement);
        } else {
            throw new SOAPException(refP.getClass().getName());
        }
        return element;
    }

    private void serializeReferencePs(SOAPEnvelope env, List<MessageElement> refPs, String actorURI, boolean addAttribute) throws SOAPException {
        if (refPs == null || refPs.size() == 0) {
            return;
        }
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        for (MessageElement refProp : refPs) {
            javax.xml.soap.SOAPHeaderElement element = this.makeSOAPHeader(refProp);
            element.setActor(actorURI);
            if (addAttribute) {
                element.addAttribute(Constants.ATTR_REFP, "true");
            }
            header.addChildElement((SOAPElement)element);
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setAction(String uri) throws Exception {
        this.action = new Action(new URI(uri));
    }

    public void setAction(URI uri) {
        this.action = uri == null ? null : new Action(uri);
    }

    public void setFaultTo(EndpointReference epr) {
        this.faultTo = new FaultTo(epr);
    }

    public void setFrom(EndpointReference ref) {
        this.from = new From(ref);
    }

    public void setMessageID(MessageID messageID) {
        this.messageID = messageID;
    }

    public void setReferenceParameters(ReferenceParametersType params) {
        this.referenceParameters = params;
    }

    public void setReferenceProperties(ReferencePropertiesType props) {
        this.referenceProperties = props;
    }

    public void setRelatesTo(List<RelatesTo> v) {
        this.relatesTo.clear();
        this.relatesTo.addAll(v);
    }

    public void setReplyTo(EndpointReference ref) {
        this.replyTo = new ReplyTo(ref);
    }

    public void setSetMustUnderstand(boolean setMustUnderstand) {
        this.setMustUnderstand = setMustUnderstand;
    }

    public void setTo(AttributedURI uri) {
        this.to = new To(uri);
    }

    public void setTo(To to) {
        this.to = to;
    }

    public void toEnvelope(SOAPEnvelope env) throws Exception {
        this.toEnvelope(env, null);
    }

    public void toEnvelope(SOAPEnvelope env, String actorURI) throws SOAPException {
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        if (env.getNamespaceURI("wsa") == null) {
            env.addNamespaceDeclaration("wsa", version.getNamespace());
        }
        AddressingUtils.removeHeaders(env.getHeader(), actorURI);
        this.addItem(version, env, actorURI, this.messageID);
        this.addItem(version, env, actorURI, this.to);
        this.addItem(version, env, actorURI, this.action);
        this.addItem(version, env, actorURI, this.from);
        this.addItem(version, env, actorURI, this.replyTo);
        this.addItem(version, env, actorURI, this.faultTo);
        this.addItem(version, env, actorURI, this.recipient);
        if (this.relatesTo != null) {
            for (int i = 0; i < this.relatesTo.size(); ++i) {
                AddressingHeaderItem item = this.relatesTo.get(i);
                this.addItem(version, env, actorURI, item);
            }
        }
        if (this.referenceProperties != null && this.referenceProperties.size() > 0) {
            this.serializeReferencePs(env, this.referenceProperties, actorURI, false);
        }
        if (this.referenceParameters != null && this.referenceParameters.size() > 0) {
            this.serializeReferencePs(env, this.referenceParameters, actorURI, this.isW3CVersion);
        }
    }

    private void addItem(AddressingVersion version, SOAPEnvelope env, String actorURI, AddressingHeaderItem item) throws SOAPException {
        if (item != null) {
            javax.xml.soap.SOAPHeaderElement elem = item.toSOAPHeaderElement(version, env, actorURI);
            elem.setMustUnderstand(this.setMustUnderstand);
        }
    }
}

