/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.DOMAppendable;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnyContentTypeList
extends ArrayList<MessageElement>
implements AnyContentType,
DOMAppendable {
    private static final Log LOG = LogFactory.getLog(AnyContentTypeList.class);

    protected static void fromElement(AnyContentTypeList list, Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            list.add(child);
        }
    }

    protected static void fromSOAPElement(AnyContentTypeList list, SOAPElement element) {
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            if (!(child instanceof SOAPElement)) continue;
            if (child instanceof MessageElement) {
                try {
                    list.add(((MessageElement)child).getAsDOM());
                }
                catch (Exception e) {
                    list.add(child);
                }
                continue;
            }
            list.add(child);
        }
    }

    public AnyContentTypeList() {
    }

    public AnyContentTypeList(AnyContentTypeList src, boolean deepCopy) {
        if (src == null) {
            throw new IllegalArgumentException("Copy from null instance not allowed");
        }
        if (!this.getClass().isAssignableFrom(src.getClass())) {
            throw new IllegalArgumentException("Copy from a " + src.getClass().getName() + " instance into a " + this.getClass().getName() + " not allowed");
        }
        if (deepCopy) {
            for (MessageElement elem : src) {
                try {
                    this.add(new MessageElement(elem.getAsDOM()));
                }
                catch (Exception e) {
                    this.add(elem);
                }
            }
        } else {
            this.addAll(src);
        }
    }

    public AnyContentTypeList(Object element) {
        this.add(element);
    }

    public void add(Object item) {
        MessageElement value = null;
        if (item instanceof MessageElement) {
            value = (MessageElement)item;
        } else if (item instanceof Element) {
            value = new MessageElement((Element)item);
        } else {
            throw new IllegalArgumentException();
        }
        this.add(value);
    }

    @Override
    public void append(Element parent, String elementName) {
        this.append(AddressingUtils.getAddressingVersion(), parent, elementName);
    }

    @Override
    public void append(AddressingVersion version, Element parent, String elementName) {
        int size = this.size();
        if (size == 0) {
            return;
        }
        Document doc = parent.getOwnerDocument();
        String ns = version.getNamespace();
        Element elem = doc.createElementNS(ns, elementName);
        try {
            for (MessageElement item : this) {
                elem.appendChild(doc.importNode(item.getAsDOM(), true));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error appending child element", (Throwable)e);
        }
        parent.appendChild(elem);
    }

    public MessageElement get(QName qname) {
        for (MessageElement elem : this) {
            QName name = elem == null ? null : elem.getQName();
            if (name == null || !name.equals(qname)) continue;
            return elem;
        }
        return null;
    }

    public MessageElement[] get_any() {
        return this.toArray(new MessageElement[this.size()]);
    }

    public void set_any(MessageElement[] any) {
        this.clear();
        for (MessageElement elem : any) {
            this.add(elem);
        }
    }

    protected String toString(String itemName) {
        StringBuffer buf = new StringBuffer();
        buf.append(itemName);
        for (int i = 0; i < this.size(); ++i) {
            buf.append(i == 0 ? ": { " : ", ");
            MessageElement item = (MessageElement)this.get(i);
            try {
                buf.append(item.getAsString());
                continue;
            }
            catch (Exception e) {
                buf.append("<error converting: " + e.getMessage() + ">");
            }
        }
        buf.append(" }");
        return buf.toString();
    }
}

