/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaderItem;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.DOMAppendable;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.types.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttributedURI
extends URI
implements DOMAppendable,
AddressingHeaderItem {
    private static final long serialVersionUID = -3363815864897359681L;

    public AttributedURI() {
    }

    public AttributedURI(SOAPHeaderElement el) throws URI.MalformedURIException {
        this(TextExtractor.getText((SOAPElement)el).trim());
    }

    public AttributedURI(String uri) throws URI.MalformedURIException {
        super(new URI(uri.trim()));
    }

    public AttributedURI(URI uri) {
        super(uri);
    }

    public String getDefaultElementName() {
        return "";
    }

    public final void append(Element parent) {
        this.append(parent, this.getDefaultElementName());
    }

    public final void append(Element parent, String elementName) {
        this.append(AddressingUtils.getAddressingVersion(), parent, elementName);
    }

    public final void append(AddressingVersion version, Element parent, String elemName) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElementNS(version.getNamespace(), elemName);
        child.appendChild(doc.createTextNode(this.toString()));
        parent.appendChild(child);
    }

    public final SOAPHeaderElement toSOAPHeaderElement(AddressingVersion version, SOAPEnvelope env, String actorURI) throws SOAPException {
        return this.toSOAPHeaderElement(version, env, actorURI, this.getDefaultElementName());
    }

    protected SOAPHeaderElement toSOAPHeaderElement(AddressingVersion version, SOAPEnvelope env, String actorURI, String name) throws SOAPException {
        if (name == null) {
            throw new IllegalArgumentException("A null name is not allowed.");
        }
        Name qname = env.createName(name, "wsa", version.getNamespace());
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        SOAPHeaderElement headerElement = header.addHeaderElement(qname);
        headerElement.setActor(actorURI);
        headerElement.addTextNode(this.toString());
        return headerElement;
    }

    public final SOAPHeaderElement toSOAPHeaderElement(SOAPEnvelope env, String actorURI) throws SOAPException {
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        return this.toSOAPHeaderElement(version, env, actorURI);
    }
}

