/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaderItem;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.DOMAppendable;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.MetaDataType;
import org.apache.axis.message.addressing.PortType;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndpointReference
extends EndpointReferenceType
implements AddressingHeaderItem {
    private static final long serialVersionUID = -1650335889022891672L;
    private static final Log LOG = LogFactory.getLog(EndpointReference.class);

    public EndpointReference(Address address) {
        this.setAddress(address);
    }

    public EndpointReference(Element element) throws URI.MalformedURIException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            String ns;
            Node node = children.item(i);
            if (!(node instanceof Element) || AddressingUtils.getAddressingVersion(ns = (child = (Element)node).getNamespaceURI()) == null) continue;
            String localName = child.getLocalName();
            if ("Address".equals(localName)) {
                this.setAddress(Address.fromElement(child));
                continue;
            }
            if ("PortType".equals(localName)) {
                this.setPortType(PortType.fromElement(child));
                continue;
            }
            if ("ServiceName".equals(localName)) {
                this.setServiceName(ServiceNameType.fromElement(child));
                continue;
            }
            if ("ReferenceProperties".equals(localName)) {
                this.setProperties(ReferencePropertiesType.fromElement(child));
                continue;
            }
            if ("ReferenceParameters".equals(localName)) {
                this.setParameters(ReferenceParametersType.fromElement(child));
                continue;
            }
            if (!"Metadata".equals(localName)) continue;
            this.setMetadata(MetaDataType.fromElement(child));
        }
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Specified element does not contain the required 'wsa:Address' child element.");
        }
    }

    public EndpointReference(EndpointReferenceType endpoint) {
        super(endpoint);
    }

    public EndpointReference(SOAPElement element) throws URI.MalformedURIException {
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            SOAPElement child;
            String ns;
            Object node = iter.next();
            if (!(node instanceof SOAPElement) || AddressingUtils.getAddressingVersion(ns = (child = (SOAPElement)node).getNamespaceURI()) == null) continue;
            String localName = child.getLocalName();
            if ("Address".equals(localName)) {
                this.setAddress(Address.fromSOAPElement(child));
                continue;
            }
            if ("PortType".equals(localName)) {
                this.setPortType(PortType.fromSOAPElement(child));
                continue;
            }
            if ("ServiceName".equals(localName)) {
                this.setServiceName(ServiceNameType.fromSOAPElement(child));
                continue;
            }
            if ("ReferenceProperties".equals(localName)) {
                this.setProperties(ReferencePropertiesType.fromSOAPElement(child));
                continue;
            }
            if ("ReferenceParameters".equals(localName)) {
                this.setParameters(ReferenceParametersType.fromSOAPElement(child));
                continue;
            }
            if (!"Metadata".equals(localName)) continue;
            this.setMetadata(MetaDataType.fromSOAPElement(child));
        }
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Specified element does not contain the required 'wsa:Address' child element.");
        }
    }

    public EndpointReference(String endpoint) throws URI.MalformedURIException {
        this.setAddress(new Address(endpoint));
    }

    public EndpointReference(URI uri) {
        if (uri != null) {
            this.setAddress(new Address(uri));
        }
    }

    public void addMetadata(MessageElement data) {
        if (this.metaData == null) {
            this.metaData = new MetaDataType();
        }
        this.metaData.add(data);
    }

    public void addReferenceParameter(MessageElement param) {
        this.getParameters().add(param);
    }

    public void addReferenceProperty(MessageElement prop) {
        this.getProperties().add(prop);
    }

    public Element toDOM(Document doc) {
        return this.toDOM(doc, "EndpointReference");
    }

    public Element toDOM(Document doc, String elementName) {
        if (doc == null) {
            try {
                doc = XMLUtils.newDocument();
            }
            catch (ParserConfigurationException pce) {
                LOG.error((Object)"Error creating XML document", (Throwable)pce);
                return null;
            }
        }
        Element elem = this.toDOMInternal(doc, elementName);
        if (doc.getDocumentElement() == null) {
            doc.appendChild(elem);
        } else {
            doc.getDocumentElement().appendChild(elem);
        }
        return elem;
    }

    private Element toDOMInternal(Document doc, String elementName) {
        MessageElement[] any;
        int ix = elementName.indexOf(":");
        String prefix = "";
        if (ix != -1) {
            prefix = elementName.substring(0, ix);
        }
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        String ns = version.getNamespace();
        Element parent = doc.createElementNS(ns, elementName);
        if (prefix.equals("")) {
            parent.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", ns);
        } else {
            parent.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
            prefix = prefix + ":";
        }
        this.append(this.getAddress(), version, parent, prefix + "Address");
        this.append(this.getPortType(), version, parent, prefix + "PortType");
        this.append(this.getServiceName(), version, parent, prefix + "ServiceName");
        if (version.supportsProperties()) {
            this.append(this.getProperties(), version, parent, prefix + "ReferenceProperties");
        }
        if (version.supportsParameters()) {
            this.append(this.getParameters(), version, parent, prefix + "ReferenceParameters");
        }
        if (version.supportsMetadata()) {
            this.append(this.getMetadata(), version, parent, prefix + "Metadata");
        }
        if ((any = this.get_any()) != null && any.length > 0) {
            for (MessageElement element : any) {
                try {
                    parent.appendChild(doc.importNode(element.getAsDOM(), true));
                }
                catch (Exception e) {
                    LOG.debug((Object)"", (Throwable)e);
                }
            }
        }
        return parent;
    }

    private void append(DOMAppendable appendable, AddressingVersion version, Element parent, String elementName) {
        if (appendable != null) {
            appendable.append(version, parent, elementName);
        }
    }

    public javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(AddressingVersion version, javax.xml.soap.SOAPEnvelope env, String actorURI) throws SOAPException {
        return this.toSOAPHeaderElement(version, env, actorURI, "EndpointReference");
    }

    public javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(javax.xml.soap.SOAPEnvelope env, String actorURI) throws SOAPException {
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        return this.toSOAPHeaderElement(version, env, actorURI);
    }

    protected javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(AddressingVersion version, javax.xml.soap.SOAPEnvelope env, String actorURI, String name) throws SOAPException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter must be non-null.");
        }
        if (env == null) {
            throw new IllegalArgumentException("Env parameter must be non-null.");
        }
        if (env instanceof SOAPEnvelope) {
            SOAPHeader header = env.getHeader();
            if (header == null) {
                env.addHeader();
            }
            try {
                Document doc = XMLUtils.newDocument();
                SOAPHeaderElement headerElem = new SOAPHeaderElement(this.toDOM(doc, name));
                headerElem.setActor(actorURI);
                ((SOAPEnvelope)env).addHeader(headerElem);
                return headerElem;
            }
            catch (Exception e) {
                throw new SOAPException("Could not create XML document", (Throwable)e);
            }
        }
        throw new SOAPException("SOAPEnvelope implementation not supported: " + env.getClass().getName());
    }
}

