/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedQName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.MetaDataType;
import org.apache.axis.message.addressing.PortType;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.types.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceType
implements AnyContentType,
Serializable {
    private static final long serialVersionUID = 16342863069452848L;
    private static final TypeDesc TYPE_DESC = new TypeDesc(EndpointReferenceType.class, true);
    private Address address;
    private PortType portType;
    private ServiceNameType serviceName;
    private ReferencePropertiesType properties;
    private ReferenceParametersType parameters;
    protected MetaDataType metaData;
    private MessageElement[] any;

    public static Deserializer getDeserializer(String mType, Class<?> jType, QName xType) {
        return new BeanDeserializer(jType, xType, TYPE_DESC);
    }

    public static Serializer getSerializer(String mType, Class<?> jType, QName xType) {
        return new BeanSerializer(jType, xType, TYPE_DESC);
    }

    public static TypeDesc getTypeDesc() {
        return TYPE_DESC;
    }

    public EndpointReferenceType() {
    }

    public EndpointReferenceType(Address address) {
        this.address = address;
    }

    public EndpointReferenceType(EndpointReferenceType endpoint) {
        this(endpoint, false);
    }

    public EndpointReferenceType(EndpointReferenceType endpoint, boolean deepCopy) {
        if (deepCopy) {
            this.deepCopy(endpoint);
        } else {
            this.shallowCopy(endpoint);
        }
    }

    public EndpointReferenceType(URI addr) {
        this.address = new Address(addr);
    }

    private MessageElement[] copy(MessageElement[] elems, boolean deep) {
        if (elems == null || elems.length == 0) {
            return new MessageElement[0];
        }
        if (deep) {
            MessageElement[] copy = new MessageElement[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                MessageElement elem = elems[i];
                try {
                    copy[i] = new MessageElement(elem.getAsDOM());
                    continue;
                }
                catch (Exception e) {
                    copy[i] = elem;
                }
            }
            return copy;
        }
        MessageElement[] copy = new MessageElement[elems.length];
        System.arraycopy(elems, 0, copy, 0, elems.length);
        return copy;
    }

    private void deepCopy(EndpointReferenceType endpoint) {
        MetaDataType metadata;
        ReferenceParametersType params;
        ReferencePropertiesType props;
        ServiceNameType sName;
        AttributedQName port;
        AttributedURI addr = endpoint.getAddress();
        if (addr != null) {
            this.setAddress(new Address(addr));
        }
        if ((port = endpoint.getPortType()) != null) {
            this.setPortType(new PortType(port));
        }
        if ((sName = endpoint.getServiceName()) != null) {
            this.setServiceName(new ServiceNameType(sName));
        }
        if ((props = endpoint.getProperties()) != null) {
            this.setProperties(new ReferencePropertiesType(props, true));
        }
        if ((params = endpoint.getParameters()) != null) {
            this.setParameters(params);
        }
        if ((metadata = endpoint.getMetadata()) != null) {
            this.setMetadata(metadata);
        }
        MessageElement[] elems = endpoint.get_any();
        this.set_any(this.copy(elems, true));
    }

    public MessageElement[] get_any() {
        return this.any == null ? null : (MessageElement[])this.any.clone();
    }

    public AttributedURI getAddress() {
        return this.address;
    }

    public MetaDataType getMetadata() {
        return this.metaData;
    }

    public ReferenceParametersType getParameters() {
        if (this.parameters == null) {
            this.parameters = new ReferenceParametersType();
        }
        return this.parameters;
    }

    public AttributedQName getPortType() {
        return this.portType;
    }

    public ReferencePropertiesType getProperties() {
        if (this.properties == null) {
            this.properties = new ReferencePropertiesType();
        }
        return this.properties;
    }

    public ServiceNameType getServiceName() {
        return this.serviceName;
    }

    public void set_any(MessageElement[] any) {
        this.any = any == null ? null : (MessageElement[])any.clone();
    }

    public void setAddress(AttributedURI addr) {
        this.address = addr instanceof Address ? (Address)addr : (addr == null ? null : new Address(addr));
    }

    public void setMetadata(MetaDataType metaData) {
        this.metaData = metaData;
    }

    public void setParameters(ReferenceParametersType parameters) {
        this.parameters = parameters;
    }

    public void setPortType(AttributedQName portType) {
        this.portType = portType instanceof PortType ? (PortType)portType : (portType == null ? null : new PortType(portType));
    }

    public void setProperties(ReferencePropertiesType properties) {
        this.properties = properties;
    }

    public void setServiceName(ServiceNameType serviceName) {
        this.serviceName = serviceName;
    }

    private void shallowCopy(EndpointReferenceType endpoint) {
        MetaDataType metadata;
        ReferenceParametersType params;
        this.setAddress(endpoint.getAddress());
        this.setPortType(endpoint.getPortType());
        this.setServiceName(endpoint.getServiceName());
        ReferencePropertiesType props = endpoint.getProperties();
        if (props != null) {
            this.setProperties(new ReferencePropertiesType(props, false));
        }
        if ((params = endpoint.getParameters()) != null) {
            this.setParameters(new ReferenceParametersType(params, false));
        }
        if ((metadata = endpoint.getMetadata()) != null) {
            this.setMetadata(new MetaDataType(metadata, false));
        }
        MessageElement[] elems = endpoint.get_any();
        this.set_any(elems);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.address != null) {
            buf.append("Address: ").append(this.address);
            buf.append("\n");
        }
        if (this.portType != null) {
            buf.append("Port Type: ").append(this.portType);
            buf.append("\n");
        }
        if (this.serviceName != null) {
            buf.append("Service Name: ").append(this.serviceName);
            buf.append("\n");
            if (this.serviceName.getPort() != null) {
                buf.append("Port Name: ").append(this.serviceName.getPort());
                buf.append("\n");
            }
        }
        if (this.properties != null) {
            buf.append(this.properties);
            buf.append("\n");
        }
        if (this.parameters != null) {
            buf.append(this.parameters);
            buf.append("\n");
        }
        if (this.metaData != null) {
            buf.append(this.metaData);
            buf.append("\n");
        }
        if (this.any != null) {
            for (int i = 0; i < this.any.length; ++i) {
                buf.append("Extensibility Element[").append(i).append("]:\n");
                try {
                    buf.append(this.any[i].getAsString());
                }
                catch (Exception e) {
                    buf.append("<error converting: ").append(e.getMessage()).append(">");
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    static {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        TYPE_DESC.setXmlType(new QName(ns, "EndpointReferenceType"));
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("address");
        elemField.setXmlName(new QName(ns, "Address"));
        elemField.setXmlType(new QName(ns, "Address"));
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("properties");
        elemField.setXmlName(new QName(ns, "ReferenceProperties"));
        elemField.setXmlType(new QName(ns, "ReferencePropertiesType"));
        elemField.setMinOccurs(0);
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("parameters");
        elemField.setXmlName(new QName(ns, "ReferenceParameters"));
        elemField.setXmlType(new QName(ns, "ReferenceParametersType"));
        elemField.setMinOccurs(0);
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("portType");
        elemField.setXmlName(new QName(ns, "PortType"));
        elemField.setXmlType(new QName(ns, "PortType"));
        elemField.setMinOccurs(0);
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("serviceName");
        elemField.setXmlName(new QName(ns, "ServiceName"));
        elemField.setXmlType(new QName(ns, "ServiceNameType"));
        elemField.setMinOccurs(0);
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("metadata");
        elemField.setXmlName(new QName(ns, "Metadata"));
        elemField.setXmlType(new QName(ns, "MetadataType"));
        elemField.setMinOccurs(0);
        TYPE_DESC.addFieldDesc((FieldDesc)elemField);
    }
}

