/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaderItem;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.Relationship;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.types.URI;

public class RelatesTo
extends Relationship
implements AddressingHeaderItem {
    public RelatesTo(SOAPElement element) throws URI.MalformedURIException {
        AddressingVersion version = AddressingUtils.getAddressingVersion(element.getNamespaceURI());
        this.setURI(new URI(TextExtractor.getText(element)));
        String value = element.getAttribute("RelationshipType");
        if (value != null && value.length() > 0) {
            if (version.isW3C()) {
                this.setTypeIRI(value);
            } else {
                int pos = value.indexOf(58);
                if (pos == -1) {
                    this.setType(new QName(value));
                } else {
                    String namespace = element.getNamespaceURI(value.substring(0, pos));
                    this.setType(new QName(namespace, value.substring(pos + 1)));
                }
            }
        } else {
            this.setType(version.getResponseRelationshipType());
        }
    }

    public RelatesTo(String uri, QName type) throws URI.MalformedURIException {
        super(new URI(uri), type);
    }

    public RelatesTo(String uri, String type) throws URI.MalformedURIException {
        super(uri, type);
    }

    public RelatesTo(URI uri, QName type) {
        super(uri, type);
    }

    public SOAPHeaderElement toSOAPHeaderElement(SOAPEnvelope env, String actorURI) throws SOAPException {
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        return this.toSOAPHeaderElement(version, env, actorURI);
    }

    public SOAPHeaderElement toSOAPHeaderElement(AddressingVersion version, SOAPEnvelope env, String actorURI) throws SOAPException {
        Name nm = env.createName("RelatesTo", "wsa", version.getNamespace());
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        SOAPHeaderElement headerElement = (SOAPHeaderElement)header.addHeaderElement(nm);
        headerElement.setActor(actorURI);
        String typeIRI = this.getTypeIRI();
        QName type = this.getType();
        if (typeIRI != null) {
            headerElement.addAttribute("", "RelationshipType", typeIRI);
        } else if (type != null) {
            headerElement.addAttribute("", "RelationshipType", type);
        }
        headerElement.addTextNode(this.getURI().toString());
        return headerElement;
    }
}

