/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.encoding.ser.SimpleSerializer;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.AttributedQName;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceNameType
extends AttributedQName
implements SimpleType {
    private static final long serialVersionUID = 4494158339591159503L;
    private static final TypeDesc TYPE_DESC = new TypeDesc(ServiceNameType.class, true);
    private String port;

    public static ServiceNameType fromElement(Element element) {
        String value = TextExtractor.getText(element);
        QName qname = XMLUtils.getQNameFromString((String)value, (Node)element);
        String portName = element.getAttribute("PortName");
        portName = portName == null || portName.length() == 0 ? null : portName;
        return new ServiceNameType(qname, portName);
    }

    public static ServiceNameType fromSOAPElement(SOAPElement element) {
        String value = TextExtractor.getText(element);
        QName qname = TextExtractor.getQName(value, element);
        String portName = element.getAttribute("PortName");
        portName = portName == null || portName.length() == 0 ? null : portName;
        return new ServiceNameType(qname, portName);
    }

    public static Deserializer getDeserializer(String mType, Class<?> jType, QName xType) {
        return new SimpleDeserializer(jType, xType, TYPE_DESC);
    }

    public static Serializer getSerializer(String mType, Class<?> jType, QName xType) {
        return new SimpleSerializer(jType, xType, TYPE_DESC);
    }

    public static TypeDesc getTypeDesc() {
        return TYPE_DESC;
    }

    public ServiceNameType(QName qname) {
        super(qname);
    }

    public ServiceNameType(QName qname, String port) {
        super(qname);
        this.port = port;
    }

    public ServiceNameType(ServiceNameType serviceName) {
        super(serviceName);
        this.port = serviceName.getPort();
    }

    public ServiceNameType(String namespace, String localName) {
        super(namespace, localName);
    }

    @Override
    public void append(AddressingVersion version, Element parent, String elementName) {
        Element sn = parent.getOwnerDocument().createElementNS(version.getNamespace(), elementName);
        String value = XMLUtils.getStringForQName((QName)this, (Element)sn);
        sn.appendChild(parent.getOwnerDocument().createTextNode(value));
        if (this.getPort() != null) {
            sn.setAttribute("PortName", this.getPort());
        }
        parent.appendChild(sn);
    }

    @Override
    public void append(Element parent) {
        this.append(parent, "ServiceName");
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    static {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        TYPE_DESC.setXmlType(new QName(ns, "ServiceNameType"));
        AttributeDesc attrField = new AttributeDesc();
        attrField.setFieldName("port");
        attrField.setXmlName(new QName("", "PortName"));
        attrField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        TYPE_DESC.addFieldDesc((FieldDesc)attrField);
    }
}

