/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaderFault;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingHandler
extends BasicHandler
implements org.apache.axis.message.addressing.Constants {
    private static final long serialVersionUID = 831310304473973743L;
    protected static final Log LOG = LogFactory.getLog(AddressingHandler.class);
    private static UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private List<QName> refPropQNames;
    private String actor;
    private boolean removeHeaders = false;
    private boolean allowNonSpecificActions = false;
    private static final String OPT_CATCH_OWN_FAULTS = "handler.catchOwnFaults";

    public void init() {
        super.init();
        this.initializeReferencePropertyNames();
        this.initializeRemoveHeaders();
        this.initializeActor();
        this.initializeAllowNonSpecificActions();
        Boolean catchOwnFaults = (Boolean)this.getOption(OPT_CATCH_OWN_FAULTS);
        if (catchOwnFaults == null) {
            this.setOption(OPT_CATCH_OWN_FAULTS, Boolean.TRUE);
        }
    }

    protected void initializeActor() {
        this.actor = (String)this.getOption("actor");
    }

    private void initializeRemoveHeaders() {
        String property = (String)this.getOption("removeHeaders");
        this.removeHeaders = "true".equalsIgnoreCase(property);
    }

    private void initializeAllowNonSpecificActions() {
        String property = (String)this.getOption("allowNonSpecificActions");
        this.allowNonSpecificActions = "true".equalsIgnoreCase(property);
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean setMustUnderstand = msgContext.isPropertyTrue("addressing.setMustUnderstand");
        try {
            if (msgContext.isClient()) {
                if (!msgContext.getPastPivot()) {
                    this.processClientRequest(msgContext, setMustUnderstand);
                } else {
                    this.processClientResponse(msgContext);
                }
            } else if (!msgContext.getPastPivot()) {
                this.processServerRequest(msgContext);
            } else {
                this.processServerResponse(msgContext, setMustUnderstand);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in AddressingHandler", (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void onFault(MessageContext msgContext) {
        if (msgContext.isClient()) {
            return;
        }
        try {
            this.processFault(msgContext);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in AddressingHandler", (Throwable)e);
        }
    }

    protected void processFault(MessageContext ctx) throws Exception {
        To toURI;
        Message msg = ctx.getResponseMessage();
        if (msg == null) {
            return;
        }
        AddressingVersion version = AddressingUtils.getAddressingVersion((javax.xml.rpc.handler.MessageContext)ctx);
        SOAPFault el = (SOAPFault)msg.getSOAPEnvelope().getFirstBody();
        if (el.getFault().getFaultCode().equals(ctx.getSOAPConstants().getMustunderstandFaultQName())) {
            return;
        }
        AddressingHeaders reqHeaders = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
        if (reqHeaders == null) {
            return;
        }
        AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders((javax.xml.rpc.handler.MessageContext)ctx);
        EndpointReference fromEPR = resHeaders.getFrom();
        if (fromEPR == null && (toURI = reqHeaders.getTo()) != null) {
            fromEPR = new EndpointReference(toURI);
            fromEPR.setProperties(reqHeaders.getReferenceProperties());
            resHeaders.setFrom(fromEPR);
        }
        URI actionURI = new URI(version.getFaultActionURI(), this.allowNonSpecificActions);
        resHeaders.setAction(actionURI);
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), version.getResponseRelationshipType());
        }
        msgID = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
        resHeaders.setMessageID(msgID);
        EndpointReference faultTo = reqHeaders.getFaultTo();
        if (faultTo == null) {
            faultTo = reqHeaders.getReplyTo();
        }
        if (faultTo != null) {
            String uri;
            resHeaders.setReferenceProperties(faultTo.getProperties());
            resHeaders.setReferenceParameters(faultTo.getParameters());
            AttributedURI address = faultTo.getAddress();
            if (address != null && (uri = address.toString()) != null && !uri.equals(version.getAnonymousRoleURI())) {
                if (!uri.equals("http://www.w3.org/2005/08/addressing/none")) {
                    this.forwardMessage(faultTo, msg);
                }
                ctx.setResponseMessage(null);
                ctx.setProperty("axis.DontEmitFault", (Object)Boolean.TRUE);
                return;
            }
        }
        resHeaders.toEnvelope((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope());
    }

    protected void processClientRequest(MessageContext ctx, boolean setMustUnderstand) throws Exception {
        String faultTo;
        String action;
        To to;
        boolean sendDefaultFrom = ctx.isPropertyTrue("addressing.sendDefaultFrom", true);
        boolean sendDefaultMessageID = ctx.isPropertyTrue("addressing.sendDefaultID", true);
        boolean sendDefaultTo = ctx.isPropertyTrue("addressing.sendDefaultTo", true);
        AddressingHeaders sharedHeaders = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.SHARED_HEADERS");
        AddressingHeaders headers = AddressingUtils.getRequestHeaders((javax.xml.rpc.handler.MessageContext)ctx);
        headers.setSetMustUnderstand(setMustUnderstand);
        if (headers.getMessageID() == null && sendDefaultMessageID) {
            MessageID id = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
            headers.setMessageID(id);
        }
        if ((to = headers.getTo()) == null && sendDefaultTo) {
            if (sharedHeaders != null) {
                headers.setTo(sharedHeaders.getTo());
            } else {
                headers.setTo(new To(ctx.getStrProp("transport.url")));
            }
        }
        if ((action = ctx.getSOAPActionURI()) != null) {
            URI actionURI = new URI(action, this.allowNonSpecificActions);
            headers.setAction(new Action(actionURI));
        } else {
            Action act = headers.getAction();
            if (act == null) {
                URI actionURI = new URI("http://apache.org/axis/defaultAction");
                headers.setAction(new Action(actionURI));
            }
            ctx.setUseSOAPAction(true);
            ctx.setSOAPActionURI(headers.getAction().toString());
        }
        if (headers.getFrom() == null && sendDefaultFrom) {
            String from = ctx.getStrProp("addressing.from.URI");
            if (from == null) {
                from = AddressingUtils.getAddressingVersion().getAnonymousRoleURI();
            }
            headers.setFrom(new EndpointReference(from));
        }
        if (ctx.isPropertyTrue("addressing.sendReplyTo") && headers.getReplyTo() == null) {
            String replyTo = ctx.getStrProp("addressing.replyTo.URI");
            if (replyTo != null) {
                headers.setReplyTo(new EndpointReference(replyTo));
            } else {
                headers.setReplyTo(headers.getFrom());
            }
        }
        if (headers.getFaultTo() == null && (faultTo = ctx.getStrProp("addressing.faultTo.URI")) != null) {
            headers.setFaultTo(new EndpointReference(faultTo));
        }
        if (sharedHeaders != null) {
            headers.setReferenceProperties(sharedHeaders.getReferenceProperties());
        }
        Message msg = ctx.getRequestMessage();
        headers.toEnvelope((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope(), this.actor);
    }

    protected void processClientResponse(MessageContext ctx) throws Exception {
        Message msg = ctx.getResponseMessage();
        if (msg == null) {
            return;
        }
        AddressingHeaders headers = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope(), this.actor, true, this.removeHeaders, false, this.allowNonSpecificActions, this.refPropQNames);
        ctx.setProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS", (Object)headers);
    }

    protected void processServerRequest(MessageContext ctx) throws Exception {
        boolean isAddrRequired = ctx.isPropertyTrue("addressing.required", true);
        Message msg = ctx.getRequestMessage();
        if (msg == null) {
            return;
        }
        AddressingHeaders headers = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope(), this.actor, true, this.removeHeaders, false, this.allowNonSpecificActions, this.refPropQNames);
        AxisFault fault = headers.getAddrHeaderFault();
        if (isAddrRequired && headers.getAction() == null) {
            if (ctx.getProperty("addressing.namespace.URI") == null) {
                ctx.setProperty("addressing.namespace.URI", (Object)"http://www.w3.org/2005/08/addressing");
            }
            fault = new AddressingHeaderFault("No Action header", AddressingHeaderFault.HEADER_REQUIRED, "Action");
            LOG.debug((Object)("WS-A request to endpoint " + headers.getTo() + " is missing the required wsa:Action header."));
        }
        ctx.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        if (fault != null) {
            throw fault;
        }
        if (ctx.getService() == null && ctx.getTargetService() == null) {
            this.setTargetService(ctx, headers);
            if (ctx.getService() != null) {
                this.resetOperations(ctx);
            }
        }
    }

    protected void resetOperations(MessageContext ctx) throws AxisFault {
        AddressingHandler.resetContextOperations(ctx);
    }

    public static void resetContextOperations(MessageContext ctx) throws AxisFault {
        Message msg = ctx.getCurrentMessage();
        if (msg == null) {
            return;
        }
        SOAPEnvelope env = msg.getSOAPEnvelope();
        if (env == null) {
            return;
        }
        SOAPBodyElement bodyElement = env.getFirstBody();
        if (bodyElement != null && bodyElement instanceof RPCElement) {
            RPCElement element = (RPCElement)bodyElement;
            element.updateOperationsByQName();
            OperationDesc[] operations = element.getOperations();
            if (operations == null) {
                element.updateOperationsByName();
            } else if (operations.length == 1) {
                ctx.setOperation(operations[0]);
            }
        } else {
            msg.getSOAPPartAsString();
        }
    }

    protected void setTargetService(MessageContext ctx, AddressingHeaders headers) throws Exception {
        To toURI = headers.getTo();
        if (toURI == null) {
            return;
        }
        String to = toURI.getPath();
        if (to == null) {
            return;
        }
        int i = to.lastIndexOf(47);
        ctx.setTargetService(to.substring(i + 1));
    }

    protected void processServerResponse(MessageContext ctx, boolean setMustUnderstand) throws Exception {
        Action action;
        To toURI;
        Message msg = ctx.getResponseMessage();
        if (msg == null) {
            return;
        }
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        AddressingHeaders reqHeaders = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
        if (reqHeaders == null) {
            return;
        }
        AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders((javax.xml.rpc.handler.MessageContext)ctx);
        resHeaders.setSetMustUnderstand(setMustUnderstand);
        EndpointReference fromEPR = resHeaders.getFrom();
        if (fromEPR == null && (toURI = reqHeaders.getTo()) != null) {
            fromEPR = new EndpointReference(toURI);
            fromEPR.setProperties(reqHeaders.getReferenceProperties());
            resHeaders.setFrom(fromEPR);
        }
        if ((action = resHeaders.getAction()) == null) {
            String respAction = ctx.getStrProp("addressing.responseAction");
            if (respAction == null) {
                action = reqHeaders.getAction();
                if (action != null) {
                    URI actionURI = new URI(action.toString() + "Response", this.allowNonSpecificActions);
                    resHeaders.setAction(new Action(actionURI));
                }
            } else {
                resHeaders.setAction(new Action(new URI(respAction)));
            }
        }
        if (resHeaders.getFrom() == null && reqHeaders.getFrom() != null) {
            resHeaders.setTo(reqHeaders.getFrom().getAddress());
        } else {
            resHeaders.setTo(new To(version.getAnonymousRoleURI()));
        }
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), version.getResponseRelationshipType());
        }
        msgID = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
        resHeaders.setMessageID(msgID);
        EndpointReference replyTo = reqHeaders.getReplyTo();
        if (replyTo != null) {
            resHeaders.setReferenceProperties(replyTo.getProperties());
            resHeaders.setReferenceParameters(replyTo.getParameters());
            AttributedURI address = replyTo.getAddress();
            if (address != null) {
                String uri = address.toString();
                if (uri != null && !uri.equals(version.getAnonymousRoleURI())) {
                    if (!uri.equals("http://www.w3.org/2005/08/addressing/none")) {
                        this.forwardMessage(replyTo, msg);
                    }
                    ctx.setResponseMessage(null);
                } else {
                    resHeaders.toEnvelope((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope(), this.actor);
                }
            }
        } else {
            resHeaders.toEnvelope((javax.xml.soap.SOAPEnvelope)msg.getSOAPEnvelope(), this.actor);
        }
    }

    protected void forwardMessage(EndpointReferenceType epr, Message msg) throws Exception {
        AttributedURI address = epr.getAddress();
        AddressingHeaders headers = null;
        MessageContext ctx = msg.getMessageContext();
        if (ctx != null) {
            headers = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        }
        if (headers == null) {
            headers = new AddressingHeaders();
            headers.setTo(address);
            headers.setReferenceProperties(epr.getProperties());
            headers.setReferenceParameters(epr.getParameters());
        }
        Service service = this.getService(ctx);
        Call c = (Call)service.createCall();
        c.setSOAPVersion(ctx == null ? Constants.DEFAULT_SOAP_VERSION : ctx.getSOAPConstants());
        c.setTargetEndpointAddress(address.toString());
        c.setRequestMessage(msg);
        c.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        c.setProperty("addressing.namespace.URI", (Object)AddressingUtils.getAddressingNamespaceURI((javax.xml.rpc.handler.MessageContext)ctx));
        if (ctx != null) {
            c.setProperty("sendXsiTypes", ctx.getProperty("sendXsiTypes"));
            c.setOperationStyle(ctx.getOperationStyle());
            c.setOperationUse(ctx.getOperationUse());
        }
        this.configureCall(c, ctx);
        try {
            c.invoke();
        }
        catch (AxisFault axisFault) {
            LOG.error((Object)axisFault.dumpToString());
        }
    }

    protected Service getService(MessageContext ctx) {
        return new Service();
    }

    protected void configureCall(Call call, MessageContext oldContext) {
    }

    private void initializeReferencePropertyNames() {
        String refPropNames = (String)this.getOption("referencePropertyNames");
        if (refPropNames == null) {
            this.refPropQNames = new ArrayList<QName>();
        } else if (refPropNames.equals("*")) {
            this.refPropQNames = null;
        } else {
            this.refPropQNames = new ArrayList<QName>();
            StringTokenizer tkn = new StringTokenizer(refPropNames, ",");
            while (tkn.hasMoreTokens()) {
                String qnameString = tkn.nextToken().trim();
                try {
                    QName qname = QName.valueOf(qnameString);
                    this.refPropQNames.add(qname);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Invalid QName ignored: " + qnameString));
                }
            }
        }
    }
}

