/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.handler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.handler.GenericAxisHandler;
import org.apache.ws.addressing.handler.ServerSideAddressingHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisServerSideAddressingHandler
extends ServerSideAddressingHandler
implements Handler {
    private static final long serialVersionUID = 7912643926095186786L;
    private GenericAxisHandler axisHelperHandler = new GenericAxisHandler((javax.xml.rpc.handler.Handler)this);

    public void init() {
        this.axisHelperHandler.init();
    }

    public void cleanup() {
        this.axisHelperHandler.cleanup();
    }

    public boolean canHandleBlock(QName qname) {
        return this.axisHelperHandler.canHandleBlock(qname);
    }

    public void setOption(String name, Object value) {
        this.axisHelperHandler.setOption(name, value);
    }

    public boolean setOptionDefault(String name, Object value) {
        return this.axisHelperHandler.setOptionDefault(name, value);
    }

    public Object getOption(String name) {
        return this.axisHelperHandler.getOption(name);
    }

    public Hashtable<?, ?> getOptions() {
        return this.axisHelperHandler.getOptions();
    }

    public void setOptions(Hashtable opts) {
        this.axisHelperHandler.setOptions(opts);
    }

    public void setName(String name) {
        this.axisHelperHandler.setName(name);
    }

    public String getName() {
        return this.axisHelperHandler.getName();
    }

    public Element getDeploymentData(Document doc) {
        return this.axisHelperHandler.getDeploymentData(doc);
    }

    public List<?> getUnderstoodHeaders() {
        return this.axisHelperHandler.getUnderstoodHeaders();
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        this.axisHelperHandler.generateWSDL(msgContext);
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        this.axisHelperHandler.invoke(msgContext);
    }

    public void onFault(MessageContext msgContext) {
        this.axisHelperHandler.onFault(msgContext);
    }

    @Override
    protected String generateUUId() {
        return this.axisHelperHandler.generateUUId();
    }

    @Override
    protected void forwardMessage(SOAPMessageContext soapMsgContext, EndpointReference endpointRef) {
        try {
            Service service = this.getService((javax.xml.rpc.handler.MessageContext)soapMsgContext);
            javax.xml.rpc.Call call = service.createCall();
            call.setTargetEndpointAddress(endpointRef.getAddress().toString());
            ((Call)call).setRequestMessage((Message)soapMsgContext.getMessage());
            AddressingHeaders addrHeaders = this.buildAddressingHeadersForMessageForward(soapMsgContext, endpointRef);
            call.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)addrHeaders);
            this.configureCall(call, soapMsgContext);
            call.invoke(new Object[0]);
            SOAPBody responseBody = soapMsgContext.getMessage().getSOAPPart().getEnvelope().getBody();
            AxisServerSideAddressingHandler.removeAllChildElements((SOAPElement)responseBody);
        }
        catch (IOException e) {
            throw new JAXRPCException("Failed to forward SOAP message", (Throwable)e);
        }
        catch (ServiceException e) {
            throw new JAXRPCException("Failed to forward SOAP message", (Throwable)e);
        }
        catch (SOAPException e) {
            throw new JAXRPCException("Failed to forward SOAP message", (Throwable)e);
        }
    }

    @Override
    protected void setTargetService(SOAPMessageContext soapMsgContext, AddressingHeaders headers) throws Exception {
        MessageContext axisMsgContext = (MessageContext)soapMsgContext;
        if (axisMsgContext.getService() == null && axisMsgContext.getTargetService() == null) {
            axisMsgContext.setTargetService(this.getTargetServiceName(headers));
            if (axisMsgContext.getTargetService() != null) {
                ((Message)axisMsgContext.getMessage()).getSOAPPartAsString();
            }
        }
    }

    private AddressingHeaders buildAddressingHeadersForMessageForward(SOAPMessageContext soapMsgContext, EndpointReference endpointRef) {
        AddressingHeaders headers = null;
        if (soapMsgContext != null) {
            headers = (AddressingHeaders)soapMsgContext.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        }
        if (headers == null) {
            headers = new AddressingHeaders(endpointRef);
        }
        return headers;
    }
}

