/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.tools.wsdl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.message.addressing.tools.wsdl.JavaClassWithImportsWriter;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaAddressingServiceIfaceImplWriter
extends JavaClassWithImportsWriter {
    protected JavaAddressingServiceIfaceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, symbolTable, sEntry.getName() + "Addressing", "service");
    }

    protected String getExtendsText() {
        return "extends " + this.resolve(this.sEntry.getName());
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getImplementsText() {
        return null;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        Map portMap = service.getPorts();
        for (Object item : portMap.values()) {
            Port p = (Port)item;
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBinding01", (String[])new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBindingEntry01", (String[])new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoPortType01", (String[])new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId((String)portName)) {
                portName = Utils.xmlNameToJavaClass((String)portName);
            }
            String bindingType = (String)bEntry.getDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME);
            pw.println("  /**");
            pw.println("   * Gets a Port instance from an end-point reference.");
            pw.println("   *");
            pw.println("   * @param reference EPR instance");
            pw.println("   * @return Port instance");
            pw.println("   * @throws ServiceException If an error occurs");
            pw.println("   */");
            pw.println("  " + this.resolve(bindingType) + " get" + portName + "(EndpointReferenceType reference)");
            pw.println("    throws ServiceException;");
            pw.println();
        }
        pw.println();
    }

    protected void writeClassComment(PrintWriter pw) throws IOException {
        pw.println("/**");
        pw.println(" * Service interface with addressing support.");
        pw.println(" */");
    }
}

