/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.tools.wsdl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.message.addressing.tools.wsdl.JavaClassWithImportsWriter;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaAddressingServiceImplWriter
extends JavaClassWithImportsWriter {
    protected JavaAddressingServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, symbolTable, sEntry.getName() + "AddressingLocator", "service");
    }

    protected void initImports() {
        super.initImports();
        this.addImport("org.apache.axis.message.addressing.AddressingHeaders");
        this.addImport("org.apache.axis.message.addressing.AttributedURI");
        this.addImport("org.apache.axis.message.addressing.Constants");
        this.addImport("org.apache.axis.EngineConfiguration");
        this.addImport("javax.xml.namespace.QName");
        this.addImport("java.net.URL");
        this.addImport("java.net.MalformedURLException");
    }

    protected String getExtendsText() {
        return "extends " + this.resolve(this.sEntry.getName() + "Locator");
    }

    protected String getImplementsText() {
        return "implements " + this.resolve(this.sEntry.getName() + "Addressing");
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeConstructors(pw);
        Map portMap = service.getPorts();
        for (Object item : portMap.values()) {
            Port p = (Port)item;
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBinding01", (String[])new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBindingEntry01", (String[])new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoPortType01", (String[])new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId((String)portName)) {
                portName = Utils.xmlNameToJavaClass((String)portName);
            }
            String bindingType = (String)bEntry.getDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME);
            pw.println("  /**");
            pw.println("   * {@inheritDoc}");
            pw.println("   */");
            pw.println("  public " + this.resolve(bindingType) + " get" + portName + "(EndpointReferenceType reference)");
            pw.println("    throws ServiceException {");
            pw.println("    AttributedURI address = reference.getAddress();");
            pw.println("    if (address == null) {");
            pw.println("      throw new ServiceException(\"No address in EndpointReference\");");
            pw.println("    }");
            pw.println("    URL endpoint;");
            pw.println("    try {");
            pw.println("      endpoint = new URL(address.toString());");
            pw.println("    } catch (MalformedURLException e) {");
            pw.println("      throw new ServiceException(e);");
            pw.println("    }");
            pw.println("    " + this.resolve(bindingType) + " stub = " + "get" + portName + "(endpoint);");
            pw.println("    if (stub != null) {");
            pw.println("      AddressingHeaders headers = new AddressingHeaders();");
            pw.println("      headers.setTo(address);");
            pw.println("      headers.setReferenceProperties(reference.getProperties());");
            pw.println("      ((javax.xml.rpc.Stub)stub)._setProperty(");
            pw.println("        Constants.ENV_ADDRESSING_SHARED_HEADERS, headers);");
            pw.println("    }");
            pw.println("    return stub;");
            pw.println("  }");
            pw.println();
        }
        pw.println();
    }

    protected void writeConstructors(PrintWriter pw) throws IOException {
        String simpleClassName = this.resolve(this.sEntry.getName()) + "AddressingLocator";
        pw.println("  /**");
        pw.println("   * Creates an instance.");
        pw.println("   */");
        pw.println("  public " + simpleClassName + "() {");
        pw.println("  }");
        pw.println();
        pw.println("  /**");
        pw.println("   * Creates an instance.");
        pw.println("   *");
        pw.println("   * @param config Engine configuration to use");
        pw.println("   */");
        pw.println("  public " + simpleClassName + "(EngineConfiguration config) {");
        pw.println("    super(config);");
        pw.println("  }");
        pw.println();
        pw.println("  /**");
        pw.println("   * Creates an instance.");
        pw.println("   *");
        pw.println("   * @param wsdlLoc WSDL path");
        pw.println("   * @param sName   Service name");
        pw.println("   * @throws ServiceException If an error occurs");
        pw.println("   */");
        pw.println("  public " + simpleClassName + "(String wsdlLoc, QName sName)");
        pw.println("    throws ServiceException {");
        pw.println("    super(wsdlLoc, sName);");
        pw.println("  }");
        pw.println();
    }

    protected void writeClassComment(PrintWriter pw) throws IOException {
        pw.println("/**");
        pw.println(" * Service interface with addressing support implementation.");
        pw.println(" */");
    }
}

