/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.tools.wsdl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;

public abstract class JavaClassWithImportsWriter
extends JavaClassWriter {
    protected final ServiceEntry sEntry;
    protected final SymbolTable symbolTable;
    private final Map<String, String> imports = new HashMap<String, String>();
    private final Set<String> implicits = new HashSet<String>();

    protected JavaClassWithImportsWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable, String entryName, String type) {
        super(emitter, entryName, "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.initImports();
        super.generate();
    }

    protected void initImports() {
        this.implicits.add(this.getPackage());
        this.implicits.add("java.lang");
        this.addImport("org.apache.axis.message.addressing.EndpointReferenceType");
        this.addImport("javax.xml.rpc.ServiceException");
        Map ports = this.sEntry.getService().getPorts();
        for (Object item : ports.values()) {
            Port p = (Port)item;
            String className = this.getBindingType(p);
            if (className == null) continue;
            this.addImport(className);
        }
    }

    protected final void addImport(String className) {
        int pos = className.lastIndexOf(46);
        String packageName = className.substring(0, pos);
        String simpleName = className.substring(pos + 1);
        if (!this.implicits.contains(packageName)) {
            this.imports.put(className, simpleName);
        }
    }

    protected final String resolve(String className) {
        String pkg = this.getPackage();
        int pos = className.lastIndexOf(46);
        String packageName = className.substring(0, pos);
        String simpleName = className.substring(pos + 1);
        if ("java.lang".equals(packageName)) {
            return simpleName;
        }
        if (packageName.equals(pkg)) {
            return simpleName;
        }
        String resolved = this.imports.get(className);
        return resolved == null ? className : resolved;
    }

    protected final String getBindingType(Port port) {
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        if (bEntry == null || bEntry.getBindingType() != 0) {
            return null;
        }
        return (String)bEntry.getDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME);
    }

    protected final void writeImports(PrintWriter pw) {
        for (String className : this.imports.keySet()) {
            pw.print("import ");
            pw.print(className);
            pw.println(';');
        }
        pw.println();
    }

    protected final void writeHeaderComments(PrintWriter pw) throws IOException {
        int pos = this.getFileName().lastIndexOf(File.separatorChar);
        pw.println("/*");
        pw.println(" * " + this.getFileName().substring(pos + 1));
        pw.println(" *");
        pw.println(" * This file was auto-generated from WSDL");
        pw.println(" * by the Addressing WSDL2Java emitter");
        pw.println(" */");
    }

    protected final void writeFileHeader(PrintWriter pw) throws IOException {
        String implementsText;
        this.writeHeaderComments(pw);
        this.writePackage(pw);
        this.writeImports(pw);
        this.writeClassComment(pw);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClassModifiers());
        sb.append(this.getClassText());
        sb.append(this.getClassName());
        String extendsText = this.getExtendsText();
        if (extendsText != null) {
            pw.println(sb);
            sb.setLength(0);
            sb.append("  ");
            sb.append(this.getExtendsText());
        }
        if ((implementsText = this.getImplementsText()) != null) {
            pw.println(sb);
            sb.setLength(0);
            sb.append("  ");
            sb.append(this.getImplementsText());
        }
        sb.append(" {");
        pw.println(sb);
    }

    protected abstract void writeClassComment(PrintWriter var1) throws IOException;
}

