/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.AttributeExtensible;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.util.WsaVersion;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AddressingUtils
implements Constants {
    private static final Set<String> ADDRESSING_NS_URI_SET = new HashSet<String>();
    private static final Set<String> W3C_ADDRESSING_NS_URI_SET = new HashSet<String>();
    private static final Map<String, AddressingVersion> VERSIONS = new HashMap<String, AddressingVersion>();
    private static final String DEFAULT_ADDRESSING_NS;

    private static void addVersion(String ns, String anonURI, String response, boolean w3c, boolean params, boolean props, boolean mdata) {
        if (w3c) {
            W3C_ADDRESSING_NS_URI_SET.add(ns);
        } else {
            ADDRESSING_NS_URI_SET.add(ns);
        }
        if (anonURI == null) {
            anonURI = ns + "/role/anonymous";
        }
        VERSIONS.put(ns, new WsaVersion(ns, anonURI, new QName(ns, response), w3c, params, props, mdata));
    }

    protected AddressingUtils() {
    }

    public static void removeHeader(SOAPHeader soapHeader, String actorURI, String headerName) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            if (!AddressingUtils.isAddressingNamespaceURI(hName.getURI()) || !hName.getLocalName().equals(headerName)) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static AddressingVersion getAddressingVersion(javax.xml.rpc.handler.MessageContext ctx) {
        return VERSIONS.get(AddressingUtils.getAddressingNamespaceURI(ctx));
    }

    public static AddressingVersion getAddressingVersion(String ns) {
        return VERSIONS.get(ns);
    }

    public static AddressingVersion getAddressingVersion() {
        String ns = AddressingUtils.getAddressingNamespaceURI((javax.xml.rpc.handler.MessageContext)AxisEngine.getCurrentMessageContext());
        return VERSIONS.get(ns);
    }

    public static boolean isAddressingNamespaceURI(String uri) {
        return ADDRESSING_NS_URI_SET.contains(uri);
    }

    public static boolean isW3CAddressingNamespaceURI(String uri) {
        return W3C_ADDRESSING_NS_URI_SET.contains(uri);
    }

    public static void removeHeaders(SOAPHeader soapHeader, String actorURI) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            AddressingVersion version = AddressingUtils.getAddressingVersion(hName.getURI());
            if (version == null) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static AddressingHeaders getResponseHeaders(javax.xml.rpc.handler.MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.RESPONSE.HEADERS");
    }

    public static AddressingHeaders getRequestHeaders(javax.xml.rpc.handler.MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.REQUEST.HEADERS");
    }

    public static String getInputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Input input = operation.getInput();
        if (input == null) {
            return null;
        }
        return AddressingUtils.getAction((AttributeExtensible)input, input.getName(), portTypeQName, operation, "Request");
    }

    public static String getOutputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Output output = operation.getOutput();
        if (output == null) {
            return null;
        }
        return AddressingUtils.getAction((AttributeExtensible)output, output.getName(), portTypeQName, operation, "Response");
    }

    public static String getNamespacePrefix(SOAPElement element, String namespace) throws SOAPException {
        String prefix;
        if (element == null || namespace == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Iterator iter = element.getVisibleNamespacePrefixes();
        while (iter.hasNext()) {
            prefix = (String)iter.next();
            String ns = element.getNamespaceURI(prefix);
            if (!namespace.equals(ns)) continue;
            return prefix;
        }
        int i = 0;
        prefix = "ns" + i;
        while (element.getNamespaceURI(prefix) != null) {
            prefix = "ns" + i++;
        }
        element.addNamespaceDeclaration(prefix, namespace);
        return prefix;
    }

    public static String getAddressingNamespaceURI() {
        MessageContext ctx = AxisEngine.getCurrentMessageContext();
        return AddressingUtils.getAddressingNamespaceURI((javax.xml.rpc.handler.MessageContext)ctx);
    }

    public static String getAddressingNamespaceURI(javax.xml.rpc.handler.MessageContext ctx) {
        String nsURI = null;
        if (ctx != null) {
            nsURI = (String)ctx.getProperty("addressing.namespace.URI");
        }
        if (nsURI == null) {
            nsURI = DEFAULT_ADDRESSING_NS;
        }
        return nsURI;
    }

    public static String getFaultActionURI() {
        return AddressingUtils.getAddressingVersion().getFaultActionURI();
    }

    public static String getAnonymousRoleURI() {
        AddressingVersion version = AddressingUtils.getAddressingVersion();
        return version.getAnonymousRoleURI();
    }

    public static String getAnonymousRoleURI(javax.xml.rpc.handler.MessageContext ctx) {
        return AddressingUtils.getAddressingVersion(ctx).getAnonymousRoleURI();
    }

    public static QName getResponseRelationshipType() {
        return AddressingUtils.getAddressingVersion().getResponseRelationshipType();
    }

    public static QName getResponseRelationshipType(javax.xml.rpc.handler.MessageContext ctx) {
        return AddressingUtils.getAddressingVersion(ctx).getResponseRelationshipType();
    }

    public static EndpointReference parseReference(String epr) throws Exception {
        Document doc = XMLUtils.newDocument((InputSource)new InputSource(new StringReader(epr)));
        Element elem = doc.getDocumentElement();
        return new EndpointReference(elem);
    }

    public static String toString(EndpointReference epr, boolean prettyPrint) throws Exception {
        if (epr == null) {
            return null;
        }
        Document doc = XMLUtils.newDocument();
        Element elem = epr.toDOM(doc, "wsa:EndpointReference");
        StringWriter writer = new StringWriter();
        DOM2Writer.serializeAsXML((Node)elem, (Writer)writer, (boolean)true, (boolean)prettyPrint);
        return writer.toString();
    }

    private static AddressingHeaders getHeaders(javax.xml.rpc.handler.MessageContext ctx, String type) {
        AddressingHeaders headers = (AddressingHeaders)ctx.getProperty(type);
        if (headers == null) {
            headers = new AddressingHeaders();
            headers.isW3CVersion = AddressingUtils.getAddressingVersion(ctx).isW3C();
            ctx.setProperty(type, (Object)headers);
        }
        return headers;
    }

    private static String getAction(AttributeExtensible inputOutput, String inputOutputName, QName portTypeQName, Operation operation, String defaultName) {
        Object value = inputOutput.getExtensionAttribute(new QName(AddressingUtils.getAddressingNamespaceURI(), "Action"));
        if (value != null) {
            if (value instanceof QName) {
                return ((QName)value).getLocalPart();
            }
            return value.toString();
        }
        String name = inputOutputName;
        if (name == null) {
            name = operation.getName() + defaultName;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(portTypeQName.getNamespaceURI());
        if (!portTypeQName.getNamespaceURI().endsWith("/")) {
            buf.append("/");
        }
        buf.append(portTypeQName.getLocalPart()).append("/").append(name);
        return buf.toString();
    }

    static {
        AddressingUtils.addVersion("http://schemas.xmlsoap.org/ws/2003/03/addressing", null, "Response", false, false, true, false);
        AddressingUtils.addVersion("http://schemas.xmlsoap.org/ws/2004/03/addressing", null, "Reply", false, false, true, false);
        AddressingUtils.addVersion("http://schemas.xmlsoap.org/ws/2004/08/addressing", null, "Reply", false, true, true, false);
        AddressingUtils.addVersion("http://www.w3.org/2005/08/addressing", "http://www.w3.org/2005/08/addressing/anonymous", "Reply", true, true, true, true);
        DEFAULT_ADDRESSING_NS = System.getProperty("addressing.namespace.URI", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
    }
}

