/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.addressing.uuid.UUIdGeneratorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddressingHandler
extends GenericHandler {
    public static final String CONFIG_PROP_ACTOR = "actor";
    public static final String CONFIG_PROP_REFERENCE_PROPERTY_NAMES = "referencePropertyNames";
    public static final String CONFIG_PROP_REMOVE_HEADERS = "removeHeaders";
    static final String UUID_URI_SCHEME = "uuid";
    private static final QName[] UNDERSTOOD_HEADERS = new QName[]{new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "To"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "To"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "To")};
    protected static final boolean CONTINUE_HANDLER_CHAIN_PROCESSING = true;
    private static final Log LOG = LogFactory.getLog(AbstractAddressingHandler.class);
    private Map<String, String> handlerConfigProps;
    private List<QName> refPropQNames;

    public QName[] getHeaders() {
        return (QName[])UNDERSTOOD_HEADERS.clone();
    }

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        LOG.info((Object)("Initializing JAX-RPC handler " + ((Object)((Object)this)).getClass().getName() + "..."));
        this.handlerConfigProps = handlerInfo.getHandlerConfig();
        this.initReferencePropertyQNames();
    }

    protected Map<String, String> getHandlerConfigProperties() {
        return this.handlerConfigProps;
    }

    protected String getHandlerConfigProperty(String propName) {
        return this.getHandlerConfigProperties().get(propName);
    }

    protected boolean isHandlerConfigPropertyTrue(String propName) {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.getHandlerConfigProperty(propName));
    }

    protected String generateUUId() {
        try {
            return UUIdGeneratorFactory.getGenerator().generateUUId();
        }
        catch (RuntimeException re) {
            throw new JAXRPCException("Failed to generate UUId using default UUId generator", (Throwable)re);
        }
    }

    protected boolean isMustUnderstandEnabled(MessageContext msgContext) {
        return this.isPropertyTrue(msgContext, "addressing.setMustUnderstand");
    }

    protected boolean isPropertyTrue(MessageContext msgContext, String propName) {
        return Boolean.TRUE.toString().equals(msgContext.getProperty(propName));
    }

    protected MessageID createMessageID() throws URI.MalformedURIException {
        return new MessageID(new URI("uuid:" + this.generateUUId()));
    }

    protected List<QName> getReferencePropertyQNames() {
        return this.refPropQNames;
    }

    protected String getActor() {
        return this.getHandlerConfigProperty(CONFIG_PROP_ACTOR);
    }

    protected boolean isRemoveHeadersEnabled() {
        return this.isHandlerConfigPropertyTrue(CONFIG_PROP_REMOVE_HEADERS);
    }

    protected void initReferencePropertyQNames() {
        String refPropNamesConfigPropValue = this.getHandlerConfigProperty(CONFIG_PROP_REFERENCE_PROPERTY_NAMES);
        if (refPropNamesConfigPropValue == null) {
            LOG.debug((Object)"No reference properties will be processed.");
            this.refPropQNames = new ArrayList<QName>();
        } else if (refPropNamesConfigPropValue.equals("*")) {
            LOG.debug((Object)"All reference properties will be processed.");
            this.refPropQNames = null;
        } else {
            this.refPropQNames = new ArrayList<QName>();
            StringTokenizer tokenizer = new StringTokenizer(refPropNamesConfigPropValue, ",");
            while (tokenizer.hasMoreTokens()) {
                String qnameString = tokenizer.nextToken().trim();
                try {
                    QName qname = QName.valueOf(qnameString);
                    LOG.debug((Object)("Reference properties with QName '" + qnameString + "' will be processed."));
                    this.refPropQNames.add(qname);
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn((Object)("Invalid QName '" + qnameString + "' specified in handler config."));
                }
            }
        }
    }
}

