/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerFactory;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AddressingVersion;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.addressing.handler.AbstractAddressingHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSideAddressingHandler
extends AbstractAddressingHandler {
    private static final Log LOG = LogFactory.getLog(ServerSideAddressingHandler.class);
    public static final FactoryThreadLocal TRANSFORMER_FACTORY = new FactoryThreadLocal();

    public boolean handleRequest(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            SOAPMessage msg = soapMsgContext.getMessage();
            if (msg == null) {
                return true;
            }
            AddressingHeaders headers = new AddressingHeaders(msg.getSOAPPart().getEnvelope(), this.getActor(), true, this.isRemoveHeadersEnabled(), false, this.getReferencePropertyQNames());
            if (headers.getTo() == null) {
                return true;
            }
            if (headers.getAction() == null) {
                LOG.debug((Object)("WSA request to endpoint " + headers.getTo() + " is missing the required wsa:Action header."));
            }
            msgContext.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
            this.setTargetService(soapMsgContext, headers);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("Unexpected error in handleRequest()", (Throwable)e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext ctx) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)ctx;
        try {
            SOAPMessage msg = soapMsgContext.getMessage();
            if (msg == null) {
                return true;
            }
            AddressingVersion version = AddressingUtils.getAddressingVersion(ctx);
            AddressingHeaders reqHeaders = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            if (reqHeaders == null) {
                return true;
            }
            AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders(ctx);
            resHeaders.setSetMustUnderstand(this.isMustUnderstandEnabled(ctx));
            this.processFromHeader(reqHeaders, resHeaders);
            this.processActionHeader(reqHeaders, resHeaders);
            this.processToHeader(version, reqHeaders, resHeaders);
            this.processRelatesToHeader(version, reqHeaders, resHeaders);
            this.processMessageIdHeader(resHeaders);
            resHeaders.toEnvelope(msg.getSOAPPart().getEnvelope(), this.getActor());
            this.processReplyToHeader(reqHeaders, soapMsgContext);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("Unexpected error in handleResponse()", (Throwable)e);
        }
        return true;
    }

    public boolean handleFault(MessageContext ctx) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)ctx;
        AddressingVersion version = AddressingUtils.getAddressingVersion(ctx);
        try {
            AddressingHeaders reqHeaders = (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            if (reqHeaders == null) {
                return true;
            }
            AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders(ctx);
            this.processFromHeader(reqHeaders, resHeaders);
            resHeaders.setAction(new Action(version.getFaultActionURI()));
            this.addRelatesToHeader(version, reqHeaders, resHeaders);
            this.addMessageIdHeader(resHeaders);
            this.addAddressingHeadersToSOAPEnvelope(soapMsgContext, resHeaders);
            this.processFaultToHeader(reqHeaders, soapMsgContext);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("Unexpected error in handleFault()", (Throwable)e);
        }
        return true;
    }

    protected void forwardMessage(SOAPMessageContext ctx, EndpointReference ref) {
        try {
            SOAPConnection soapConn = SOAPConnectionFactory.newInstance().createConnection();
            soapConn.call(ctx.getMessage(), (Object)new URL(ref.getAddress().toString()));
            soapConn.close();
            SOAPBody responseBody = ctx.getMessage().getSOAPPart().getEnvelope().getBody();
            ServerSideAddressingHandler.removeAllChildElements((SOAPElement)responseBody);
        }
        catch (SOAPException e) {
            throw new JAXRPCException("Failed to forward SOAP message.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new JAXRPCException("Failed to forward SOAP message.", (Throwable)e);
        }
    }

    protected Service getService(MessageContext ctx) throws ServiceException {
        return ServiceFactory.newInstance().createService(new QName(""));
    }

    protected void configureCall(Call call, SOAPMessageContext oldContext) {
    }

    protected String getTargetServiceName(AddressingHeaders headers) throws Exception {
        To toURI = headers.getTo();
        if (toURI == null) {
            return null;
        }
        String to = toURI.getPath();
        if (to == null) {
            return null;
        }
        return to.substring(to.lastIndexOf(47) + 1);
    }

    protected void setTargetService(SOAPMessageContext ctx, AddressingHeaders headers) throws Exception {
    }

    private void processFromHeader(AddressingHeaders reqHeaders, AddressingHeaders resHeaders) {
        To toURI;
        EndpointReference fromEPR = resHeaders.getFrom();
        if (fromEPR == null && (toURI = reqHeaders.getTo()) != null) {
            fromEPR = new EndpointReference(toURI);
            fromEPR.setProperties(reqHeaders.getReferenceProperties());
            resHeaders.setFrom(fromEPR);
        }
    }

    private void processActionHeader(AddressingHeaders reqHeaders, AddressingHeaders resHeaders) throws URI.MalformedURIException {
        Action action = resHeaders.getAction();
        if (action == null && (action = reqHeaders.getAction()) != null) {
            resHeaders.setAction(new Action(new URI(action.toString() + "Response")));
        }
    }

    private void processToHeader(AddressingVersion version, AddressingHeaders reqHeaders, AddressingHeaders resHeaders) throws URI.MalformedURIException {
        if (resHeaders.getFrom() == null && reqHeaders.getFrom() != null) {
            resHeaders.setTo(reqHeaders.getFrom().getAddress());
        } else {
            resHeaders.setTo(new To(version.getAnonymousRoleURI()));
        }
    }

    private void processRelatesToHeader(AddressingVersion version, AddressingHeaders reqHeaders, AddressingHeaders resHeaders) throws URI.MalformedURIException {
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), version.getResponseRelationshipType());
        }
    }

    private void processMessageIdHeader(AddressingHeaders resHeaders) throws URI.MalformedURIException {
        resHeaders.setMessageID(this.createMessageID());
    }

    private void processReplyToHeader(AddressingHeaders reqHeaders, SOAPMessageContext ctx) throws Exception {
        String uri;
        AttributedURI address;
        EndpointReference replyTo = reqHeaders.getReplyTo();
        if (replyTo != null && (address = replyTo.getAddress()) != null && (uri = address.toString()) != null && !uri.equals(AddressingUtils.getAnonymousRoleURI((MessageContext)ctx))) {
            this.forwardMessage(ctx, replyTo);
        }
    }

    private void addAddressingHeadersToSOAPEnvelope(SOAPMessageContext soapMsgContext, AddressingHeaders resHeaders) throws Exception {
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            throw new JAXRPCException("Unable to get response message from message context.");
        }
        resHeaders.toEnvelope(msg.getSOAPPart().getEnvelope());
    }

    private void processFaultToHeader(AddressingHeaders reqHeaders, SOAPMessageContext soapMsgContext) throws Exception {
        AttributedURI address;
        EndpointReference faultTo = reqHeaders.getFaultTo();
        if (faultTo != null && (address = faultTo.getAddress()) != null && address.toString() != null) {
            this.forwardMessage(soapMsgContext, faultTo);
        }
    }

    private void addRelatesToHeader(AddressingVersion version, AddressingHeaders reqHeaders, AddressingHeaders resHeaders) throws URI.MalformedURIException {
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), version.getResponseRelationshipType());
        }
    }

    private void addMessageIdHeader(AddressingHeaders resHeaders) throws URI.MalformedURIException {
        MessageID msgID = new MessageID(new URI("uuid:" + this.generateUUId()));
        resHeaders.setMessageID(msgID);
    }

    protected static void removeAllChildElements(SOAPElement soapElem) {
        Iterator iter = soapElem.getChildElements();
        List children = ServerSideAddressingHandler.toList(iter);
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            if (child.getParentElement() == null) continue;
            child.detachNode();
            child.recycleNode();
        }
    }

    private static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (iter != null) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FactoryThreadLocal
    extends ThreadLocal<TransformerFactory> {
        private FactoryThreadLocal() {
        }

        @Override
        protected synchronized TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    }
}

