/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.uuid;

import java.lang.reflect.Method;
import javax.xml.rpc.JAXRPCException;
import org.apache.ws.addressing.uuid.UUIdGenerator;

public class JugUUIdGenerator
implements UUIdGenerator {
    private static final String JUG_UUIDGENERATOR_CLASSNAME = "org.doomdark.uuid.UUIDGenerator";
    private final Method generateUUIdMethod;
    private final Class<?> jugUuidGenClass;
    private final Object gen;

    public JugUUIdGenerator() {
        try {
            this.jugUuidGenClass = Class.forName(JUG_UUIDGENERATOR_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Java UUID Generator (JUG) not found.", e);
        }
        try {
            this.generateUUIdMethod = this.jugUuidGenClass.getMethod("generateTimeBasedUUID", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing Java UUID Generator (JUG)", e);
        }
        try {
            this.gen = this.jugUuidGenClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error instantiating Java UUID Generator (JUG)", t);
        }
    }

    public synchronized String generateUUId() {
        try {
            return this.generateUUIdMethod.invoke(this.gen, new Object[0]).toString();
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }
}

