/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.Member;
import java.util.LinkedHashSet;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class RecursiveFunctionObject
extends FunctionObject {
    public RecursiveFunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        super(name, methodOrConstructor, scope);
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        if ("toString".equals(name) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSTRING_ENUMERATED)) {
            return true;
        }
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable) || !((Scriptable)scripatble).has(name, start)) continue;
            return true;
        }
        return false;
    }

    public Object[] getIds() {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSTRING_ENUMERATED)) {
            objects.add("toString");
        }
        for (Object o : super.getIds()) {
            objects.add(o);
        }
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable)) continue;
            for (Object id : ((Scriptable)scripatble).getIds()) {
                objects.add(id);
            }
        }
        return objects.toArray(new Object[objects.size()]);
    }

    public BrowserVersion getBrowserVersion() {
        Scriptable parent = this.getParentScope();
        while (!(parent instanceof Window)) {
            parent = parent.getParentScope();
        }
        return ((Window)parent).getBrowserVersion();
    }

    public Object getDefaultValue(Class<?> typeHint) {
        String functionName = this.getFunctionName();
        if ("HTMLImageElement".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IMAGE_OBJECT)) {
            return "[object " + functionName + ']';
        }
        if ("HTMLOptionElement".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_OBJECT)) {
            return "[object " + functionName + ']';
        }
        if ("XSLTProcessor".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XSLTPROCESSOR_OBJECT)) {
            return "[object " + functionName + ']';
        }
        if ("XMLHttpRequest".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XMLHTTPREQUEST_OBJECT)) {
            return "[object " + functionName + ']';
        }
        return super.getDefaultValue(typeHint);
    }

    public String getTypeOf() {
        String functionName = this.getFunctionName();
        if ("HTMLImageElement".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IMAGE_OBJECT)) {
            return "object";
        }
        if ("HTMLOptionElement".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_OBJECT)) {
            return "object";
        }
        if ("XMLHttpRequest".equals(functionName) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XMLHTTPREQUEST_OBJECT)) {
            return "object";
        }
        return super.getTypeOf();
    }

    public String getFunctionName() {
        String functionName;
        switch (functionName = super.getFunctionName()) {
            case "Image": {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IMAGE_HTML_IMAGE_ELEMENT)) break;
                return "HTMLImageElement";
            }
            case "Option": {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OPTION_HTML_OPTION_ELEMENT)) break;
                return "HTMLOptionElement";
            }
            case "Collator": 
            case "DateTimeFormat": 
            case "NumberFormat": 
            case "V8BreakIterator": {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INTL_V8_BREAK_ITERATOR)) break;
                return "";
            }
            case "webkitRTCPeerConnection": {
                return "RTCPeerConnection";
            }
            case "webkitSpeechRecognition": {
                return "SpeechRecognition";
            }
            case "WebKitAnimationEvent": {
                return "AnimationEvent";
            }
            case "WebKitMutationObserver": {
                return "MutationObserver";
            }
            case "WebKitTransitionEvent": {
                return "TransitionEvent";
            }
            case "webkitAudioContext": {
                return "AudioContext";
            }
            case "webkitIDBCursor": {
                return "IDBCursor";
            }
            case "webkitIDBDatabase": {
                return "IDBDatabase";
            }
            case "webkitIDBFactory": {
                return "IDBFactory";
            }
            case "webkitIDBIndex": {
                return "IDBIndex";
            }
            case "webkitIDBKeyRange": {
                return "IDBKeyRange";
            }
            case "webkitIDBObjectStore": {
                return "IDBObjectStore";
            }
            case "webkitIDBRequest": {
                return "IDBRequest";
            }
            case "webkitIDBTransaction": {
                return "IDBTransaction";
            }
            case "webkitMediaStream": {
                return "MediaStream";
            }
            case "webkitOfflineAudioContext": {
                return "OfflineAudioContext";
            }
            case "webkitSpeechGrammar": {
                return "SpeechGrammar";
            }
            case "webkitSpeechGrammarList": {
                return "SpeechGrammarList";
            }
            case "webkitSpeechRecognitionError": {
                return "SpeechRecognitionError";
            }
            case "webkitSpeechRecognitionEvent": {
                return "SpeechRecognitionEvent";
            }
            case "webkitURL": {
                return "URL";
            }
        }
        return functionName;
    }

    public Object get(String name, Scriptable start) {
        if ("prototype".equals(name)) {
            switch (super.getFunctionName()) {
                case "CSS": 
                case "Proxy": {
                    return NOT_FOUND;
                }
            }
        }
        return super.get(name, start);
    }
}

