/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import java.net.URI;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)})
public class WebSocket
extends EventTarget
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private int readyState_ = 3;
    private HtmlPage containingPage_;
    private WebSocketClient client_;
    private Session incomingSession_;
    private Session outgoingSession_;

    public WebSocket() {
    }

    private WebSocket(String url, Object protocols, Window window) {
        try {
            this.containingPage_ = (HtmlPage)window.getWebWindow().getEnclosedPage();
            this.client_ = this.containingPage_.getWebClient().getOptions().isUseInsecureSSL() ? new WebSocketClient(new SslContextFactory(true)) : new WebSocketClient();
            this.client_.start();
            this.incomingSession_ = (Session)this.client_.connect((Object)new WebSocketImpl(), new URI(url)).get();
            this.readyState_ = 1;
            this.containingPage_.addAutoCloseable(this);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"WebSocket Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter must be a String.");
        }
        return new WebSocket((String)args[0], null, WebSocket.getWindow((Scriptable)ctorObj));
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
        this.fireOnOpen();
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @Override
    public void close() throws Exception {
        this.close(null, null);
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        if (this.readyState_ != 3) {
            if (this.incomingSession_ != null) {
                this.incomingSession_.close();
            }
            if (this.outgoingSession_ != null) {
                this.outgoingSession_.close();
            }
            try {
                this.client_.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.readyState_ = 3;
        }
    }

    @JsxFunction
    public void send(Object content) {
        try {
            if (!(content instanceof String)) {
                throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
            }
            this.outgoingSession_.getRemote().sendString(content.toString());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private void fireOnOpen() {
        if (this.openHandler_ == null) {
            return;
        }
        Scriptable scope = this.openHandler_.getParentScope();
        JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
        jsEngine.callFunction((InteractivePage)this.containingPage_, this.openHandler_, scope, (Scriptable)this, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    private class WebSocketImpl
    extends WebSocketAdapter {
        private WebSocketImpl() {
        }

        public void onWebSocketConnect(Session session) {
            WebSocket.this.outgoingSession_ = session;
        }

        public void onWebSocketClose(int closeCode, String message) {
            if (WebSocket.this.closeHandler_ == null) {
                return;
            }
            Scriptable scope = WebSocket.this.closeHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction((InteractivePage)WebSocket.this.containingPage_, WebSocket.this.closeHandler_, scope, (Scriptable)WebSocket.this, new Object[]{closeCode, message});
        }

        public void onWebSocketText(String data) {
            if (WebSocket.this.messageHandler_ == null) {
                return;
            }
            Scriptable scope = WebSocket.this.messageHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            MessageEvent event = new MessageEvent(data);
            event.setParentScope(WebSocket.this.getParentScope());
            event.setPrototype(WebSocket.this.getPrototype(event.getClass()));
            jsEngine.callFunction((InteractivePage)WebSocket.this.containingPage_, WebSocket.this.messageHandler_, scope, (Scriptable)WebSocket.this, new Object[]{event});
        }

        public void onWebSocketBinary(byte[] data, int offset, int length) {
            if (WebSocket.this.messageHandler_ == null) {
                return;
            }
            Scriptable scope = WebSocket.this.messageHandler_.getParentScope();
            JavaScriptEngine jsEngine = WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            jsEngine.callFunction((InteractivePage)WebSocket.this.containingPage_, WebSocket.this.messageHandler_, scope, (Scriptable)WebSocket.this, new Object[]{data, offset, length});
        }
    }
}

