/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class CSSStyleRule
extends CSSRule {
    private static final Pattern SELECTOR_PARTS_PATTERN = Pattern.compile("[\\.#]?[a-zA-Z]+");
    private static final Pattern SELECTOR_REPLACE_PATTERN = Pattern.compile("\\*([\\.#])");

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.EDGE)})
    public CSSStyleRule() {
    }

    protected CSSStyleRule(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSStyleRule rule) {
        super(stylesheet, rule);
    }

    @JsxGetter
    public String getSelectorText() {
        String selectorText = ((org.w3c.dom.css.CSSStyleRule)this.getRule()).getSelectorText();
        Matcher m = SELECTOR_PARTS_PATTERN.matcher(selectorText);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String fixedName = m.group();
            if (!fixedName.isEmpty() && '.' == fixedName.charAt(0) || '#' == fixedName.charAt(0)) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTOR_ID_LOWERCASE) && ((HtmlPage)this.getWindow().getWebWindow().getEnclosedPage()).isQuirksMode()) {
                    fixedName = fixedName.toLowerCase(Locale.ROOT);
                }
            } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTOR_TEXT_UPPERCASE)) {
                fixedName = fixedName.toUpperCase(Locale.ROOT);
            } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTOR_TEXT_LOWERCASE)) {
                fixedName = fixedName.toLowerCase(Locale.ROOT);
            }
            fixedName = StringUtils.sanitizeForAppendReplacement(fixedName);
            m.appendReplacement(sb, fixedName);
        }
        m.appendTail(sb);
        selectorText = SELECTOR_REPLACE_PATTERN.matcher(sb.toString()).replaceAll("$1");
        return selectorText;
    }

    @JsxSetter
    public void setSelectorText(String selectorText) {
        ((org.w3c.dom.css.CSSStyleRule)this.getRule()).setSelectorText(selectorText);
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return new CSSStyleDeclaration(this.getParentScope(), ((org.w3c.dom.css.CSSStyleRule)this.getRule()).getStyle());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getReadOnly() {
        return false;
    }
}

