/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.host.css.BrowserConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StyleAttributes {
    private static final Map<String, Definition> styles_ = new HashMap<String, Definition>();

    private StyleAttributes() {
    }

    public static Definition getDefinition(String propertyName, BrowserVersion browserVersion) {
        if (browserVersion == null) {
            return null;
        }
        Definition definition = styles_.get(propertyName);
        if (definition == null) {
            return null;
        }
        if (!definition.isAvailable(browserVersion)) {
            return null;
        }
        return definition;
    }

    public static List<Definition> getDefinitions(BrowserVersion browserVersion) {
        ArrayList<Definition> list = new ArrayList<Definition>();
        for (Definition definition : Definition.values()) {
            if (!definition.isAvailable(browserVersion)) continue;
            list.add(definition);
        }
        return list;
    }

    static {
        for (Definition definition : Definition.values()) {
            styles_.put(definition.getPropertyName(), definition);
        }
    }

    public static enum Definition {
        ACCELERATOR("accelerator", "accelerator", BrowserConfiguration.ie11up("undefined")),
        ALIGN_CONTENT("alignContent", "align-content", BrowserConfiguration.ie11up("stretch"), BrowserConfiguration.ff("stretch"), BrowserConfiguration.chrome("start")),
        ALIGN_CONTENT_("align-content", "align-content", BrowserConfiguration.ff38up("stretch")),
        ALIGN_ITEMS("alignItems", "align-items", BrowserConfiguration.ff("stretch"), BrowserConfiguration.ie11up("stretch"), BrowserConfiguration.chrome("start")),
        ALIGN_ITEMS_("align-items", "align-items", BrowserConfiguration.ff38up("stretch")),
        ALIGN_SELF("alignSelf", "align-self", BrowserConfiguration.ff("stretch"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("start")),
        ALIGN_SELF_("align-self", "align-self", BrowserConfiguration.ff38up("stretch")),
        ALIGNMENT_BASELINE("alignmentBaseline", "alignment-baseline", BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        ALL("all", "all", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("")),
        ANIMATION("animation", "animation", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("none 0s ease 0s 1 normal none running")),
        ANIMATION_DELAY("animationDelay", "animation-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s"), BrowserConfiguration.chrome("0s")),
        ANIMATION_DELAY_("animation-delay", "animation-delay", BrowserConfiguration.ff38up("0s")),
        ANIMATION_DIRECTION("animationDirection", "animation-direction", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie11up("normal"), BrowserConfiguration.chrome("normal")),
        ANIMATION_DIRECTION_("animation-direction", "animation-direction", BrowserConfiguration.ff38up("normal")),
        ANIMATION_DURATION("animationDuration", "animation-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s"), BrowserConfiguration.chrome("0s")),
        ANIMATION_DURATION_("animation-duration", "animation-duration", BrowserConfiguration.ff38up("0s")),
        ANIMATION_FILL_MODE("animationFillMode", "animation-fill-mode", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        ANIMATION_FILL_MODE_("animation-fill-mode", "animation-fill-mode", BrowserConfiguration.ff38up("none")),
        ANIMATION_ITERATION_COUNT("animationIterationCount", "animation-iteration-count", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        ANIMATION_ITERATION_COUNT_("animation-iteration-count", "animation-iteration-count", BrowserConfiguration.ff38up("1")),
        ANIMATION_NAME("animationName", "animation-name", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        ANIMATION_NAME_("animation-name", "animation-name", BrowserConfiguration.ff38up("none")),
        ANIMATION_PLAY_STATE("animationPlayState", "animation-play-state", BrowserConfiguration.ff("running"), BrowserConfiguration.ie11up("running"), BrowserConfiguration.chrome("running")),
        ANIMATION_PLAY_STATE_("animation-play-state", "animation-play-state", BrowserConfiguration.ff38up("running")),
        ANIMATION_TIMING_FUNCTION("animationTimingFunction", "animation-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.chrome("ease")),
        ANIMATION_TIMING_FUNCTION_("animation-timing-function", "animation-timing-function", BrowserConfiguration.ff38up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        AZIMUTH("azimuth", "azimuth", new BrowserConfiguration[0]),
        BACKFACE_VISIBILITY("backfaceVisibility", "backface-visibility", BrowserConfiguration.ff("visible"), BrowserConfiguration.ie11up("visible"), BrowserConfiguration.chrome("visible")),
        BACKFACE_VISIBILITY_("backface-visibility", "backface-visibility", BrowserConfiguration.ff38up("visible")),
        BACKGROUND("background", "background", BrowserConfiguration.chrome("rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box")),
        BACKGROUND_ATTACHMENT("backgroundAttachment", "background-attachment", BrowserConfiguration.chrome("scroll"), BrowserConfiguration.ff("scroll"), BrowserConfiguration.ie11up("scroll")),
        BACKGROUND_ATTACHMENT_("background-attachment", "background-attachment", BrowserConfiguration.ff38up("scroll")),
        BACKGROUND_BLEND_MODE("backgroundBlendMode", "background-blend-mode", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        BACKGROUND_BLEND_MODE_("background-blend-mode", "background-blend-mode", BrowserConfiguration.ff38up("normal")),
        BACKGROUND_CLIP("backgroundClip", "background-clip", BrowserConfiguration.ff("border-box"), BrowserConfiguration.ie11up("border-box"), BrowserConfiguration.chrome("border-box")),
        BACKGROUND_CLIP_("background-clip", "background-clip", BrowserConfiguration.ff38up("border-box")),
        BACKGROUND_COLOR("backgroundColor", "background-color", BrowserConfiguration.chrome("rgba(0, 0, 0, 0)"), BrowserConfiguration.ff("transparent"), BrowserConfiguration.ie("transparent")),
        BACKGROUND_COLOR_("background-color", "background-color", BrowserConfiguration.ff38up("transparent")),
        BACKGROUND_IMAGE("backgroundImage", "background-image", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BACKGROUND_IMAGE_("background-image", "background-image", BrowserConfiguration.ff38up("none")),
        BACKGROUND_ORIGIN("backgroundOrigin", "background-origin", BrowserConfiguration.ff("padding-box"), BrowserConfiguration.ie11up("padding-box"), BrowserConfiguration.chrome("padding-box")),
        BACKGROUND_ORIGIN_("background-origin", "background-origin", BrowserConfiguration.ff38up("padding-box")),
        BACKGROUND_POSITION("backgroundPosition", "background-position", BrowserConfiguration.chrome("0% 0%"), BrowserConfiguration.ff("0% 0%"), BrowserConfiguration.ie11up("0% 0%")),
        BACKGROUND_POSITION_("background-position", "background-position", BrowserConfiguration.ff38up("0% 0%")),
        BACKGROUND_POSITION_X("backgroundPositionX", "background-position-x", BrowserConfiguration.ie11up("undefined"), BrowserConfiguration.chrome("0%")),
        BACKGROUND_POSITION_Y("backgroundPositionY", "background-position-y", BrowserConfiguration.ie11up("undefined"), BrowserConfiguration.chrome("0%")),
        BACKGROUND_REPEAT("backgroundRepeat", "background-repeat", BrowserConfiguration.chrome("repeat"), BrowserConfiguration.ff("repeat"), BrowserConfiguration.ie("repeat")),
        BACKGROUND_REPEAT_("background-repeat", "background-repeat", BrowserConfiguration.ff38up("repeat")),
        BACKGROUND_REPEAT_X("backgroundRepeatX", "background-repeat-x", BrowserConfiguration.chrome("")),
        BACKGROUND_REPEAT_Y("backgroundRepeatY", "background-repeat-y", BrowserConfiguration.chrome("")),
        BACKGROUND_SIZE("backgroundSize", "background-size", BrowserConfiguration.ff("auto auto"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        BACKGROUND_SIZE_("background-size", "background-size", BrowserConfiguration.ff38up("auto auto")),
        BASELINE_SHIFT("baselineShift", "baseline-shift", BrowserConfiguration.ie11up("baseline"), BrowserConfiguration.chrome("0px")),
        BEHAVIOR("behavior", "behavior", new BrowserConfiguration[0]),
        BORDER("border", "border", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        BORDER_BOTTOM("borderBottom", "border-bottom", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        BORDER_BOTTOM_("border-bottom", "border-bottom", BrowserConfiguration.ff38up("")),
        BORDER_BOTTOM_COLOR("borderBottomColor", "border-bottom-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("rgb(0, 0, 0)")),
        BORDER_BOTTOM_COLOR_("border-bottom-color", "border-bottom-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        BORDER_BOTTOM_LEFT_RADIUS("borderBottomLeftRadius", "border-bottom-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_BOTTOM_LEFT_RADIUS_("border-bottom-left-radius", "border-bottom-left-radius", BrowserConfiguration.ff38up("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS("borderBottomRightRadius", "border-bottom-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS_("border-bottom-right-radius", "border-bottom-right-radius", BrowserConfiguration.ff38up("0px")),
        BORDER_BOTTOM_STYLE("borderBottomStyle", "border-bottom-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BORDER_BOTTOM_STYLE_("border-bottom-style", "border-bottom-style", BrowserConfiguration.ff38up("none")),
        BORDER_BOTTOM_WIDTH("borderBottomWidth", "border-bottom-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px")),
        BORDER_BOTTOM_WIDTH_("border-bottom-width", "border-bottom-width", BrowserConfiguration.ff38up("0px")),
        BORDER_COLLAPSE("borderCollapse", "border-collapse", BrowserConfiguration.chrome("separate"), BrowserConfiguration.ff("separate"), BrowserConfiguration.ie("separate")),
        BORDER_COLLAPSE_("border-collapse", "border-collapse", BrowserConfiguration.ff38up("separate")),
        BORDER_COLOR("borderColor", "border-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        BORDER_COLOR_("border-color", "border-color", BrowserConfiguration.ff38up("")),
        BORDER_IMAGE("borderImage", "border-image", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("none")),
        BORDER_IMAGE_("border-image", "border-image", BrowserConfiguration.ff38up("")),
        BORDER_IMAGE_OUTSET("borderImageOutset", "border-image-outset", BrowserConfiguration.ff("0 0 0 0"), BrowserConfiguration.ie11up("0"), BrowserConfiguration.chrome("0px")),
        BORDER_IMAGE_OUTSET_("border-image-outset", "border-image-outset", BrowserConfiguration.ff38up("0 0 0 0")),
        BORDER_IMAGE_REPEAT("borderImageRepeat", "border-image-repeat", BrowserConfiguration.ff("stretch stretch"), BrowserConfiguration.ie11up("stretch"), BrowserConfiguration.chrome("stretch")),
        BORDER_IMAGE_REPEAT_("border-image-repeat", "border-image-repeat", BrowserConfiguration.ff38up("stretch stretch")),
        BORDER_IMAGE_SLICE("borderImageSlice", "border-image-slice", BrowserConfiguration.ff("100% 100% 100% 100%"), BrowserConfiguration.ie11up("100%"), BrowserConfiguration.chrome("100%")),
        BORDER_IMAGE_SLICE_("border-image-slice", "border-image-slice", BrowserConfiguration.ff38up("100% 100% 100% 100%")),
        BORDER_IMAGE_SOURCE("borderImageSource", "border-image-source", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        BORDER_IMAGE_SOURCE_("border-image-source", "border-image-source", BrowserConfiguration.ff38up("none")),
        BORDER_IMAGE_WIDTH("borderImageWidth", "border-image-width", BrowserConfiguration.ff("1 1 1 1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        BORDER_IMAGE_WIDTH_("border-image-width", "border-image-width", BrowserConfiguration.ff38up("1 1 1 1")),
        BORDER_LEFT("borderLeft", "border-left", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        BORDER_LEFT_("border-left", "border-left", BrowserConfiguration.ff38up("")),
        BORDER_LEFT_COLOR("borderLeftColor", "border-left-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("rgb(0, 0, 0)")),
        BORDER_LEFT_COLOR_("border-left-color", "border-left-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        BORDER_LEFT_STYLE("borderLeftStyle", "border-left-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BORDER_LEFT_STYLE_("border-left-style", "border-left-style", BrowserConfiguration.ff38up("none")),
        BORDER_LEFT_WIDTH("borderLeftWidth", "border-left-width", BrowserConfiguration.chrome("0px")),
        BORDER_LEFT_WIDTH_("border-left-width", "border-left-width", BrowserConfiguration.ff38up("0px")),
        BORDER_RADIUS("borderRadius", "border-radius", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("0px")),
        BORDER_RADIUS_("border-radius", "border-radius", BrowserConfiguration.ff38up("")),
        BORDER_RIGHT("borderRight", "border-right", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        BORDER_RIGHT_("border-right", "border-right", BrowserConfiguration.ff38up("")),
        BORDER_RIGHT_COLOR("borderRightColor", "border-right-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        BORDER_RIGHT_COLOR_("border-right-color", "border-right-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        BORDER_RIGHT_STYLE("borderRightStyle", "border-right-style", BrowserConfiguration.chrome("none")),
        BORDER_RIGHT_STYLE_("border-right-style", "border-right-style", BrowserConfiguration.ff38up("none")),
        BORDER_RIGHT_WIDTH("borderRightWidth", "border-right-width", BrowserConfiguration.chrome("0px")),
        BORDER_RIGHT_WIDTH_("border-right-width", "border-right-width", BrowserConfiguration.ff38up("0px")),
        BORDER_SPACING("borderSpacing", "border-spacing", BrowserConfiguration.chrome("0px 0px")),
        BORDER_SPACING_("border-spacing", "border-spacing", BrowserConfiguration.ff38up("0px 0px")),
        BORDER_STYLE("borderStyle", "border-style", BrowserConfiguration.chrome("none")),
        BORDER_STYLE_("border-style", "border-style", BrowserConfiguration.ff38up("")),
        BORDER_TOP("borderTop", "border-top", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        BORDER_TOP_("border-top", "border-top", BrowserConfiguration.ff38up("")),
        BORDER_TOP_COLOR("borderTopColor", "border-top-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        BORDER_TOP_COLOR_("border-top-color", "border-top-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        BORDER_TOP_LEFT_RADIUS("borderTopLeftRadius", "border-top-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_TOP_LEFT_RADIUS_("border-top-left-radius", "border-top-left-radius", BrowserConfiguration.ff38up("0px")),
        BORDER_TOP_RIGHT_RADIUS("borderTopRightRadius", "border-top-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_TOP_RIGHT_RADIUS_("border-top-right-radius", "border-top-right-radius", BrowserConfiguration.ff38up("0px")),
        BORDER_TOP_STYLE("borderTopStyle", "border-top-style", BrowserConfiguration.chrome("none")),
        BORDER_TOP_STYLE_("border-top-style", "border-top-style", BrowserConfiguration.ff38up("none")),
        BORDER_TOP_WIDTH("borderTopWidth", "border-top-width", BrowserConfiguration.chrome("0px")),
        BORDER_TOP_WIDTH_("border-top-width", "border-top-width", BrowserConfiguration.ff38up("0px")),
        BORDER_WIDTH("borderWidth", "border-width", BrowserConfiguration.chrome("0px")),
        BORDER_WIDTH_("border-width", "border-width", BrowserConfiguration.ff38up("")),
        BOTTOM("bottom", "bottom", BrowserConfiguration.chrome("auto")),
        BOX_DECORATION_BREAK("boxDecorationBreak", "box-decoration-break", BrowserConfiguration.ff38up("slice")),
        BOX_DECORATION_BREAK_("box-decoration-break", "box-decoration-break", BrowserConfiguration.ff38up("slice")),
        BOX_SHADOW("boxShadow", "box-shadow", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        BOX_SHADOW_("box-shadow", "box-shadow", BrowserConfiguration.ff38up("none")),
        BOX_SIZING("boxSizing", "box-sizing", BrowserConfiguration.ff("content-box"), BrowserConfiguration.ie11up("content-box"), BrowserConfiguration.chrome("content-box")),
        BOX_SIZING_("box-sizing", "box-sizing", BrowserConfiguration.ff38up("content-box")),
        BREAK_AFTER("breakAfter", "break-after", BrowserConfiguration.ie11up("auto")),
        BREAK_BEFORE("breakBefore", "break-before", BrowserConfiguration.ie11up("auto")),
        BREAK_INSIDE("breakInside", "break-inside", BrowserConfiguration.ie11up("auto")),
        BUFFERED_RENDERING("bufferedRendering", "buffered-rendering", BrowserConfiguration.chrome("auto")),
        CAPTION_SIDE("captionSide", "caption-side", BrowserConfiguration.chrome("top")),
        CAPTION_SIDE_("caption-side", "caption-side", BrowserConfiguration.ff38up("top")),
        CLEAR("clear", "clear", BrowserConfiguration.chrome("none")),
        CLIP("clip", "clip", BrowserConfiguration.chrome("auto")),
        CLIP_PATH("clipPath", "clip-path", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        CLIP_PATH_("clip-path", "clip-path", BrowserConfiguration.ff38up("none")),
        CLIP_RULE("clipRule", "clip-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie11up("nonzero"), BrowserConfiguration.chrome("nonzero")),
        CLIP_RULE_("clip-rule", "clip-rule", BrowserConfiguration.ff38up("nonzero")),
        COLOR("color", "color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        COLOR_INTERPOLATION("colorInterpolation", "color-interpolation", BrowserConfiguration.ff("srgb"), BrowserConfiguration.chrome("sRGB")),
        COLOR_INTERPOLATION_("color-interpolation", "color-interpolation", BrowserConfiguration.ff38up("srgb")),
        COLOR_INTERPOLATION_FILTERS("colorInterpolationFilters", "color-interpolation-filters", BrowserConfiguration.ff("linearrgb"), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("linearRGB")),
        COLOR_INTERPOLATION_FILTERS_("color-interpolation-filters", "color-interpolation-filters", BrowserConfiguration.ff38up("linearrgb")),
        COLOR_RENDERING("colorRendering", "color-rendering", BrowserConfiguration.chrome("auto")),
        COLUMN_COUNT("columnCount", "column-count", BrowserConfiguration.ie11up("auto")),
        COLUMN_FILL("columnFill", "column-fill", BrowserConfiguration.ie11up("balance")),
        COLUMN_GAP("columnGap", "column-gap", BrowserConfiguration.ie11up("normal")),
        COLUMN_RULE("columnRule", "column-rule", BrowserConfiguration.ie11up("")),
        COLUMN_RULE_COLOR("columnRuleColor", "column-rule-color", BrowserConfiguration.ie11up("rgb(0, 0, 0)")),
        COLUMN_RULE_STYLE("columnRuleStyle", "column-rule-style", BrowserConfiguration.ie11up("none")),
        COLUMN_RULE_WIDTH("columnRuleWidth", "column-rule-width", BrowserConfiguration.ie11up("medium")),
        COLUMN_SPAN("columnSpan", "column-span", BrowserConfiguration.ie11up("1")),
        COLUMN_WIDTH("columnWidth", "column-width", BrowserConfiguration.ie11up("auto")),
        COLUMNS("columns", "columns", BrowserConfiguration.ie11up("")),
        CONTENT("content", "content", BrowserConfiguration.ie11up("normal"), BrowserConfiguration.chrome(""), BrowserConfiguration.ff("none")),
        COUNTER_INCREMENT("counterIncrement", "counter-increment", BrowserConfiguration.chrome("none")),
        COUNTER_INCREMENT_("counter-increment", "counter-increment", BrowserConfiguration.ff38up("none")),
        COUNTER_RESET("counterReset", "counter-reset", BrowserConfiguration.chrome("none")),
        COUNTER_RESET_("counter-reset", "counter-reset", BrowserConfiguration.ff38up("none")),
        CSS_FLOAT("cssFloat", "css-float", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        CSS_TEXT("cssText", "css-text", BrowserConfiguration.chrome("")),
        CUE("cue", "cue", new BrowserConfiguration[0]),
        CUE_AFTER("cueAfter", "cue-after", new BrowserConfiguration[0]),
        CUE_BEFORE("cueBefore", "cue-before", new BrowserConfiguration[0]),
        CURSOR("cursor", "cursor", BrowserConfiguration.chrome("auto")),
        CX("cx", "cx", BrowserConfiguration.chrome("0px")),
        CY("cy", "cy", BrowserConfiguration.chrome("0px")),
        DIRECTION("direction", "direction", BrowserConfiguration.chrome("ltr")),
        DISPLAY("display", "display", BrowserConfiguration.chrome("block")),
        DOMINANT_BASELINE("dominantBaseline", "dominant-baseline", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        DOMINANT_BASELINE_("dominant-baseline", "dominant-baseline", BrowserConfiguration.ff38up("auto")),
        ELEVATION("elevation", "elevation", new BrowserConfiguration[0]),
        EMPTY_CELLS("emptyCells", "empty-cells", BrowserConfiguration.ie11up("show"), BrowserConfiguration.ffBelow38("-moz-show-background"), BrowserConfiguration.ff38up("show"), BrowserConfiguration.chrome("show")),
        EMPTY_CELLS_("empty-cells", "empty-cells", BrowserConfiguration.ff38up("show")),
        ENABLE_BACKGROUND("enableBackground", "enable-background", BrowserConfiguration.ie11up("accumulate")),
        FILL("fill", "fill", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up("black"), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        FILL_OPACITY("fillOpacity", "fill-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        FILL_OPACITY_("fill-opacity", "fill-opacity", BrowserConfiguration.ff38up("1")),
        FILL_RULE("fillRule", "fill-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie11up("nonzero"), BrowserConfiguration.chrome("nonzero")),
        FILL_RULE_("fill-rule", "fill-rule", BrowserConfiguration.ff38up("nonzero")),
        FILTER("filter", "filter", BrowserConfiguration.ff("none"), BrowserConfiguration.ieBelow11(""), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        FLEX("flex", "flex", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("0 1 auto"), BrowserConfiguration.chrome("0 1 auto")),
        FLEX_BASIS("flexBasis", "flex-basis", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        FLEX_BASIS_("flex-basis", "flex-basis", BrowserConfiguration.ff38up("auto")),
        FLEX_DIRECTION("flexDirection", "flex-direction", BrowserConfiguration.ff("row"), BrowserConfiguration.ie11up("row"), BrowserConfiguration.chrome("row")),
        FLEX_DIRECTION_("flex-direction", "flex-direction", BrowserConfiguration.ff38up("row")),
        FLEX_FLOW("flexFlow", "flex-flow", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("row nowrap"), BrowserConfiguration.chrome("row nowrap")),
        FLEX_FLOW_("flex-flow", "flex-flow", BrowserConfiguration.ff38up("")),
        FLEX_GROW("flexGrow", "flex-grow", BrowserConfiguration.ff("0"), BrowserConfiguration.ie11up("0"), BrowserConfiguration.chrome("0")),
        FLEX_GROW_("flex-grow", "flex-grow", BrowserConfiguration.ff38up("0")),
        FLEX_SHRINK("flexShrink", "flex-shrink", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        FLEX_SHRINK_("flex-shrink", "flex-shrink", BrowserConfiguration.ff38up("1")),
        FLEX_WRAP("flexWrap", "flex-wrap", BrowserConfiguration.ff("nowrap"), BrowserConfiguration.ie11up("nowrap"), BrowserConfiguration.chrome("nowrap")),
        FLEX_WRAP_("flex-wrap", "flex-wrap", BrowserConfiguration.ff38up("nowrap")),
        FLOAT("float", "float", BrowserConfiguration.ff38up("none"), BrowserConfiguration.chrome("none")),
        FLOOD_COLOR("floodColor", "flood-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        FLOOD_COLOR_("flood-color", "flood-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        FLOOD_OPACITY("floodOpacity", "flood-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        FLOOD_OPACITY_("flood-opacity", "flood-opacity", BrowserConfiguration.ff38up("1")),
        FONT("font", "font", BrowserConfiguration.chrome("normal normal normal normal 16px / normal 'Times New Roman'")),
        FONT_FAMILY("fontFamily", "font-family", BrowserConfiguration.chrome("'Times New Roman'"), BrowserConfiguration.ie11up("Times New Roman"), BrowserConfiguration.ff("serif")),
        FONT_FAMILY_("font-family", "font-family", BrowserConfiguration.ff38up("serif")),
        FONT_FEATURE_SETTINGS("fontFeatureSettings", "font-feature-settings", BrowserConfiguration.ie11up("normal"), BrowserConfiguration.ff38up("normal")),
        FONT_FEATURE_SETTINGS_("font-feature-settings", "font-feature-settings", BrowserConfiguration.ff38up("normal")),
        FONT_KERNING("fontKerning", "font-kerning", BrowserConfiguration.ff38up("auto"), BrowserConfiguration.chrome("auto")),
        FONT_KERNING_("font-kerning", "font-kerning", BrowserConfiguration.ff38up("auto")),
        FONT_LANGUAGE_OVERRIDE("fontLanguageOverride", "font-language-override", BrowserConfiguration.ff38up("normal")),
        FONT_LANGUAGE_OVERRIDE_("font-language-override", "font-language-override", BrowserConfiguration.ff38up("normal")),
        FONT_SIZE("fontSize", "font-size", BrowserConfiguration.chrome("16px")),
        FONT_SIZE_("font-size", "font-size", BrowserConfiguration.ff38up("16px")),
        FONT_SIZE_ADJUST_("font-size-adjust", "font-size-adjust", BrowserConfiguration.ff38up("none")),
        FONT_STRETCH("fontStretch", "font-stretch", BrowserConfiguration.chrome("normal")),
        FONT_STRETCH_("font-stretch", "font-stretch", BrowserConfiguration.ff38up("normal")),
        FONT_STYLE("fontStyle", "font-style", BrowserConfiguration.chrome("normal")),
        FONT_STYLE_("font-style", "font-style", BrowserConfiguration.ff38up("normal")),
        FONT_SYNTHESIS("fontSynthesis", "font-synthesis", BrowserConfiguration.ff38up("weight style")),
        FONT_SYNTHESIS_("font-synthesis", "font-synthesis", BrowserConfiguration.ff38up("weight style")),
        FONT_VARIANT("fontVariant", "font-variant", BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_("font-variant", "font-variant", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_ALTERNATES("fontVariantAlternates", "font-variant-alternates", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_ALTERNATES_("font-variant-alternates", "font-variant-alternates", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_CAPS("fontVariantCaps", "font-variant-caps", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_CAPS_("font-variant-caps", "font-variant-caps", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_EAST_ASIAN("fontVariantEastAsian", "font-variant-east-asian", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_EAST_ASIAN_("font-variant-east-asian", "font-variant-east-asian", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_LIGATURES("fontVariantLigatures", "font-variant-ligatures", BrowserConfiguration.ff38up("normal"), BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_LIGATURES_("font-variant-ligatures", "font-variant-ligatures", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_NUMERIC("fontVariantNumeric", "font-variant-numeric", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_NUMERIC_("font-variant-numeric", "font-variant-numeric", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_POSITION("fontVariantPosition", "font-variant-position", BrowserConfiguration.ff38up("normal")),
        FONT_VARIANT_POSITION_("font-variant-position", "font-variant-position", BrowserConfiguration.ff38up("normal")),
        FONT_WEIGHT("fontWeight", "font-weight", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("400"), BrowserConfiguration.ie("400")),
        FONT_WEIGHT_("font-weight", "font-weight", BrowserConfiguration.ff38up("400")),
        GLYPH_ORIENTATION_HORIZONTAL("glyphOrientationHorizontal", "glyph-orientation-horizontal", BrowserConfiguration.ie11up("0deg"), BrowserConfiguration.chrome("0deg")),
        GLYPH_ORIENTATION_VERTICAL("glyphOrientationVertical", "glyph-orientation-vertical", BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        HEIGHT("height", "height", BrowserConfiguration.chrome("skipped")),
        IMAGE_ORIENTATION("imageOrientation", "image-orientation", BrowserConfiguration.ff("0deg")),
        IMAGE_ORIENTATION_("image-orientation", "image-orientation", BrowserConfiguration.ff38up("0deg")),
        IMAGE_RENDERING("imageRendering", "image-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        IMAGE_RENDERING_("image-rendering", "image-rendering", BrowserConfiguration.ff38up("auto")),
        IME_MODE("imeMode", "ime-mode", BrowserConfiguration.ie11up("undefined"), BrowserConfiguration.ff("auto")),
        IME_MODE_("ime-mode", "ime-mode", BrowserConfiguration.ff38up("auto")),
        ISOLATION("isolation", "isolation", BrowserConfiguration.ff38up("auto"), BrowserConfiguration.chrome("auto")),
        JUSTIFY_CONTENT("justifyContent", "justify-content", BrowserConfiguration.ff("flex-start"), BrowserConfiguration.ie11up("flex-start"), BrowserConfiguration.chrome("start")),
        JUSTIFY_CONTENT_("justify-content", "justify-content", BrowserConfiguration.ff38up("flex-start")),
        KERNING("kerning", "kerning", BrowserConfiguration.ie11up("auto")),
        LAYOUT_FLOW("layoutFlow", "layout-flow", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID("layoutGrid", "layout-grid", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_CHAR("layoutGridChar", "layout-grid-char", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_LINE("layoutGridLine", "layout-grid-line", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_MODE("layoutGridMode", "layout-grid-mode", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_TYPE("layoutGridType", "layout-grid-type", BrowserConfiguration.ie11up("undefined")),
        LEFT("left", "left", BrowserConfiguration.chrome("auto")),
        LETTER_SPACING("letterSpacing", "letter-spacing", BrowserConfiguration.chrome("normal")),
        LETTER_SPACING_("letter-spacing", "letter-spacing", BrowserConfiguration.ff38up("normal")),
        LIGHTING_COLOR("lightingColor", "lighting-color", BrowserConfiguration.ff("rgb(255, 255, 255)"), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("rgb(255, 255, 255)")),
        LIGHTING_COLOR_("lighting-color", "lighting-color", BrowserConfiguration.ff38up("rgb(255, 255, 255)")),
        LINE_BREAK("lineBreak", "line-break", BrowserConfiguration.ie11up("undefined")),
        LINE_HEIGHT("lineHeight", "line-height", BrowserConfiguration.ff("20px"), BrowserConfiguration.ieBelow11("20px"), BrowserConfiguration.ie11up("normal"), BrowserConfiguration.chrome("normal")),
        LINE_HEIGHT_("line-height", "line-height", BrowserConfiguration.ff38up("20px")),
        LIST_STYLE("listStyle", "list-style", BrowserConfiguration.chrome("disc outside none")),
        LIST_STYLE_("list-style", "list-style", BrowserConfiguration.ff38up("")),
        LIST_STYLE_IMAGE("listStyleImage", "list-style-image", BrowserConfiguration.chrome("none")),
        LIST_STYLE_IMAGE_("list-style-image", "list-style-image", BrowserConfiguration.ff38up("none")),
        LIST_STYLE_POSITION("listStylePosition", "list-style-position", BrowserConfiguration.chrome("outside")),
        LIST_STYLE_POSITION_("list-style-position", "list-style-position", BrowserConfiguration.ff38up("outside")),
        LIST_STYLE_TYPE("listStyleType", "list-style-type", BrowserConfiguration.chrome("disc")),
        LIST_STYLE_TYPE_("list-style-type", "list-style-type", BrowserConfiguration.ff38up("disc")),
        MARGIN("margin", "margin", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        MARGIN_BOTTOM("marginBottom", "margin-bottom", BrowserConfiguration.chrome("0px")),
        MARGIN_BOTTOM_("margin-bottom", "margin-bottom", BrowserConfiguration.ff38up("0px")),
        MARGIN_LEFT("marginLeft", "margin-left", BrowserConfiguration.chrome("0px")),
        MARGIN_LEFT_("margin-left", "margin-left", BrowserConfiguration.ff38up("0px")),
        MARGIN_RIGHT("marginRight", "margin-right", BrowserConfiguration.chrome("0px")),
        MARGIN_RIGHT_("margin-right", "margin-right", BrowserConfiguration.ff38up("0px")),
        MARGIN_TOP("marginTop", "margin-top", BrowserConfiguration.chrome("0px")),
        MARGIN_TOP_("margin-top", "margin-top", BrowserConfiguration.ff38up("0px")),
        MARKER("marker", "marker", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("")),
        MARKER_END("markerEnd", "marker-end", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        MARKER_END_("marker-end", "marker-end", BrowserConfiguration.ff38up("none")),
        MARKER_MID("markerMid", "marker-mid", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        MARKER_MID_("marker-mid", "marker-mid", BrowserConfiguration.ff38up("none")),
        MARKER_OFFSET_("marker-offset", "marker-offset", BrowserConfiguration.ff38up("auto")),
        MARKER_START("markerStart", "marker-start", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        MARKER_START_("marker-start", "marker-start", BrowserConfiguration.ff38up("none")),
        MASK("mask", "mask", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        MASK_TYPE("maskType", "mask-type", BrowserConfiguration.ff38up("luminance"), BrowserConfiguration.chrome("luminance")),
        MASK_TYPE_("mask-type", "mask-type", BrowserConfiguration.ff38up("luminance")),
        MAX_HEIGHT("maxHeight", "max-height", BrowserConfiguration.chrome("none")),
        MAX_HEIGHT_("max-height", "max-height", BrowserConfiguration.ff38up("none")),
        MAX_WIDTH("maxWidth", "max-width", BrowserConfiguration.chrome("none")),
        MAX_WIDTH_("max-width", "max-width", BrowserConfiguration.ff38up("none")),
        MAX_ZOOM("maxZoom", "max-zoom", BrowserConfiguration.chrome("")),
        MIN_HEIGHT("minHeight", "min-height", BrowserConfiguration.chrome("0px")),
        MIN_HEIGHT_("min-height", "min-height", BrowserConfiguration.ff38up("0px")),
        MIN_WIDTH("minWidth", "min-width", BrowserConfiguration.chrome("0px")),
        MIN_WIDTH_("min-width", "min-width", BrowserConfiguration.ff38up("0px")),
        MIN_ZOOM("minZoom", "min-zoom", BrowserConfiguration.chrome("")),
        MIX_BLEND_MODE("mixBlendMode", "mix-blend-mode", BrowserConfiguration.ff38up("normal"), BrowserConfiguration.chrome("normal")),
        MIX_BLEND_MODE_("mix-blend-mode", "mix-blend-mode", BrowserConfiguration.ff38up("normal")),
        MOTION("motion", "motion", BrowserConfiguration.chrome("none 0px auto 0deg")),
        MOTION_OFFSET("motionOffset", "motion-offset", BrowserConfiguration.chrome("0px")),
        MOTION_PATH("motionPath", "motion-path", BrowserConfiguration.chrome("none")),
        MOTION_ROTATION("motionRotation", "motion-rotation", BrowserConfiguration.chrome("auto 0deg")),
        MOZ_ANIMATION("MozAnimation", "-moz-animation", BrowserConfiguration.ff("")),
        MOZ_ANIMATION_DELAY("MozAnimationDelay", "-moz-animation-delay", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_DIRECTION("MozAnimationDirection", "-moz-animation-direction", BrowserConfiguration.ff("normal")),
        MOZ_ANIMATION_DURATION("MozAnimationDuration", "-moz-animation-duration", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_FILL_MODE("MozAnimationFillMode", "moz-animation-fill-mode", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_ITERATION_COUNT("MozAnimationIterationCount", "-moz-animation-iteration-count", BrowserConfiguration.ff("1")),
        MOZ_ANIMATION_NAME("MozAnimationName", "moz-annimation-name", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_PLAY_STATE("MozAnimationPlayState", "moz-annimation-play-state", BrowserConfiguration.ff("running")),
        MOZ_ANIMATION_TIMING_FUNCTION("MozAnimationTimingFunction", "moz-annimation-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_APPEARANCE("MozAppearance", "-moz-appearance", BrowserConfiguration.ff("none")),
        MOZ_BACKFACE_VISIBILITY("MozBackfaceVisibility", "-moz-backface-visibility", BrowserConfiguration.ff("visible")),
        MOZ_BACKGROUND_CLIP("MozBackgroundClip", "-moz-background-clip", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_INLINE_POLICY("MozBackgroundInlinePolicy", "-moz-background-inline-policy", BrowserConfiguration.ffBelow38("continuous")),
        MOZ_BACKGROUND_ORIGIN("MozBackgroundOrigin", "-moz-background-origin", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_SIZE("MozBackgroundSize", "-moz-background-size", new BrowserConfiguration[0]),
        MOZ_BINDING("MozBinding", "-moz-binding", BrowserConfiguration.ff("none")),
        MOZ_BORDER_BOTTOM_COLORS("MozBorderBottomColors", "-moz-border-bottom-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_END("MozBorderEnd", "-moz-border-end", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_COLOR("MozBorderEndColor", "-moz-border-end-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_STYLE("MozBorderEndStyle", "-moz-border-end-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_WIDTH("MozBorderEndWidth", "-moz-border-end-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_IMAGE("MozBorderImage", "-moz-border-image", BrowserConfiguration.ff("")),
        MOZ_BORDER_LEFT_COLORS("MozBorderLeftColors", "-moz-border-left-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_RADIUS("MozBorderRadius", "-moz-border-radius", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMLEFT("MozBorderRadiusBottomleft", "-moz-border-radius-bottomleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMRIGHT("MozBorderRadiusBottomright", "-moz-border-radius-bottomright", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPLEFT("MozBorderRadiusTopleft", "-moz-border-radius-topleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPRIGHT("MozBorderRadiusTopright", "-moz-border-radius-topright", new BrowserConfiguration[0]),
        MOZ_BORDER_RIGHT_COLORS("MozBorderRightColors", "-moz-border-right-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_START("MozBorderStart", "-moz-border-start", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_COLOR("MozBorderStartColor", "-moz-border-start-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_STYLE("MozBorderStartStyle", "-moz-border-start-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_WIDTH("MozBorderStartWidth", "-moz-border-start-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_TOP_COLORS("MozBorderTopColors", "-moz-border-top-colors", BrowserConfiguration.ff("none")),
        MOZ_BOX_ALIGN("MozBoxAlign", "-moz-box-align", BrowserConfiguration.ff("stretch")),
        MOZ_BOX_DIRECTION("MozBoxDirection", "-moz-box-direction", BrowserConfiguration.ff("normal")),
        MOZ_BOX_FLEX("MozBoxFlex", "-moz-box-flex", BrowserConfiguration.ff("0")),
        MOZ_BOX_ORDINAL_GROUP("MozBoxOrdinalGroup", "-moz-box-ordinal-group", BrowserConfiguration.ff("1")),
        MOZ_BOX_ORIENT("MozBoxOrient", "-moz-box-orient", BrowserConfiguration.ff("horizontal")),
        MOZ_BOX_PACK("MozBoxPack", "-moz-box-pack", BrowserConfiguration.ff("start")),
        MOZ_BOX_SHADOW("MozBoxShadow", "-moz-box-shadow", new BrowserConfiguration[0]),
        MOZ_BOX_SIZING("MozBoxSizing", "-moz-box-sizing", BrowserConfiguration.ff("content-box")),
        MOZ_COLUMN_COUNT("MozColumnCount", "-moz-column-count", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_FILL("MozColumnFill", "-moz-column-fill", BrowserConfiguration.ff("balance")),
        MOZ_COLUMN_GAP("MozColumnGap", "-moz-column-gap", BrowserConfiguration.ff("16px")),
        MOZ_COLUMN_RULE("MozColumnRule", "-moz-column-rule", BrowserConfiguration.ff("")),
        MOZ_COLUMN_RULE_COLOR("MozColumnRuleColor", "-moz-column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_COLUMN_RULE_STYLE("MozColumnRuleStyle", "-moz-column-rule-style", BrowserConfiguration.ff("none")),
        MOZ_COLUMN_RULE_WIDTH("MozColumnRuleWidth", "-moz-column-rule-width", BrowserConfiguration.ff("0px")),
        MOZ_COLUMN_WIDTH("MozColumnWidth", "-moz-column-width", BrowserConfiguration.ff("auto")),
        MOZ_COLUMNS("MozColumns", "-moz-columns", BrowserConfiguration.ff("")),
        MOZ_FLOAT_EDGE("MozFloatEdge", "-moz-float-edge", BrowserConfiguration.ff("content-box")),
        MOZ_FONT_FEATURE_SETTINGS("MozFontFeatureSettings", "-moz-font-feature-settings", BrowserConfiguration.ff("normal")),
        MOZ_FONT_LANGUAGE_OVERRIDE("MozFontLanguageOverride", "-moz-font-language-override", BrowserConfiguration.ff("normal")),
        MOZ_FORCE_BROKEN_IMAGE_ICON("MozForceBrokenImageIcon", "-moz-force-broken-image-icon", BrowserConfiguration.ff("0")),
        MOZ_HYPHENS("MozHyphens", "-moz-hyphens", BrowserConfiguration.ff("manual")),
        MOZ_IMAGE_REGION("MozImageRegion", "-moz-image-region", BrowserConfiguration.ff("auto")),
        MOZ_MARGIN_END("MozMarginEnd", "-moz-margin-end", BrowserConfiguration.ff("")),
        MOZ_MARGIN_START("MozMarginStart", "-moz-margin-start", BrowserConfiguration.ff("")),
        MOZ_OPACITY("MozOpacity", "-moz-opacity", new BrowserConfiguration[0]),
        MOZ_ORIENT("MozOrient", "-moz-orient", BrowserConfiguration.ff("auto"), BrowserConfiguration.ff("horizontal")),
        MOZ_OUTLINE("MozOutline", "-moz-outline", new BrowserConfiguration[0]),
        MOZ_OUTLINE_COLOR("MozOutlineColor", "-moz-outline-color", new BrowserConfiguration[0]),
        MOZ_OUTLINE_OFFSET("MozOutlineOffset", "-moz-outline-offset", new BrowserConfiguration[0]),
        MOZ_OUTLINE_RADIUS("MozOutlineRadius", "-mz-outline-radius", BrowserConfiguration.ff("")),
        MOZ_OUTLINE_RADIUS_BOTTOMLEFT("MozOutlineRadiusBottomleft", "-moz-outline-radius-bottomleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMRIGHT("MozOutlineRadiusBottomright", "-moz-outline-radius-bottomright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPLEFT("MozOutlineRadiusTopleft", "-moz-outline-radius-topleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPRIGHT("MozOutlineRadiusTopright", "-moz-outline-radius-topright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_STYLE("MozOutlineStyle", "-moz-outline-style", new BrowserConfiguration[0]),
        MOZ_OUTLINE_WIDTH("MozOutlineWidth", "-moz-outline-width", new BrowserConfiguration[0]),
        MOZ_PADDING_END("MozPaddingEnd", "-moz-padding-end", BrowserConfiguration.ff("")),
        MOZ_PADDING_START("MozPaddingStart", "-moz-padding-start", BrowserConfiguration.ff("")),
        MOZ_PERSPECTIVE("MozPerspective", "-moz-perspective", BrowserConfiguration.ff("none")),
        MOZ_PERSPECTIVE_ORIGIN("MozPerspectiveOrigin", "-moz-perspective-origin", BrowserConfiguration.ff("621px 172.5px")),
        MOZ_STACK_SIZING("MozStackSizing", "-moz-stack-sizing", BrowserConfiguration.ff("stretch-to-fit")),
        MOZ_TAB_SIZE("MozTabSize", "-moz-tab-size", BrowserConfiguration.ff("8")),
        MOZ_TEXT_ALIGN_LAST("MozTextAlignLast", "-moz-text-align-last", BrowserConfiguration.ff("auto")),
        MOZ_TEXT_BLINK("MozTextBlink", "-moz-text-blink", BrowserConfiguration.ffBelow31("none")),
        MOZ_TEXT_DECORATION_COLOR("MozTextDecorationColor", "-moz-text-decoration-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_TEXT_DECORATION_LINE("MozTextDecorationLine", "-moz-text-decoration-line", BrowserConfiguration.ff("none")),
        MOZ_TEXT_DECORATION_STYLE("MozTextDecorationStyle", "-moz-text-decoration-style", BrowserConfiguration.ff("solid")),
        MOZ_TEXT_SIZE_ADJUST("MozTextSizeAdjust", "-moz-text-size-adjust", BrowserConfiguration.ff("auto")),
        MOZ_TRANSFORM("MozTransform", "-moz-transform", BrowserConfiguration.ff("none")),
        MOZ_TRANSFORM_ORIGIN("MozTransformOrigin", "-moz-transform-origin", BrowserConfiguration.ff("621px 172.5px")),
        MOZ_TRANSFORM_STYLE("MozTransformStyle", "-moz-transform-style", BrowserConfiguration.ff("flat")),
        MOZ_TRANSITION("MozTransition", "-moz-transition", BrowserConfiguration.ff("")),
        MOZ_TRANSITION_DELAY("MozTransitionDelay", "-moz-transition-delay", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_DURATION("MozTransitionDuration", "-moz-transition-duration", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_PROPERTY("MozTransitionProperty", "-moz-transition-property", BrowserConfiguration.ff("all")),
        MOZ_TRANSITION_TIMING_FUNCTION("MozTransitionTimingFunction", "-moz-transition-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_USER_FOCUS("MozUserFocus", "-moz-user-focus", BrowserConfiguration.ff("none")),
        MOZ_USER_INPUT("MozUserInput", "-moz-user-input", BrowserConfiguration.ff("auto")),
        MOZ_USER_MODIFY("MozUserModify", "-moz-user-modify", BrowserConfiguration.ff("read-only")),
        MOZ_USER_SELECT("MozUserSelect", "-moz-user-select", BrowserConfiguration.ff("auto")),
        MOZ_WINDOW_DRAGGING("MozWindowDragging", "-moz-window-dragging", BrowserConfiguration.ff38up("no-drag")),
        MOZ_WINDOW_SHADOW("MozWindowShadow", "-moz-window-shadow", BrowserConfiguration.ff("default")),
        MS_ANIMATION("msAnimation", "-ms-animation", BrowserConfiguration.ie11up("")),
        MS_ANIMATION_DELAY("msAnimationDelay", "-ms-animation-delay", BrowserConfiguration.ie11up("0s")),
        MS_ANIMATION_DIRECTION("msAnimationDirection", "-ms-animation-direction", BrowserConfiguration.ie11up("normal")),
        MS_ANIMATION_DURATION("msAnimationDuration", "-ms-animation-duration", BrowserConfiguration.ie11up("0s")),
        MS_ANIMATION_FILL_MODE("msAnimationFillMode", "-ms-animation-fill-mode", BrowserConfiguration.ie11up("none")),
        MS_ANIMATION_ITERATION_COUNT("msAnimationIterationCount", "-ms-animation-iteration-count", BrowserConfiguration.ie11up("1")),
        MS_ANIMATION_NAME("msAnimationName", "-ms-annimation-name", BrowserConfiguration.ie11up("none")),
        MS_ANIMATION_PLAY_STATE("msAnimationPlayState", "-ms-animation-play-state", BrowserConfiguration.ie11up("running")),
        MS_ANIMATION_TIMING_FUNCTION("msAnimationTimingFunction", "-ms-animation-timing-function", BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_BACKFACE_VISIBILITY("msBackfaceVisibility", "-ms-backface-visibility", BrowserConfiguration.ie11up("visible")),
        MS_BLOCK_PROGRESSION("msBlockProgression", "-ms-block-progression", BrowserConfiguration.ie11up("undefined")),
        MS_CONTENT_ZOOM_CHAINING("msContentZoomChaining", "-ms-content-zoom-chaining", BrowserConfiguration.ie11up("none")),
        MS_CONTENT_ZOOM_LIMIT("msContentZoomLimit", "-ms-content-zoom-limit", BrowserConfiguration.ie11up("")),
        MS_CONTENT_ZOOM_LIMIT_MAX("msContentZoomLimitMax", "-ms-content-zoom-limit-max", BrowserConfiguration.ie11up("400%")),
        MS_CONTENT_ZOOM_LIMIT_MIN("msContentZoomLimitMin", "-ms-content-zoom-limit-min", BrowserConfiguration.ie11up("100%")),
        MS_CONTENT_ZOOM_SNAP("msContentZoomSnap", "-ms-content-zoom-snap", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_POINTS("msContentZoomSnapPoints", "-ms-content-zoom-snap-points", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_TYPE("msContentZoomSnapType", "-ms-content-zoom-snap-type", BrowserConfiguration.ie11up("none")),
        MS_CONTENT_ZOOMING("msContentZooming", "-ms-content-zooming", BrowserConfiguration.ie11up("none")),
        MS_FLEX("msFlex", "-ms-flex", BrowserConfiguration.ie11up("0 1 auto")),
        MS_FLEX_ALIGN("msFlexAlign", "-ms-flex-align", BrowserConfiguration.ie11up("stretch")),
        MS_FLEX_DIRECTION("msFlexDirection", "-ms-flex-direction", BrowserConfiguration.ie11up("row")),
        MS_FLEX_FLOW("msFlexFlow", "-ms-flex-flow", BrowserConfiguration.ie11up("row nowrap")),
        MS_FLEX_ITEM_ALIGN("msFlexItemAlign", "-ms-flex-item-align", BrowserConfiguration.ie11up("auto")),
        MS_FLEX_LINE_PACK("msFlexLinePack", "-ms-flex-line-pack", BrowserConfiguration.ie11up("stretch")),
        MS_FLEX_NEGATIVE("msFlexNegative", "-ms-flex-negative", BrowserConfiguration.ie11up("1")),
        MS_FLEX_ORDER("msFlexOrder", "-ms-flex-order", BrowserConfiguration.ie11up("0")),
        MS_FLEX_PACK("msFlexPack", "-ms-flex-pack", BrowserConfiguration.ie11up("start")),
        MS_FLEX_POSITIVE("msFlexPositive", "-ms-flex-positive", BrowserConfiguration.ie11up("0")),
        MS_FLEX_PREFERRED_SIZE("msFlexPreferredSize", "-ms-flex-preferred-size", BrowserConfiguration.ie11up("auto")),
        MS_FLEX_WRAP("msFlexWrap", "-ms-flex-wrap", BrowserConfiguration.ie11up("nowrap")),
        MS_FLOW_FROM("msFlowFrom", "-ms-flow-from", BrowserConfiguration.ie11up("none")),
        MS_FLOW_INTO("msFlowInto", "-ms-flow-into", BrowserConfiguration.ie11up("none")),
        MS_FONT_FEATURE_SETTINGS("msFontFeatureSettings", "-ms-font-feature-settings", BrowserConfiguration.ie11up("normal")),
        MS_GRID_COLUMN("msGridColumn", "-ms-grid-column", BrowserConfiguration.ie11up("1")),
        MS_GRID_COLUMN_ALIGN("msGridColumnAlign", "-ms-grid-column-align", BrowserConfiguration.ie11up("stretch")),
        MS_GRID_COLUMN_SPAN("msGridColumnSpan", "-ms-grid-column-span", BrowserConfiguration.ie11up("1")),
        MS_GRID_COLUMNS("msGridColumns", "-ms-grid-columns", BrowserConfiguration.ie11up("none")),
        MS_GRID_ROW("msGridRow", "-ms-grid-row", BrowserConfiguration.ie11up("1")),
        MS_GRID_ROW_ALIGN("msGridRowAlign", "-ms-grid-row-align", BrowserConfiguration.ie11up("stretch")),
        MS_GRID_ROW_SPAN("msGridRowSpan", "-ms-grid-row-span", BrowserConfiguration.ie11up("1")),
        MS_GRID_ROWS("msGridRows", "-ms-grid-rows", BrowserConfiguration.ie11up("none")),
        MS_HIGH_CONTRAST_ADJUST("msHighContrastAdjust", "-ms-high-contrast-adjust", BrowserConfiguration.ie11up("auto")),
        MS_HYPHENATE_LIMIT_CHARS("msHyphenateLimitChars", "-ms-hyphenate-limit-chars", BrowserConfiguration.ie11up("5 2 2")),
        MS_HYPHENATE_LIMIT_LINES("msHyphenateLimitLines", "-ms-hyphenate-limit-lines", BrowserConfiguration.ie11up("no-limit")),
        MS_HYPHENATE_LIMIT_ZONE("msHyphenateLimitZone", "-ms-hyphenate-limit-zone", BrowserConfiguration.ie11up("0px")),
        MS_HYPHENS("msHyphens", "-ms-hyphens", BrowserConfiguration.ie11up("manual")),
        MS_IME_ALIGN("msImeAlign", "-ms-ime-align", BrowserConfiguration.ie11up("")),
        MS_INTERPOLATION_MODE("msInterpolationMode", "-ms-interpolation-mode", BrowserConfiguration.ie11up("undefined")),
        MS_OVERFLOW_STYLE("msOverflowStyle", "-ms-overflow-style", BrowserConfiguration.ie11up("scrollbar")),
        MS_PERSPECTIVE("msPerspective", "-ms-perspective", BrowserConfiguration.ie11up("none")),
        MS_PERSPECTIVE_ORIGIN("msPerspectiveOrigin", "-ms-perspective-origin", BrowserConfiguration.ie11up("620px 163.2px")),
        MS_SCROLL_CHAINING("msScrollChaining", "-ms-scroll-chaining", BrowserConfiguration.ie11up("chained")),
        MS_SCROLL_LIMIT("msScrollLimit", "-ms-scroll-limit", BrowserConfiguration.ie11up("")),
        MS_SCROLL_LIMIT_X_MAX("msScrollLimitXMax", "-ms-scroll-limit-x-max", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_X_MIN("msScrollLimitXMin", "-ms-scroll-limit-x-min", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_Y_MAX("msScrollLimitYMax", "-ms-scroll-limit-y-max", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_Y_MIN("msScrollLimitYMin", "-ms-scroll-limit-y-min", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_RAILS("msScrollRails", "-ms-scroll-rails", BrowserConfiguration.ie11up("railed")),
        MS_SCROLL_SNAP_POINTS_X("msScrollSnapPointsX", "-ms-scroll-snap-points-x", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_POINTS_Y("msScrollSnapPointsY", "-ms-scroll-snap-points-y", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_TYPE("msScrollSnapType", "-ms-scroll-snap-type", BrowserConfiguration.ie11up("none")),
        MS_SCROLL_SNAP_X("msScrollSnapX", "-ms-scroll-snap-x", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_Y("msScrollSnapY", "-ms-scroll-snap-y", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_SCROLL_TRANSLATION("msScrollTranslation", "-ms-scroll-translation", BrowserConfiguration.ie11up("none")),
        MS_TEXT_COMBINE_HORIZONTAL("msTextCombineHorizontal", "-ms-text-combine-horizontal", BrowserConfiguration.ie11up("none")),
        MS_TOUCH_ACTION("msTouchAction", "-ms-touch-action", BrowserConfiguration.ie11up("auto")),
        MS_TOUCH_SELECT("msTouchSelect", "-ms-touch-select", BrowserConfiguration.ie11up("")),
        MS_TRANSFORM("msTransform", "-ms-transform", BrowserConfiguration.ie11up("none")),
        MS_TRANSFORM_ORIGIN("msTransformOrigin", "-ms-transform-origin", BrowserConfiguration.ie11up("620px 163.2px")),
        MS_TRANSFORM_STYLE("msTransformStyle", "-ms-transform-style", BrowserConfiguration.ie11up("flat")),
        MS_TRANSITION("msTransition", "-ms-transition", BrowserConfiguration.ie11up("")),
        MS_TRANSITION_DELAY("msTransitionDelay", "-ms-transition-delay", BrowserConfiguration.ie11up("0s")),
        MS_TRANSITION_DURATION("msTransitionDuration", "-ms-transition-duration", BrowserConfiguration.ie11up("0s")),
        MS_TRANSITION_PROPERTY("msTransitionProperty", "-ms-transition-property", BrowserConfiguration.ie11up("all")),
        MS_TRANSITION_TIMING_FUNCTION("msTransitionTimingFunction", "-ms-transition-timing-function", BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_USER_SELECT("msUserSelect", "-ms-user-select", BrowserConfiguration.ie11up("text")),
        MS_WRAP_FLOW("msWrapFlow", "-ms-wrap-flow", BrowserConfiguration.ie11up("auto")),
        MS_WRAP_MARGIN("msWrapMargin", "-ms-wrap-margin", BrowserConfiguration.ie11up("auto")),
        MS_WRAP_THROUGH("msWrapThrough", "-ms-wrap-through", BrowserConfiguration.ie11up("wrap")),
        OBJECT_FIT("objectFit", "object-fit", BrowserConfiguration.ff38up("fill"), BrowserConfiguration.chrome("fill")),
        OBJECT_FIT_("object-fit", "object-fit", BrowserConfiguration.ff38up("fill")),
        OBJECT_POSITION("objectPosition", "object-position", BrowserConfiguration.ff38up("50% 50%"), BrowserConfiguration.chrome("50% 50%")),
        OBJECT_POSITION_("object-position", "object-position", BrowserConfiguration.ff38up("50% 50%")),
        OPACITY("opacity", "opacity", BrowserConfiguration.chrome("1")),
        ORDER("order", "order", BrowserConfiguration.ff("0"), BrowserConfiguration.ie11up("0"), BrowserConfiguration.chrome("0")),
        ORIENTATION("orientation", "orientation", BrowserConfiguration.chrome("")),
        ORPHANS("orphans", "orphans", BrowserConfiguration.ie11up("2"), BrowserConfiguration.chrome("auto")),
        OUTLINE("outline", "outline", BrowserConfiguration.chrome("rgb(0, 0, 0) none 0px")),
        OUTLINE_COLOR("outlineColor", "outline-color", BrowserConfiguration.ie11up("transparent"), BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)")),
        OUTLINE_COLOR_("outline-color", "outline-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        OUTLINE_OFFSET("outlineOffset", "outline-offset", BrowserConfiguration.chrome("0px")),
        OUTLINE_OFFSET_("outline-offset", "outline-offset", BrowserConfiguration.ff38up("0px")),
        OUTLINE_STYLE("outlineStyle", "outline-style", BrowserConfiguration.chrome("none")),
        OUTLINE_STYLE_("outline-style", "outline-style", BrowserConfiguration.ff38up("none")),
        OUTLINE_WIDTH("outlineWidth", "outline-width", BrowserConfiguration.chrome("0px")),
        OUTLINE_WIDTH_("outline-width", "outline-width", BrowserConfiguration.ff38up("0px")),
        OVERFLOW("overflow", "overflow", BrowserConfiguration.chrome("visible")),
        OVERFLOW_WRAP("overflowWrap", "overflow-wrap", BrowserConfiguration.chrome("normal")),
        OVERFLOW_X("overflowX", "overflow-x", BrowserConfiguration.chrome("visible")),
        OVERFLOW_X_("overflow-x", "overflow-x", BrowserConfiguration.ff38up("visible")),
        OVERFLOW_Y("overflowY", "overflow-y", BrowserConfiguration.chrome("visible")),
        OVERFLOW_Y_("overflow-y", "overflow-y", BrowserConfiguration.ff38up("visible")),
        PADDING("padding", "padding", BrowserConfiguration.chrome("0px")),
        PADDING_BOTTOM("paddingBottom", "padding-bottom", BrowserConfiguration.chrome("0px")),
        PADDING_BOTTOM_("padding-bottom", "padding-bottom", BrowserConfiguration.ff38up("0px")),
        PADDING_LEFT("paddingLeft", "padding-left", BrowserConfiguration.chrome("0px")),
        PADDING_LEFT_("padding-left", "padding-left", BrowserConfiguration.ff38up("0px")),
        PADDING_RIGHT("paddingRight", "padding-right", BrowserConfiguration.chrome("0px")),
        PADDING_RIGHT_("padding-right", "padding-right", BrowserConfiguration.ff38up("0px")),
        PADDING_TOP("paddingTop", "padding-top", BrowserConfiguration.chrome("0px")),
        PADDING_TOP_("padding-top", "padding-top", BrowserConfiguration.ff38up("0px")),
        PAGE("page", "page", BrowserConfiguration.chrome("")),
        PAGE_BREAK_AFTER("pageBreakAfter", "page-break-after", BrowserConfiguration.chrome("auto")),
        PAGE_BREAK_AFTER_("page-break-after", "page-break-after", BrowserConfiguration.ff38up("auto")),
        PAGE_BREAK_BEFORE("pageBreakBefore", "page-break-before", BrowserConfiguration.chrome("auto")),
        PAGE_BREAK_BEFORE_("page-break-before", "page-break-before", BrowserConfiguration.ff38up("auto")),
        PAGE_BREAK_INSIDE("pageBreakInside", "page-break-inside", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        PAGE_BREAK_INSIDE_("page-break-inside", "page-break-inside", BrowserConfiguration.ff38up("auto")),
        PAINT_ORDER("paintOrder", "paint-order", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("fill stroke markers")),
        PAINT_ORDER_("paint-order", "paint-order", BrowserConfiguration.ff38up("normal")),
        PAUSE("pause", "pause", new BrowserConfiguration[0]),
        PAUSE_AFTER("pauseAfter", "pause-after", new BrowserConfiguration[0]),
        PAUSE_BEFORE("pauseBefore", "pause-before", new BrowserConfiguration[0]),
        PERSPECTIVE("perspective", "perspective", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        PERSPECTIVE_ORIGIN("perspectiveOrigin", "perspective-origin", BrowserConfiguration.ff("621px 172.5px"), BrowserConfiguration.ie11up("620px 163.2px"), BrowserConfiguration.chrome("620px 161px")),
        PERSPECTIVE_ORIGIN_("perspective-origin", "perspective-origin", BrowserConfiguration.ff38up("621px 172.5px")),
        PITCH("pitch", "pitch", new BrowserConfiguration[0]),
        PITCH_RANGE("pitchRange", "pitch-range", new BrowserConfiguration[0]),
        POINTER_EVENTS("pointerEvents", "pointer-events", BrowserConfiguration.ie11up("visiblePainted"), BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        POINTER_EVENTS_("pointer-events", "pointer-events", BrowserConfiguration.ff38up("auto")),
        POSITION("position", "position", BrowserConfiguration.chrome("static")),
        QUOTES("quotes", "quotes", BrowserConfiguration.ff("\"\u201c\" \"\u201d\" \"\u2018\" \"\u2019\""), BrowserConfiguration.ie8up(""), BrowserConfiguration.chrome("")),
        R("r", "r", BrowserConfiguration.chrome("0px")),
        RESIZE("resize", "resize", BrowserConfiguration.ff("none"), BrowserConfiguration.chrome("none")),
        RICHNESS("richness", "richness", new BrowserConfiguration[0]),
        RIGHT("right", "right", BrowserConfiguration.chrome("auto")),
        RUBY_ALIGN("rubyAlign", "ruby-align", BrowserConfiguration.ff38up("space-around")),
        RUBY_ALIGN_("ruby-align", "ruby-align", BrowserConfiguration.ff38up("space-around")),
        RUBY_OVERHANG("rubyOverhang", "ruby-overhang", BrowserConfiguration.ie11up("auto")),
        RUBY_POSITION("rubyPosition", "ruby-position", BrowserConfiguration.ie11up("above"), BrowserConfiguration.ff38up("over")),
        RUBY_POSITION_("ruby-position", "ruby-position", BrowserConfiguration.ff38up("over")),
        RX("rx", "rx", BrowserConfiguration.chrome("0px")),
        RY("ry", "ry", BrowserConfiguration.chrome("0px")),
        SCROLL_BEHAVIOR("scrollBehavior", "scroll-behavior", BrowserConfiguration.ff38up("auto")),
        SCROLL_BEHAVIOR_("scroll-behavior", "scroll-behavior", BrowserConfiguration.ff38up("auto")),
        SCROLLBAR_3DLIGHT_COLOR("scrollbar3dLightColor", "scrollbar-3dlight-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_ARROW_COLOR("scrollbarArrowColor", "scrollbar-arrow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_BASE_COLOR("scrollbarBaseColor", "scrollbar-base-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_DARKSHADOW_COLOR("scrollbarDarkShadowColor", "scrollbar-darkshadow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_FACE_COLOR("scrollbarFaceColor", "scrollbar-face-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_HIGHLIGHT_COLOR("scrollbarHighlightColor", "scrollbar-highlight-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_SHADOW_COLOR("scrollbarShadowColor", "scrollbar-shadow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_TRACK_COLOR("scrollbarTrackColor", "scrollbar-track-color", BrowserConfiguration.ie11up("undefined")),
        SHAPE_IMAGE_THRESHOLD("shapeImageThreshold", "shape-image-threshold", BrowserConfiguration.chrome("0")),
        SHAPE_MARGIN("shapeMargin", "shape-margin", BrowserConfiguration.chrome("0px")),
        SHAPE_OUTSIDE("shapeOutside", "shape-outside", BrowserConfiguration.chrome("none")),
        SHAPE_RENDERING("shapeRendering", "shape-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        SHAPE_RENDERING_("shape-rendering", "shape-rendering", BrowserConfiguration.ff38up("auto")),
        SIZE("size", "size", BrowserConfiguration.chrome("")),
        SPEAK("speak", "speak", BrowserConfiguration.chrome("normal")),
        SPEAK_HEADER("speakHeader", "speak-header", new BrowserConfiguration[0]),
        SPEAK_NUMERAL("speakNumeral", "speak-numeral", new BrowserConfiguration[0]),
        SPEAK_PUNCTUATION("speakPunctuation", "speak-punctuation", new BrowserConfiguration[0]),
        SPEECH_RATE("speechRate", "speech-rate", new BrowserConfiguration[0]),
        SRC("src", "src", BrowserConfiguration.chrome("")),
        STOP_COLOR("stopColor", "stop-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        STOP_COLOR_("stop-color", "stop-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        STOP_OPACITY("stopOpacity", "stop-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        STOP_OPACITY_("stop-opacity", "stop-opacity", BrowserConfiguration.ff38up("1")),
        STRESS("stress", "stress", new BrowserConfiguration[0]),
        STROKE("stroke", "stroke", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("none")),
        STROKE_DASHARRAY("strokeDasharray", "stroke-dasharray", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        STROKE_DASHARRAY_("stroke-dasharray", "stroke-dasharray", BrowserConfiguration.ff38up("none")),
        STROKE_DASHOFFSET("strokeDashoffset", "stroke-dashoffset", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px"), BrowserConfiguration.chrome("0px")),
        STROKE_DASHOFFSET_("stroke-dashoffset", "stroke-dashoffset", BrowserConfiguration.ff38up("0px")),
        STROKE_LINECAP("strokeLinecap", "stroke-linecap", BrowserConfiguration.ff("butt"), BrowserConfiguration.ie11up("butt"), BrowserConfiguration.chrome("butt")),
        STROKE_LINECAP_("stroke-linecap", "stroke-linecap", BrowserConfiguration.ff38up("butt")),
        STROKE_LINEJOIN("strokeLinejoin", "stroke-linejoin", BrowserConfiguration.ff("miter"), BrowserConfiguration.ie11up("miter"), BrowserConfiguration.chrome("miter")),
        STROKE_LINEJOIN_("stroke-linejoin", "stroke-linejoin", BrowserConfiguration.ff38up("miter")),
        STROKE_MITERLIMIT("strokeMiterlimit", "stroke-miterlimit", BrowserConfiguration.ff("4"), BrowserConfiguration.ie11up("4"), BrowserConfiguration.chrome("4")),
        STROKE_MITERLIMIT_("stroke-miterlimit", "stroke-miterlimit", BrowserConfiguration.ff38up("4")),
        STROKE_OPACITY("strokeOpacity", "stroke-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1"), BrowserConfiguration.chrome("1")),
        STROKE_OPACITY_("stroke-opacity", "stroke-opacity", BrowserConfiguration.ff38up("1")),
        STROKE_WIDTH("strokeWidth", "stroke-width", BrowserConfiguration.ff("1px"), BrowserConfiguration.ie11up("0.01px"), BrowserConfiguration.chrome("1px")),
        STROKE_WIDTH_("stroke-width", "stroke-width", BrowserConfiguration.ff38up("1px")),
        STYLE_FLOAT("styleFloat", "style-float", BrowserConfiguration.ie11up("undefined")),
        TAB_SIZE("tabSize", "tab-size", BrowserConfiguration.chrome("8")),
        TABLE_LAYOUT("tableLayout", "table-layout", BrowserConfiguration.chrome("auto")),
        TABLE_LAYOUT_("table-layout", "table-layout", BrowserConfiguration.ff38up("auto")),
        TEXT_ALIGN("textAlign", "text-align", BrowserConfiguration.ie11up("left"), BrowserConfiguration.chrome("start"), BrowserConfiguration.ff("start")),
        TEXT_ALIGN_("text-align", "text-align", BrowserConfiguration.ff38up("start")),
        TEXT_ALIGN_LAST("textAlignLast", "text-align-last", BrowserConfiguration.ie11up("auto")),
        TEXT_ANCHOR("textAnchor", "text-anchor", BrowserConfiguration.ff("start"), BrowserConfiguration.ie11up("start"), BrowserConfiguration.chrome("start")),
        TEXT_ANCHOR_("text-anchor", "text-anchor", BrowserConfiguration.ff38up("start")),
        TEXT_AUTOSPACE("textAutospace", "text-autospace", BrowserConfiguration.ie11up("undefined")),
        TEXT_DECORATION("textDecoration", "text-decoration", BrowserConfiguration.chrome("none")),
        TEXT_DECORATION_("text-decoration", "text-decoration", BrowserConfiguration.ff38up("none")),
        TEXT_DECORATION_COLOR("textDecorationColor", "text-decoration-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        TEXT_DECORATION_COLOR_("text-decoration-color", "text-decoration-color", BrowserConfiguration.ff38up("rgb(0, 0, 0)")),
        TEXT_DECORATION_LINE("textDecorationLine", "text-decoration-line", BrowserConfiguration.ff38up("none")),
        TEXT_DECORATION_LINE_("text-decoration-line", "text-decoration-line", BrowserConfiguration.ff38up("none")),
        TEXT_DECORATION_STYLE("textDecorationStyle", "text-decoration-style", BrowserConfiguration.ff38up("solid")),
        TEXT_DECORATION_STYLE_("text-decoration-style", "text-decoration-style", BrowserConfiguration.ff38up("solid")),
        TEXT_INDENT("textIndent", "text-indent", BrowserConfiguration.chrome("0px")),
        TEXT_INDENT_("text-indent", "text-indent", BrowserConfiguration.ff38up("0px")),
        TEXT_JUSTIFY("textJustify", "text-justify", BrowserConfiguration.ie11up("auto")),
        TEXT_JUSTIFY_TRIM("textJustifyTrim", "text-justify-trim", BrowserConfiguration.ie11up("undefined")),
        TEXT_KASHIDA("textKashida", "text-kashida", BrowserConfiguration.ie11up("undefined")),
        TEXT_KASHIDA_SPACE("textKashidaSpace", "text-kashida-space", BrowserConfiguration.ie11up("undefined")),
        TEXT_OVERFLOW("textOverflow", "text-overflow", BrowserConfiguration.ff("clip"), BrowserConfiguration.ie11up("clip"), BrowserConfiguration.chrome("clip")),
        TEXT_OVERFLOW_("text-overflow", "text-overflow", BrowserConfiguration.ff38up("clip")),
        TEXT_RENDERING("textRendering", "text-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        TEXT_RENDERING_("text-rendering", "text-rendering", BrowserConfiguration.ff38up("auto")),
        TEXT_SHADOW("textShadow", "text-shadow", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        TEXT_SHADOW_("text-shadow", "text-shadow", BrowserConfiguration.ff38up("none")),
        TEXT_TRANSFORM("textTransform", "text-transform", BrowserConfiguration.chrome("none")),
        TEXT_TRANSFORM_("text-transform", "text-transform", BrowserConfiguration.ff38up("none")),
        TEXT_UNDERLINE_POSITION("textUnderlinePosition", "text-underline-position", BrowserConfiguration.ie11up("auto")),
        TOP("top", "top", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        TOUCH_ACTION("touchAction", "touch-action", BrowserConfiguration.ie11up("auto"), BrowserConfiguration.chrome("auto")),
        TRANSFORM("transform", "transform", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none"), BrowserConfiguration.chrome("none")),
        TRANSFORM_ORIGIN("transformOrigin", "transform-origin", BrowserConfiguration.ff("621px 172.5px"), BrowserConfiguration.ie11up("620px 163.2px"), BrowserConfiguration.chrome("620px 161px")),
        TRANSFORM_ORIGIN_("transform-origin", "transform-origin", BrowserConfiguration.ff38up("621px 172.5px")),
        TRANSFORM_STYLE("transformStyle", "transform-style", BrowserConfiguration.ff("flat"), BrowserConfiguration.ie11up("flat"), BrowserConfiguration.chrome("flat")),
        TRANSFORM_STYLE_("transform-style", "transform-style", BrowserConfiguration.ff38up("flat")),
        TRANSITION("transition", "transition", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("all 0s ease 0s")),
        TRANSITION_DELAY("transitionDelay", "transition-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s"), BrowserConfiguration.chrome("0s")),
        TRANSITION_DELAY_("transition-delay", "transition-delay", BrowserConfiguration.ff38up("0s")),
        TRANSITION_DURATION("transitionDuration", "transition-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s"), BrowserConfiguration.chrome("0s")),
        TRANSITION_DURATION_("transition-duration", "transition-duration", BrowserConfiguration.ff38up("0s")),
        TRANSITION_PROPERTY("transitionProperty", "transition-property", BrowserConfiguration.ff("all"), BrowserConfiguration.ie11up("all"), BrowserConfiguration.chrome("all")),
        TRANSITION_PROPERTY_("transition-property", "transition-property", BrowserConfiguration.ff38up("all")),
        TRANSITION_TIMING_FUNCTION("transitionTimingFunction", "transition-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.chrome("ease")),
        TRANSITION_TIMING_FUNCTION_("transition-timing-function", "transition-timing-function", BrowserConfiguration.ff38up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        UNICODE_BIDI("unicodeBidi", "unicode-bidi", BrowserConfiguration.ff("-moz-isolate"), BrowserConfiguration.ieBelow11("embed"), BrowserConfiguration.ie11up("normal"), BrowserConfiguration.chrome("normal")),
        UNICODE_BIDI_("unicode-bidi", "unicode-bidi", BrowserConfiguration.ff38up("-moz-isolate")),
        UNICODE_RANGE("unicodeRange", "unicode-range", BrowserConfiguration.chrome("")),
        USER_ZOOM("userZoom", "user-zoom", BrowserConfiguration.chrome("")),
        VECTOR_EFFECT("vectorEffect", "vector-effect", BrowserConfiguration.ff("none"), BrowserConfiguration.chrome("none")),
        VECTOR_EFFECT_("vector-effect", "vector-effect", BrowserConfiguration.ff38up("none")),
        VERTICAL_ALIGN("verticalAlign", "vertical-align", BrowserConfiguration.chrome("baseline")),
        VERTICAL_ALIGN_("vertical-align", "vertical-align", BrowserConfiguration.ff38up("baseline")),
        VISIBILITY("visibility", "visibility", BrowserConfiguration.chrome("visible")),
        VOICE_FAMILY("voiceFamily", "voice-family", new BrowserConfiguration[0]),
        VOLUME("volume", "volume", new BrowserConfiguration[0]),
        WEBKIT_APP_REGION("webkitAppRegion", "webkit-app-region", BrowserConfiguration.chrome("no-drag")),
        WEBKIT_APPEARANCE("webkitAppearance", "webkit-appearance", BrowserConfiguration.chrome("none")),
        WEBKIT_BACKGROUND_CLIP("webkitBackgroundClip", "webkit-background-clip", BrowserConfiguration.chrome("border-box")),
        WEBKIT_BACKGROUND_COMPOSITE("webkitBackgroundComposite", "webkit-background-composite", BrowserConfiguration.chrome("source-over")),
        WEBKIT_BACKGROUND_ORIGIN("webkitBackgroundOrigin", "webkit-background-origin", BrowserConfiguration.chrome("padding-box")),
        WEBKIT_BORDER_AFTER("webkitBorderAfter", "webkit-border-after", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_AFTER_COLOR("webkitBorderAfterColor", "webkit-border-after-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_AFTER_STYLE("webkitBorderAfterStyle", "webkit-border-after-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_AFTER_WIDTH("webkitBorderAfterWidth", "webkit-border-after-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_BEFORE("webkitBorderBefore", "webkit-border-before", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_BEFORE_COLOR("webkitBorderBeforeColor", "webkit-border-before-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_BEFORE_STYLE("webkitBorderBeforeStyle", "webkit-border-before-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_BEFORE_WIDTH("webkitBorderBeforeWidth", "webkit-border-before-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_END("webkitBorderEnd", "webkit-border-end", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_END_COLOR("webkitBorderEndColor", "webkit-border-end-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_END_STYLE("webkitBorderEndStyle", "webkit-border-end-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_END_WIDTH("webkitBorderEndWidth", "webkit-border-end-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_HORIZONTAL_SPACING("webkitBorderHorizontalSpacing", "webkit-border-horizontal-spacing", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_IMAGE("webkitBorderImage", "webkit-border-image", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_START("webkitBorderStart", "webkit-border-start", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_START_COLOR("webkitBorderStartColor", "webkit-border-start-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_START_STYLE("webkitBorderStartStyle", "webkit-border-start-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_START_WIDTH("webkitBorderStartWidth", "webkit-border-start-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_VERTICAL_SPACING("webkitBorderVerticalSpacing", "webkit-border-vertical-spacing", BrowserConfiguration.chrome("0px")),
        WEBKIT_BOX_ALIGN("webkitBoxAlign", "webkit-box-align", BrowserConfiguration.chrome("stretch")),
        WEBKIT_BOX_DECORATION_BREAK("webkitBoxDecorationBreak", "webkit-box-decoration-break", BrowserConfiguration.chrome("slice")),
        WEBKIT_BOX_DIRECTION("webkitBoxDirection", "webkit-box-direction", BrowserConfiguration.chrome("normal")),
        WEBKIT_BOX_FLEX("webkitBoxFlex", "webkit-box-flex", BrowserConfiguration.chrome("0")),
        WEBKIT_BOX_FLEX_GROUP("webkitBoxFlexGroup", "webkit-box-flex-group", BrowserConfiguration.chrome("1")),
        WEBKIT_BOX_LINES("webkitBoxLines", "webkit-box-lines", BrowserConfiguration.chrome("single")),
        WEBKIT_BOX_ORDINAL_GROUP("webkitBoxOrdinalGroup", "webkit-box-ordinal-group", BrowserConfiguration.chrome("1")),
        WEBKIT_BOX_ORIENT("webkitBoxOrient", "webkit-box-orient", BrowserConfiguration.chrome("horizontal")),
        WEBKIT_BOX_PACK("webkitBoxPack", "webkit-box-pack", BrowserConfiguration.chrome("start")),
        WEBKIT_BOX_REFLECT("webkitBoxReflect", "webkit-box-reflect", BrowserConfiguration.chrome("none")),
        WEBKIT_CLIP_PATH("webkitClipPath", "webkit-clip-path", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_BREAK_AFTER("webkitColumnBreakAfter", "webkit-column-break-after", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_BREAK_BEFORE("webkitColumnBreakBefore", "webkit-column-break-before", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_BREAK_INSIDE("webkitColumnBreakInside", "webkit-column-break-inside", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_COUNT("webkitColumnCount", "webkit-column-count", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_GAP("webkitColumnGap", "webkit-column-gap", BrowserConfiguration.chrome("normal")),
        WEBKIT_COLUMN_RULE("webkitColumnRule", "webkit-column-rule", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_COLUMN_RULE_COLOR("webkitColumnRuleColor", "webkit-column-rule-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_COLUMN_RULE_STYLE("webkitColumnRuleStyle", "webkit-column-rule-style", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_RULE_WIDTH("webkitColumnRuleWidth", "webkit-column-rule-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_COLUMN_SPAN("webkitColumnSpan", "webkit-column-span", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_WIDTH("webkitColumnWidth", "webkit-column-width", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMNS("webkitColumns", "webkit-columns", BrowserConfiguration.chrome("auto auto")),
        WEBKIT_FILTER("webkitFilter", "webkit-filter", BrowserConfiguration.chrome("none")),
        WEBKIT_FONT_FEATURE_SETTINGS("webkitFontFeatureSettings", "webkit-font-feature-settings", BrowserConfiguration.chrome("normal")),
        WEBKIT_FONT_SIZE_DELTA("webkitFontSizeDelta", "webkit-font-size-delta", BrowserConfiguration.chrome("")),
        WEBKIT_FONT_SMOOTHING("webkitFontSmoothing", "webkit-font-smoothing", BrowserConfiguration.chrome("auto")),
        WEBKIT_HIGHLIGHT("webkitHighlight", "webkit-highlight", BrowserConfiguration.chrome("none")),
        WEBKIT_HYPHENATE_CHARACTER("webkitHyphenateCharacter", "webkit-hyphenate-character", BrowserConfiguration.chrome("auto")),
        WEBKIT_LINE_BOX_CONTAIN("webkitLineBoxContain", "webkit-line-box-contain", BrowserConfiguration.chrome("block inline replaced")),
        WEBKIT_LINE_BREAK("webkitLineBreak", "webkit-line-break", BrowserConfiguration.chrome("auto")),
        WEBKIT_LINE_CLAMP("webkitLineClamp", "webkit-line-clamp", BrowserConfiguration.chrome("none")),
        WEBKIT_LOCALE("webkitLocale", "webkit-locale", BrowserConfiguration.chrome("auto")),
        WEBKIT_LOGICAL_HEIGHT("webkitLogicalHeight", "webkit-logical-height", BrowserConfiguration.chrome("322px")),
        WEBKIT_LOGICAL_WIDTH("webkitLogicalWidth", "webkit-logical-width", BrowserConfiguration.chrome("1240px")),
        WEBKIT_MARGIN_AFTER("webkitMarginAfter", "webkit-margin-after", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_AFTER_COLLAPSE("webkitMarginAfterCollapse", "webkit-margin-after-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_BEFORE("webkitMarginBefore", "webkit-margin-before", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_BEFORE_COLLAPSE("webkitMarginBeforeCollapse", "webkit-margin-before-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_BOTTOM_COLLAPSE("webkitMarginBottomCollapse", "webkit-margin-bottom-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_COLLAPSE("webkitMarginCollapse", "webkit-margin-collapse", BrowserConfiguration.chrome("")),
        WEBKIT_MARGIN_END("webkitMarginEnd", "webkit-margin-end", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_START("webkitMarginStart", "webkit-margin-start", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_TOP_COLLAPSE("webkitMarginTopCollapse", "webkit-margin-top-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MASK("webkitMask", "webkit-mask", BrowserConfiguration.chrome("")),
        WEBKIT_MASK_BOX_IMAGE("webkitMaskBoxImage", "webkit-mask-box-image", BrowserConfiguration.chrome("none")),
        WEBKIT_MASK_BOX_IMAGE_OUTSET("webkitMaskBoxImageOutset", "webkit-mask-box-image-outset", BrowserConfiguration.chrome("0px")),
        WEBKIT_MASK_BOX_IMAGE_REPEAT("webkitMaskBoxImageRepeat", "webkit-mask-box-image-repeat", BrowserConfiguration.chrome("stretch")),
        WEBKIT_MASK_BOX_IMAGE_SLICE("webkitMaskBoxImageSlice", "webkit-mask-box-image-slice", BrowserConfiguration.chrome("0 fill")),
        WEBKIT_MASK_BOX_IMAGE_SOURCE("webkitMaskBoxImageSource", "webkit-mask-box-image-source", BrowserConfiguration.chrome("none")),
        WEBKIT_MASK_BOX_IMAGE_WIDTH("webkitMaskBoxImageWidth", "webkit-mask-box-image-width", BrowserConfiguration.chrome("auto")),
        WEBKIT_MASK_CLIP("webkitMaskClip", "webkit-mask-clip", BrowserConfiguration.chrome("border-box")),
        WEBKIT_MASK_COMPOSITE("webkitMaskComposite", "webkit-mask-composite", BrowserConfiguration.chrome("source-over")),
        WEBKIT_MASK_IMAGE("webkitMaskImage", "webkit-mask-image", BrowserConfiguration.chrome("none")),
        WEBKIT_MASK_ORIGIN("webkitMaskOrigin", "webkit-mask-origin", BrowserConfiguration.chrome("border-box")),
        WEBKIT_MASK_POSITION("webkitMaskPosition", "webkit-mask-position", BrowserConfiguration.chrome("0% 0%")),
        WEBKIT_MASK_POSITION_X("webkitMaskPositionX", "webkit-mask-position-x", BrowserConfiguration.chrome("0%")),
        WEBKIT_MASK_POSITION_Y("webkitMaskPositionY", "webkit-mask-position-y", BrowserConfiguration.chrome("0%")),
        WEBKIT_MASK_REPEAT("webkitMaskRepeat", "webkit-mask-repeat", BrowserConfiguration.chrome("repeat")),
        WEBKIT_MASK_REPEAT_X("webkitMaskRepeatX", "webkit-mask-repeat-x", BrowserConfiguration.chrome("")),
        WEBKIT_MASK_REPEAT_Y("webkitMaskRepeatY", "webkit-mask-repeat-y", BrowserConfiguration.chrome("")),
        WEBKIT_MASK_SIZE("webkitMaskSize", "webkit-mask-size", BrowserConfiguration.chrome("auto")),
        WEBKIT_MAX_LOGICAL_HEIGHT("webkitMaxLogicalHeight", "webkit-max-logical-height", BrowserConfiguration.chrome("none")),
        WEBKIT_MAX_LOGICAL_WIDTH("webkitMaxLogicalWidth", "webkit-max-logical-width", BrowserConfiguration.chrome("none")),
        WEBKIT_MIN_LOGICAL_HEIGHT("webkitMinLogicalHeight", "webkit-min-logical-height", BrowserConfiguration.chrome("0px")),
        WEBKIT_MIN_LOGICAL_WIDTH("webkitMinLogicalWidth", "webkit-min-logical-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_AFTER("webkitPaddingAfter", "webkit-padding-after", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_BEFORE("webkitPaddingBefore", "webkit-padding-before", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_END("webkitPaddingEnd", "webkit-padding-end", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_START("webkitPaddingStart", "webkit-padding-start", BrowserConfiguration.chrome("0px")),
        WEBKIT_PERSPECTIVE_ORIGIN_X("webkitPerspectiveOriginX", "webkit-perspective-origin-x", BrowserConfiguration.chrome("")),
        WEBKIT_PERSPECTIVE_ORIGIN_Y("webkitPerspectiveOriginY", "webkit-perspective-origin-y", BrowserConfiguration.chrome("")),
        WEBKIT_PRINT_COLOR_ADJUST("webkitPrintColorAdjust", "webkit-print-color-adjust", BrowserConfiguration.chrome("economy")),
        WEBKIT_RTL_ORDERING("webkitRtlOrdering", "webkit-rtl-ordering", BrowserConfiguration.chrome("logical")),
        WEBKIT_RUBY_POSITION("webkitRubyPosition", "webkit-ruby-position", BrowserConfiguration.chrome("before")),
        WEBKIT_TAP_HIGHLIGHT_COLOR("webkitTapHighlightColor", "webkit-tap-highlight-color", BrowserConfiguration.chrome("rgba(0, 0, 0, 0.180392)")),
        WEBKIT_TEXT_COMBINE("webkitTextCombine", "webkit-text-combine", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_DECORATIONS_IN_EFFECT("webkitTextDecorationsInEffect", "webkit-text-decorations-in-effect", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_EMPHASIS("webkitTextEmphasis", "webkit-text-emphasis", BrowserConfiguration.chrome("")),
        WEBKIT_TEXT_EMPHASIS_COLOR("webkitTextEmphasisColor", "webkit-text-emphasis-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_TEXT_EMPHASIS_POSITION("webkitTextEmphasisPosition", "webkit-text-emphasis-position", BrowserConfiguration.chrome("over")),
        WEBKIT_TEXT_EMPHASIS_STYLE("webkitTextEmphasisStyle", "webkit-text-emphasis-style", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_FILL_COLOR("webkitTextFillColor", "webkit-text-fill-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_TEXT_ORIENTATION("webkitTextOrientation", "webkit-text-orientation", BrowserConfiguration.chrome("vertical-right")),
        WEBKIT_TEXT_SECURITY("webkitTextSecurity", "webkit-text-security", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_STROKE("webkitTextStroke", "webkit-text-stroke", BrowserConfiguration.chrome("")),
        WEBKIT_TEXT_STROKE_COLOR("webkitTextStrokeColor", "webkit-text-stroke-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_TEXT_STROKE_WIDTH("webkitTextStrokeWidth", "webkit-text-stroke-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_TRANSFORM_ORIGIN_X("webkitTransformOriginX", "webkit-transform-origin-x", BrowserConfiguration.chrome("")),
        WEBKIT_TRANSFORM_ORIGIN_Y("webkitTransformOriginY", "webkit-transform-origin-y", BrowserConfiguration.chrome("")),
        WEBKIT_TRANSFORM_ORIGIN_Z("webkitTransformOriginZ", "webkit-transform-origin-z", BrowserConfiguration.chrome("")),
        WEBKIT_USER_DRAG("webkitUserDrag", "webkit-user-drag", BrowserConfiguration.chrome("auto")),
        WEBKIT_USER_MODIFY("webkitUserModify", "webkit-user-modify", BrowserConfiguration.chrome("read-only")),
        WEBKIT_USER_SELECT("webkitUserSelect", "webkit-user-select", BrowserConfiguration.chrome("text")),
        WEBKIT_WRITING_MODE("webkitWritingMode", "webkit-writing-mode", BrowserConfiguration.chrome("horizontal-tb")),
        WHITE_SPACE("whiteSpace", "white-space", BrowserConfiguration.chrome("normal")),
        WHITE_SPACE_("white-space", "white-space", BrowserConfiguration.ff38up("normal")),
        WIDOWS("widows", "widows", BrowserConfiguration.ie11up("2"), BrowserConfiguration.chrome("1")),
        WIDTH("width", "width", BrowserConfiguration.chrome("skipped")),
        WILL_CHANGE("willChange", "will-change", BrowserConfiguration.ff38up("auto"), BrowserConfiguration.chrome("auto")),
        WILL_CHANGE_("will-change", "will-change", BrowserConfiguration.ff38up("auto")),
        WORD_BREAK("wordBreak", "word-break", BrowserConfiguration.ff("normal"), BrowserConfiguration.ieBelow11(""), BrowserConfiguration.ie11up("normal"), BrowserConfiguration.chrome("normal")),
        WORD_BREAK_("word-break", "word-break", BrowserConfiguration.ff38up("normal")),
        WORD_SPACING("wordSpacing", "word-spacing", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px")),
        WORD_SPACING_("word-spacing", "word-spacing", BrowserConfiguration.ff38up("0px")),
        WORD_WRAP("wordWrap", "word-wrap", BrowserConfiguration.ie11up(""), BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WORD_WRAP_("word-wrap", "word-wrap", BrowserConfiguration.ff38up("normal")),
        WRITING_MODE("writingMode", "writing-mode", BrowserConfiguration.ie11up("undefined"), BrowserConfiguration.chrome("lr-tb")),
        X("x", "x", BrowserConfiguration.chrome("0px")),
        Y("y", "y", BrowserConfiguration.chrome("0px")),
        Z_INDEX_("z-index", "z-index", BrowserConfiguration.ff38up("auto")),
        ZOOM("zoom", "zoom", BrowserConfiguration.ie11up("undefined"), BrowserConfiguration.chrome("1"));

        private final String propertyName_;
        private final String attributeName_;
        private final BrowserConfiguration[] browserConfigurations_;

        private Definition(String propertyName, String attributeName, BrowserConfiguration ... browserConfigurations) {
            this.propertyName_ = propertyName;
            this.attributeName_ = attributeName;
            this.browserConfigurations_ = browserConfigurations;
        }

        private boolean isAvailable(BrowserVersion browserVersion) {
            return BrowserConfiguration.isDefined(browserVersion, this.browserConfigurations_);
        }

        public String getPropertyName() {
            return this.propertyName_;
        }

        public String getAttributeName() {
            return this.attributeName_;
        }

        public String getDefaultComputedValue(BrowserVersion browserVersion) {
            BrowserConfiguration config = BrowserConfiguration.getMatchingConfiguration(browserVersion, this.browserConfigurations_);
            if (config == null) {
                return "";
            }
            return config.getDefaultValue();
        }
    }
}

