/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class MouseEvent
extends UIEvent {
    public static final String TYPE_CLICK = "click";
    public static final String TYPE_DBL_CLICK = "dblclick";
    public static final String TYPE_MOUSE_OVER = "mouseover";
    public static final String TYPE_MOUSE_MOVE = "mousemove";
    public static final String TYPE_MOUSE_OUT = "mouseout";
    public static final String TYPE_MOUSE_DOWN = "mousedown";
    public static final String TYPE_MOUSE_UP = "mouseup";
    public static final String TYPE_CONTEXT_MENU = "contextmenu";
    public static final int BUTTON_LEFT = 0;
    public static final int BUTTON_MIDDLE = 1;
    public static final int BUTTON_RIGHT = 2;
    private static final int[] buttonCodeToIE = new int[]{1, 4, 2};
    private Integer screenX_;
    private Integer screenY_;
    private Integer clientX_;
    private Integer clientY_;
    private int button_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public MouseEvent() {
        this.screenX_ = 0;
        this.screenY_ = 0;
        this.setDetail(1L);
    }

    public MouseEvent(DomNode domNode, String type, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        super(domNode, type);
        this.setShiftKey(shiftKey);
        this.setCtrlKey(ctrlKey);
        this.setAltKey(altKey);
        this.setMetaKey(false);
        if (button != 0 && button != 1 && button != 2) {
            throw new IllegalArgumentException("Invalid button code: " + button);
        }
        this.button_ = button;
        if (TYPE_DBL_CLICK.equals(type)) {
            this.setDetail(2L);
        } else {
            this.setDetail(1L);
        }
    }

    @JsxGetter
    public int getClientX() {
        if (this.clientX_ == null) {
            this.clientX_ = this.getScreenX();
        }
        return this.clientX_;
    }

    @JsxSetter
    public void setClientX(int value) {
        this.clientX_ = value;
    }

    @JsxGetter
    public int getScreenX() {
        if (this.screenX_ == null) {
            HTMLElement target = (HTMLElement)this.getTarget();
            this.screenX_ = target.getPosX() + 10;
        }
        return this.screenX_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getPageX() {
        return this.getScreenX();
    }

    @JsxGetter
    public int getClientY() {
        if (this.clientY_ == null) {
            this.clientY_ = this.getScreenY();
        }
        return this.clientY_;
    }

    @JsxSetter
    public void setClientY(int value) {
        this.clientY_ = value;
    }

    @JsxGetter
    public int getScreenY() {
        if (this.screenY_ == null) {
            HTMLElement target = (HTMLElement)this.getTarget();
            this.screenY_ = target.getPosY() + 10;
        }
        return this.screenY_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getPageY() {
        return this.getScreenY();
    }

    @JsxGetter
    public int getButton() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_MOUSERVENT_BUTTON_CODE_IE)) {
            if (this.getType().equals(TYPE_CONTEXT_MENU)) {
                return 0;
            }
            if (this.getType().equals(TYPE_CLICK)) {
                return this.button_;
            }
            return buttonCodeToIE[this.button_];
        }
        return this.button_;
    }

    @JsxSetter
    public void setButton(int value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_MOUSERVENT_BUTTON_CODE_IE) && !TYPE_CLICK.equals(this.getType())) {
            switch (value) {
                case 1: {
                    value = 0;
                    break;
                }
                case 4: {
                    value = 1;
                    break;
                }
                case 2: {
                    value = 2;
                    break;
                }
            }
        }
        this.button_ = value;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.CHROME)})
    public int getWhich() {
        return this.button_ + 1;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void initMouseEvent(String type, boolean bubbles, boolean cancelable, Object view, int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Object relatedTarget) {
        this.initUIEvent(type, bubbles, cancelable, view, detail);
        this.screenX_ = screenX;
        this.screenY_ = screenY;
        this.clientX_ = clientX;
        this.clientY_ = clientY;
        this.setCtrlKey(ctrlKey);
        this.setAltKey(altKey);
        this.setShiftKey(shiftKey);
        this.setMetaKey(metaKey);
        this.button_ = button;
    }

    public static MouseEvent getCurrentMouseEvent() {
        LinkedList events = (LinkedList)Context.getCurrentContext().getThreadLocal((Object)"Event#current");
        if (events != null && !events.isEmpty() && events.getLast() instanceof MouseEvent) {
            return (MouseEvent)events.getLast();
        }
        return null;
    }

    public static boolean isMouseEvent(String type) {
        return TYPE_CLICK.equals(type) || TYPE_MOUSE_OVER.equals(type) || TYPE_MOUSE_MOVE.equals(type) || TYPE_MOUSE_OUT.equals(type) || TYPE_MOUSE_DOWN.equals(type) || TYPE_MOUSE_UP.equals(type) || TYPE_CONTEXT_MENU.equals(type);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean getAltKey() {
        return super.getAltKey();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean getCtrlKey() {
        return super.getCtrlKey();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean getShiftKey() {
        return super.getShiftKey();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f), @WebBrowser(value=BrowserName.CHROME)})
    public Object getKeyCode() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MOUSE_EVENT_KEY_CODE_ZERO)) {
            return 0;
        }
        return Undefined.instance;
    }
}

