/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumn;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumnGroup;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClasses(value={@JsxClass(domClass=HtmlTableColumn.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(domClass=HtmlTableColumn.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)}), @JsxClass(domClass=HtmlTableColumnGroup.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(domClass=HtmlTableColumnGroup.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLTableColElement
extends HTMLTableComponent {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLTableColElement() {
    }

    @JsxGetter
    public int getSpan() {
        int i;
        String span = this.getDomNodeOrDie().getAttribute("span");
        try {
            i = Integer.parseInt(span);
            if (i < 1) {
                i = 1;
            }
        }
        catch (NumberFormatException e) {
            i = 1;
        }
        return i;
    }

    @JsxSetter
    public void setSpan(Object span) {
        double d = Context.toNumber((Object)span);
        int i = (int)d;
        if (i < 1) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_THROWS_EXCEPTION_IF_INVALID)) {
                Exception e = new Exception("Cannot set the span property to invalid value: " + span);
                Context.throwAsScriptRuntimeEx((Throwable)e);
            } else {
                i = 1;
            }
        }
        this.getDomNodeOrDie().setAttribute("span", Integer.toString(i));
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_COLUMN_WIDTH_NO_NEGATIVE_VALUES);
        Boolean returnNegativeValues = ie ? Boolean.FALSE : null;
        return this.getWidthOrHeight("width", returnNegativeValues);
    }

    @JsxSetter
    public void setWidth(Object width) {
        this.setWidthOrHeight("width", width == null ? "" : Context.toString((Object)width), false);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.getDomNodeOrDie() instanceof HtmlTableColumn;
    }

    @Override
    @JsxSetter
    public void setOuterHTML(Object value) {
        throw Context.reportRuntimeError((String)("outerHTML is read-only for tag '" + this.getDomNodeOrDie().getNodeName() + "'"));
    }

    @Override
    @JsxSetter
    public void setInnerHTML(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_READONLY_FOR_SOME_TAGS)) {
            throw Context.reportRuntimeError((String)("innerHTML is read-only for tag '" + this.getDomNodeOrDie().getNodeName() + "'"));
        }
        super.setInnerHTML(value);
    }
}

