/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URLEncodedUtils;

public class UrlFetchWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(UrlFetchWebConnection.class);
    private static final String[] GAE_URL_HACKS = new String[]{"http://gaeHack_javascript/", "http://gaeHack_data/", "http://gaeHack_about/"};
    private final WebClient webClient_;

    public UrlFetchWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
    }

    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        WebResponse response;
        long startTime = System.currentTimeMillis();
        URL url = webRequest.getUrl();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("about to fetch URL " + url));
        }
        if ((response = UrlFetchWebConnection.produceWebResponseForGAEProcolHack(url)) != null) {
            return response;
        }
        try {
            byte[] byArray;
            Object outputStream;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.webClient_.getOptions().getTimeout());
            connection.addRequestProperty("User-Agent", this.webClient_.getBrowserVersion().getUserAgent());
            connection.setInstanceFollowRedirects(false);
            for (Map.Entry<String, String> header : webRequest.getAdditionalHeaders().entrySet()) {
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
            this.addCookies(connection);
            HttpMethod httpMethod = webRequest.getHttpMethod();
            connection.setRequestMethod(httpMethod.name());
            if (HttpMethod.POST == httpMethod || HttpMethod.PUT == httpMethod || HttpMethod.PATCH == httpMethod) {
                connection.setDoOutput(true);
                Charset charset = webRequest.getCharset();
                connection.addRequestProperty("Content-Type", FormEncodingType.URL_ENCODED.getName());
                Throwable throwable = null;
                Object var10_12 = null;
                try {
                    outputStream = connection.getOutputStream();
                    try {
                        List<NameValuePair> pairs = webRequest.getRequestParameters();
                        org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                        String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (Charset)charset);
                        ((OutputStream)outputStream).write(query.getBytes(charset));
                        if (webRequest.getRequestBody() != null) {
                            IOUtils.write((byte[])webRequest.getRequestBody().getBytes(charset), (OutputStream)outputStream);
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            ((OutputStream)outputStream).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int responseCode = connection.getResponseCode();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("fetched URL " + url));
            }
            ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
            for (Map.Entry entry : connection.getHeaderFields().entrySet()) {
                String headerKey = (String)entry.getKey();
                if (headerKey == null) continue;
                StringBuilder sb = new StringBuilder();
                for (String headerValue : (List)entry.getValue()) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(headerValue);
                }
                headers.add(new NameValuePair(headerKey, sb.toString()));
            }
            outputStream = null;
            Object var12_20 = null;
            try (InputStream is = responseCode < 400 ? connection.getInputStream() : connection.getErrorStream();){
                byArray = IOUtils.toByteArray((InputStream)is);
            }
            catch (Throwable throwable) {
                if (outputStream == null) {
                    outputStream = throwable;
                } else if (outputStream != throwable) {
                    ((Throwable)outputStream).addSuppressed(throwable);
                }
                throw outputStream;
            }
            long duration = System.currentTimeMillis() - startTime;
            WebResponseData responseData = new WebResponseData(byArray, responseCode, connection.getResponseMessage(), headers);
            this.saveCookies(url.getHost(), headers);
            return new WebResponse(responseData, webRequest, duration);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while tyring to fetch " + url), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addCookies(HttpURLConnection connection) {
        StringBuilder cookieHeader = new StringBuilder();
        Set<Cookie> cookies = this.webClient_.getCookieManager().getCookies();
        if (cookies.isEmpty()) {
            return;
        }
        int cookieNb = 1;
        for (Cookie cookie : this.webClient_.getCookieManager().getCookies()) {
            cookieHeader.append(cookie.getName()).append('=').append(cookie.getValue());
            if (cookieNb < cookies.size()) {
                cookieHeader.append("; ");
            }
            ++cookieNb;
        }
        connection.setRequestProperty("Cookie", cookieHeader.toString());
    }

    private void saveCookies(String domain, List<NameValuePair> headers) {
        for (NameValuePair nvp : headers) {
            if (!"Set-Cookie".equalsIgnoreCase(nvp.getName())) continue;
            Set<Cookie> cookies = UrlFetchWebConnection.parseCookies(domain, nvp.getValue());
            for (Cookie cookie : cookies) {
                this.webClient_.getCookieManager().addCookie(cookie);
            }
        }
    }

    private static WebResponse produceWebResponseForGAEProcolHack(URL url) {
        String externalForm = url.toExternalForm();
        String[] stringArray = GAE_URL_HACKS;
        int n = GAE_URL_HACKS.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            int index = externalForm.indexOf(pattern);
            if (index == 0) {
                String contentString = externalForm.substring(pattern.length());
                if (contentString.startsWith("'") && contentString.endsWith("'")) {
                    contentString = contentString.substring(1, contentString.length() - 1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("special handling of URL, returning (" + contentString + ") for URL " + url));
                }
                return new StringWebResponse(contentString, url);
            }
            ++n2;
        }
        return null;
    }

    static Set<Cookie> parseCookies(String domain, String cookieHeaderString) {
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        String[] cookieStrings = cookieHeaderString.split(",");
        int i = 0;
        while (i < cookieStrings.length) {
            String[] nameAndValue = cookieStrings[i].split(";")[0].split("=");
            if (nameAndValue.length > 1) {
                cookies.add(new Cookie(domain, nameAndValue[0], nameAndValue[1]));
            }
            ++i;
        }
        return cookies;
    }

    @Override
    public void close() throws Exception {
    }
}

