/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.w3c.dom.NamedNodeMap;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMNamedNodeMap
extends MSXMLScriptable {
    private final NamedNodeMap attributes_;
    private int currentIndex_ = 0;

    public XMLDOMNamedNodeMap() {
        this.attributes_ = null;
    }

    public XMLDOMNamedNodeMap(DomNode node) {
        this.setParentScope((Scriptable)node.getScriptableObject());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributes_ = node.getAttributes();
        this.setDomNode(node, false);
    }

    public final Object get(int index, Scriptable start) {
        XMLDOMNamedNodeMap startMap = (XMLDOMNamedNodeMap)start;
        Object response = startMap.item(index);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @JsxGetter
    public int getLength() {
        return this.attributes_.getLength();
    }

    public Object getNamedItemWithoutSyntheticClassAttr(String name) {
        DomNode attr;
        if (this.attributes_ != null && (attr = (DomNode)this.attributes_.getNamedItem(name)) != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getNamedItem(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        Object attr = this.getNamedItemWithoutSyntheticClassAttr(name);
        if (attr != null) {
            return attr;
        }
        return null;
    }

    @JsxFunction
    public Object item(int index) {
        DomNode attr = (DomNode)this.attributes_.item(index);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object nextNode() {
        return this.item(this.currentIndex_++);
    }

    @JsxFunction
    public Object removeNamedItem(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        DomNode attr = (DomNode)this.attributes_.removeNamedItem(name);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction
    public Object setNamedItem(XMLDOMNode node) {
        if (node == null) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        this.attributes_.setNamedItem(node.getDomNodeOrDie());
        return node;
    }
}

