/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.css;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SelectorSpecificity
implements Comparable<SelectorSpecificity>,
Serializable {
    private static final Log LOG = LogFactory.getLog(SelectorSpecificity.class);
    public static final SelectorSpecificity FROM_STYLE_ATTRIBUTE = new SelectorSpecificity(1, 0, 0, 0);
    private int fieldA_;
    private int fieldB_;
    private int fieldC_;
    private int fieldD_;

    public SelectorSpecificity(Selector selector) {
        this.readSelectorSpecificity(selector);
    }

    private SelectorSpecificity(int a, int b, int c, int d) {
        this.fieldA_ = a;
        this.fieldB_ = b;
        this.fieldC_ = c;
        this.fieldD_ = d;
    }

    private void readSelectorSpecificity(Selector selector) {
        switch (selector.getSelectorType()) {
            case 1: {
                return;
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                this.readSelectorSpecificity(ds.getAncestorSelector());
                this.readSelectorSpecificity((Selector)ds.getSimpleSelector());
                return;
            }
            case 11: {
                DescendantSelector cs = (DescendantSelector)selector;
                this.readSelectorSpecificity(cs.getAncestorSelector());
                this.readSelectorSpecificity((Selector)cs.getSimpleSelector());
                return;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                SimpleSelector simpleSel = conditional.getSimpleSelector();
                if (simpleSel != null) {
                    this.readSelectorSpecificity((Selector)simpleSel);
                }
                this.readSelectorSpecificity(conditional.getCondition());
                return;
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String esName = es.getLocalName();
                if (esName != null) {
                    ++this.fieldD_;
                }
                return;
            }
            case 9: {
                ElementSelector pes = (ElementSelector)selector;
                String pesName = pes.getLocalName();
                if (pesName != null) {
                    ++this.fieldD_;
                }
                return;
            }
            case 12: {
                SiblingSelector ss = (SiblingSelector)selector;
                this.readSelectorSpecificity(ss.getSelector());
                this.readSelectorSpecificity((Selector)ss.getSiblingSelector());
                return;
            }
        }
        LOG.warn((Object)("Unhandled CSS selector type for specificity computation: '" + selector.getSelectorType() + "'."));
    }

    private void readSelectorSpecificity(Condition condition) {
        switch (condition.getConditionType()) {
            case 5: {
                ++this.fieldB_;
                return;
            }
            case 9: {
                ++this.fieldC_;
                return;
            }
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                this.readSelectorSpecificity(cc1.getFirstCondition());
                this.readSelectorSpecificity(cc1.getSecondCondition());
                return;
            }
            case 4: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                if ("id".equalsIgnoreCase(ac1.getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case 10: {
                ++this.fieldD_;
                return;
            }
        }
        LOG.warn((Object)("Unhandled CSS condition type for specifity computation: '" + condition.getConditionType() + "'."));
    }

    public String toString() {
        return String.valueOf(this.fieldA_) + "," + this.fieldB_ + "," + this.fieldC_ + "," + this.fieldD_;
    }

    @Override
    public int compareTo(SelectorSpecificity other) {
        if (this.fieldA_ != other.fieldA_) {
            return this.fieldA_ - other.fieldA_;
        }
        if (this.fieldB_ != other.fieldB_) {
            return this.fieldB_ - other.fieldB_;
        }
        if (this.fieldC_ != other.fieldC_) {
            return this.fieldC_ - other.fieldC_;
        }
        if (this.fieldD_ != other.fieldD_) {
            return this.fieldD_ - other.fieldD_;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fieldA_;
        result = 31 * result + this.fieldB_;
        result = 31 * result + this.fieldC_;
        result = 31 * result + this.fieldD_;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectorSpecificity other = (SelectorSpecificity)obj;
        if (this.fieldA_ != other.fieldA_) {
            return false;
        }
        if (this.fieldB_ != other.fieldB_) {
            return false;
        }
        if (this.fieldC_ != other.fieldC_) {
            return false;
        }
        return this.fieldD_ == other.fieldD_;
    }
}

