/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DomTreeWalker
implements TreeWalker {
    private final DomNode root_;
    private DomNode currentNode_;
    private final int whatToShow_;
    private final NodeFilter filter_;
    private final boolean expandEntityReferences_;

    public DomTreeWalker(DomNode root, int whatToShow, NodeFilter filter, boolean expandEntityReferences) throws DOMException {
        if (root == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(9, "root must not be null"));
        }
        this.root_ = root;
        this.whatToShow_ = whatToShow;
        this.filter_ = filter;
        this.expandEntityReferences_ = expandEntityReferences;
        this.currentNode_ = this.root_;
    }

    @Override
    public DomNode getRoot() {
        return this.root_;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow_;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter_;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences_;
    }

    @Override
    public DomNode getCurrentNode() {
        return this.currentNode_;
    }

    @Override
    public void setCurrentNode(Node currentNode) throws DOMException {
        if (currentNode == null) {
            throw new DOMException(9, "currentNode cannot be set to null");
        }
        this.currentNode_ = (DomNode)currentNode;
    }

    @Override
    public DomNode nextNode() {
        DomNode leftChild = this.getEquivalentLogical(this.currentNode_.getFirstChild(), false);
        if (leftChild != null) {
            this.currentNode_ = leftChild;
            return leftChild;
        }
        DomNode rightSibling = this.getEquivalentLogical(this.currentNode_.getNextSibling(), false);
        if (rightSibling != null) {
            this.currentNode_ = rightSibling;
            return rightSibling;
        }
        DomNode uncle = this.getFirstUncleNode(this.currentNode_);
        if (uncle != null) {
            this.currentNode_ = uncle;
            return uncle;
        }
        return null;
    }

    private DomNode getFirstUncleNode(DomNode n) {
        if (n == this.root_ || n == null) {
            return null;
        }
        DomNode parent = n.getParentNode();
        if (parent == null) {
            return null;
        }
        DomNode uncle = this.getEquivalentLogical(parent.getNextSibling(), false);
        if (uncle != null) {
            return uncle;
        }
        return this.getFirstUncleNode(parent);
    }

    private DomNode getEquivalentLogical(DomNode n, boolean lookLeft) {
        DomNode child;
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return n;
        }
        if (this.isNodeSkipped(n) && (child = lookLeft ? this.getEquivalentLogical(n.getLastChild(), lookLeft) : this.getEquivalentLogical(n.getFirstChild(), lookLeft)) != null) {
            return child;
        }
        return this.getSibling(n, lookLeft);
    }

    private boolean isNodeVisible(Node n) {
        if (this.acceptNode(n) == 1 && (this.filter_ == null || this.filter_.acceptNode(n) == 1)) {
            return this.expandEntityReferences_ || n.getParentNode() == null || n.getParentNode().getNodeType() != 5;
        }
        return false;
    }

    private short acceptNode(Node n) {
        int flag = DomTreeWalker.getFlagForNode(n);
        if ((this.whatToShow_ & flag) != 0) {
            return 1;
        }
        return 3;
    }

    static int getFlagForNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 11: {
                return 1024;
            }
            case 12: {
                return 2048;
            }
        }
        return 0;
    }

    private boolean isNodeSkipped(Node n) {
        return !this.isNodeVisible(n) && !this.isNodeRejected(n);
    }

    private boolean isNodeRejected(Node n) {
        if (this.acceptNode(n) == 2) {
            return true;
        }
        if (this.filter_ != null && this.filter_.acceptNode(n) == 2) {
            return true;
        }
        return !this.expandEntityReferences_ && n.getParentNode() != null && n.getParentNode().getNodeType() == 5;
    }

    private DomNode getSibling(DomNode n, boolean lookLeft) {
        if (n == null) {
            return null;
        }
        if (this.isNodeVisible(n)) {
            return null;
        }
        DomNode sibling = lookLeft ? n.getPreviousSibling() : n.getNextSibling();
        if (sibling == null) {
            if (n == this.root_) {
                return null;
            }
            return this.getSibling(n.getParentNode(), lookLeft);
        }
        return this.getEquivalentLogical(sibling, lookLeft);
    }

    @Override
    public DomNode nextSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        DomNode newNode = this.getEquivalentLogical(this.currentNode_.getNextSibling(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @Override
    public DomNode parentNode() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        DomNode newNode = this.currentNode_;
        while ((newNode = newNode.getParentNode()) != null && !this.isNodeVisible(newNode) && newNode != this.root_) {
        }
        if (newNode == null || !this.isNodeVisible(newNode)) {
            return null;
        }
        this.currentNode_ = newNode;
        return newNode;
    }

    @Override
    public DomNode previousSibling() {
        if (this.currentNode_ == this.root_) {
            return null;
        }
        DomNode newNode = this.getEquivalentLogical(this.currentNode_.getPreviousSibling(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @Override
    public DomNode lastChild() {
        DomNode newNode = this.getEquivalentLogical(this.currentNode_.getLastChild(), true);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    @Override
    public DomNode previousNode() {
        DomNode newNode = this.getPreviousNode(this.currentNode_);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }

    private DomNode getPreviousNode(DomNode n) {
        DomNode follow;
        if (n == this.root_) {
            return null;
        }
        DomNode left = this.getEquivalentLogical(n.getPreviousSibling(), true);
        if (left == null) {
            DomNode parent = n.getParentNode();
            if (parent == null) {
                return null;
            }
            if (this.isNodeVisible(parent)) {
                return parent;
            }
        }
        if ((follow = left) != null) {
            while (follow.hasChildNodes()) {
                DomNode toFollow = this.getEquivalentLogical(follow.getLastChild(), true);
                if (toFollow == null) break;
                follow = toFollow;
            }
        }
        return follow;
    }

    @Override
    public DomNode firstChild() {
        DomNode newNode = this.getEquivalentLogical(this.currentNode_.getFirstChild(), false);
        if (newNode != null) {
            this.currentNode_ = newNode;
        }
        return newNode;
    }
}

