/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlImageInput
extends HtmlInput {
    private boolean wasPositionSpecified_;
    private int xPosition_;
    private int yPosition_;

    HtmlImageInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String name = this.getNameAttribute();
        String prefix = StringUtils.isEmpty((CharSequence)name) ? "" : String.valueOf(name) + ".";
        if (this.wasPositionSpecified_) {
            NameValuePair valueX = new NameValuePair(String.valueOf(prefix) + 'x', Integer.toString(this.xPosition_));
            NameValuePair valueY = new NameValuePair(String.valueOf(prefix) + 'y', Integer.toString(this.yPosition_));
            if (!prefix.isEmpty() && this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_NAME_VALUE_PARAMS) && !this.getValueAttribute().isEmpty()) {
                return new NameValuePair[]{valueX, valueY, new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
            }
            return new NameValuePair[]{valueX, valueY};
        }
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        return super.click();
    }

    @Override
    public <P extends Page> P click(Event event, boolean ignoreVisibility) throws IOException {
        this.wasPositionSpecified_ = true;
        return super.click(event, ignoreVisibility);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners) {
        if ("value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners);
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

