/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.w3c.css.sac.CSSException;

@JsxClass(domClass=DomElement.class)
public class Element
extends EventNode {
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;
    private CSSStyleDeclaration style_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Element() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.style_ = new CSSStyleDeclaration(this);
        this.setParentScope((Scriptable)this.getWindow().getDocument());
        DomElement htmlElt = (DomElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = attr.getName();
            if (eventName.length() <= 2 || Character.toLowerCase(eventName.charAt(0)) != 'o' || Character.toLowerCase(eventName.charAt(1)) != 'n') continue;
            this.createEventHandler(eventName, attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        DomElement htmlElt = this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        this.setEventHandler(eventName, (Function)eventHandler);
    }

    @JsxGetter
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    @JsxGetter
    public NamedNodeMap getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getBaseURI() {
        if ("Element".equals(this.getClass().getSimpleName()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_BASE_URL_NULL)) {
            return null;
        }
        return this.getDomNodeOrDie().getPage().getUrl().toExternalForm();
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    @JsxFunction
    public String getAttribute(String attributeName, Integer flags) {
        String value = this.getDomNodeOrDie().getAttribute(attributeName);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = null;
        }
        return value;
    }

    @JsxFunction
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        HTMLCollection collection;
        final String tagNameLC = tagName.toLowerCase(Locale.ROOT);
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((collection = this.elementsByTagName_.get(tagNameLC)) != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        collection = "*".equals(tagName) ? new HTMLCollection(node, false){

            @Override
            protected boolean isMatching(DomNode nodeToMatch) {
                return true;
            }
        } : new HTMLCollection(node, false){

            @Override
            protected boolean isMatching(DomNode nodeToMatch) {
                return tagNameLC.equalsIgnoreCase(nodeToMatch.getNodeName());
            }
        };
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    @JsxFunction
    public Object getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getElementsByTagNameNS(final Object namespaceURI, final String localName) {
        HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return !(!"*".equals(namespaceURI) && !Objects.equals(namespaceURI, node.getNamespaceURI()) || !"*".equals(localName) && !Objects.equals(localName, node.getLocalName()));
            }
        };
        return collection;
    }

    @JsxFunction
    public boolean hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    @Override
    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    @JsxFunction
    public void removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
    }

    @JsxFunction
    public ClientRect getBoundingClientRect() {
        if (!this.getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BOUNDINGCLIENTRECT_THROWS_IF_DISCONNECTED)) {
            throw Context.reportRuntimeError((String)"Element is not attache to a page");
        }
        ClientRect textRectangle = new ClientRect(1, 1, 1, 1);
        textRectangle.setParentScope((Scriptable)this.getWindow());
        textRectangle.setPrototype(this.getPrototype(textRectangle.getClass()));
        return textRectangle;
    }

    @JsxGetter
    public int getChildElementCount() {
        return this.getDomNodeOrDie().getChildElementCount();
    }

    @JsxGetter
    public Element getFirstElementChild() {
        DomElement child = this.getDomNodeOrDie().getFirstElementChild();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getLastElementChild() {
        DomElement child = this.getDomNodeOrDie().getLastElementChild();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    public Element getParentElement() {
        Node parent = this.getParent();
        while (parent != null && !(parent instanceof Element)) {
            parent = parent.getParent();
        }
        return (Element)parent;
    }

    public void setDefaults(ComputedCSSStyleDeclaration style) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLCollection getChildren() {
        final DomElement node = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(node, false){

            @Override
            protected List<Object> computeElements() {
                LinkedList<Object> children = new LinkedList<Object>();
                Iterator iterator = node.getChildNodes().iterator();
                while (iterator.hasNext()) {
                    DomNode domNode = (DomNode)iterator.next();
                    if (!(domNode instanceof DomElement)) continue;
                    children.add(domNode);
                }
                return children;
            }
        };
        return collection;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    @JsxFunction
    public String getAttributeNS(String namespaceURI, String localName) {
        String value = this.getDomNodeOrDie().getAttributeNS(namespaceURI, localName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_GET_ATTRIBUTE_RETURNS_EMPTY)) {
            return null;
        }
        return value;
    }

    @JsxFunction
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().hasAttributeNS(namespaceURI, localName);
    }

    @JsxFunction
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getDomNodeOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @JsxFunction
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.getDomNodeOrDie().removeAttributeNS(namespaceURI, localName);
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    @JsxSetter
    public void setStyle(String style) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_GET_ATTRIBUTE_RETURNS_EMPTY)) {
            this.getStyle().setCssText(style);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public CSSStyleDeclaration getRuntimeStyle() {
        return this.style_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public ComputedCSSStyleDeclaration getCurrentStyle() {
        if (!this.getDomNodeOrDie().isAttachedToPage()) {
            return null;
        }
        return this.getWindow().getComputedStyle(this, null);
    }

    @JsxFunction
    public Attr setAttributeNode(Attr newAtt) {
        String name = newAtt.getName();
        NamedNodeMap nodes = this.getAttributes();
        Attr replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME)})
    public void blur() {
        DomElement domNode = this.getDomNodeOrDie();
        if (domNode instanceof HtmlElement) {
            ((HtmlElement)domNode).blur();
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Document doc;
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (doc = this.getWindow().getDocument()) instanceof HTMLDocument && ((HTMLDocument)doc).getDocumentMode() < 8) {
            return NOT_FOUND;
        }
        return response;
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            ArrayList<Object> nodes = new ArrayList<Object>();
            for (DomNode domNode : this.getDomNodeOrDie().querySelectorAll(selectors)) {
                nodes.add(domNode.getScriptableObject());
            }
            return NodeList.staticNodeList(this, nodes);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }
}

