/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Map
extends SimpleScriptable {
    private java.util.Map<Object, Object> map_ = new LinkedHashMap<Object, Object>();

    public Map() {
    }

    @JsxConstructor
    public Map(Object iterable) {
        Window window;
        if (iterable != Undefined.instance && (window = (Window)ScriptRuntime.getTopCallScope((Context)Context.getCurrentContext())).getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_ARGUMENT)) {
            if (iterable instanceof NativeArray) {
                NativeArray array = (NativeArray)iterable;
                int i = 0;
                while ((long)i < array.getLength()) {
                    Object entryObject = array.get(i);
                    if (entryObject instanceof NativeArray) {
                        Object[] entry = Map.toArray((NativeArray)entryObject);
                        if (entry.length > 0) {
                            Object key = entry[0];
                            Object value = entry.length > 1 ? entry[1] : null;
                            this.set(key, value);
                        }
                    } else {
                        throw Context.reportRuntimeError((String)("TypeError: object is not iterable (" + entryObject.getClass().getName() + ")"));
                    }
                    ++i;
                }
            } else if (iterable instanceof Map) {
                Map map = (Map)iterable;
                this.map_.putAll(map.map_);
            } else {
                throw Context.reportRuntimeError((String)("TypeError: object is not iterable (" + iterable.getClass().getName() + ")"));
            }
        }
    }

    private static Object[] toArray(NativeArray narray) {
        long longLen = narray.getLength();
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len = (int)longLen;
        Object[] arr = new Object[len];
        int i = 0;
        while (i < len) {
            arr[i] = ScriptableObject.getProperty((Scriptable)narray, (int)i);
            ++i;
        }
        return arr;
    }

    @JsxGetter
    public int getSize() {
        return this.map_.size();
    }

    @JsxFunction
    public Object get(Object key) {
        Object o = this.map_.get(key);
        if (o == null) {
            o = Undefined.instance;
        }
        return o;
    }

    @JsxFunction
    public Map set(Object key, Object value) {
        if (key instanceof Delegator) {
            key = ((Delegator)key).getDelegee();
        }
        this.map_.put(key, value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.map_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.map_.remove(key) != null;
    }

    @JsxFunction
    public boolean has(Object key) {
        return this.map_.remove(key) != null;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (name.equals("Symbol(Symbol.iterator)")) {
            return super.get("entries", start);
        }
        return super.get(name, start);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Object entries() {
        Iterator object = new Iterator("Map Iterator", this.map_.entrySet().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        return object;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Object keys() {
        Iterator object = new Iterator("Map Iterator", this.map_.keySet().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        return object;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Object values() {
        Iterator object = new Iterator("Map Iterator", this.map_.values().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        return object;
    }

    @JsxFunction
    public void forEach(Function callback, Object thisArg) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_ARGUMENT)) {
            Object thisArgument = thisArg instanceof Scriptable ? (Scriptable)thisArg : this.getWindow();
            for (Map.Entry<Object, Object> entry : this.map_.entrySet()) {
                callback.call(Context.getCurrentContext(), this.getParentScope(), thisArgument, new Object[]{entry.getValue(), entry.getKey(), this});
            }
        }
    }
}

