/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=HtmlAnchor.class)
public class HTMLAnchorElement
extends HTMLElement {
    private static final List<String> REFERRER_POLICIES = Arrays.asList("no-referrer", "origin", "unsafe-url");

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLAnchorElement() {
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (hrefAttr == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return "";
        }
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return hrefAttr;
        }
    }

    @Override
    public void focus() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (hrefAttr != DomElement.ATTRIBUTE_NOT_DEFINED) {
            anchor.focus();
        }
    }

    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttribute("name");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttribute("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getDomNodeOrDie().setAttribute("href", url.toString());
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public String getReferrerPolicy() {
        String attrib = ((HtmlAnchor)this.getDomNodeOrDie()).getAttribute("referrerPolicy");
        if (StringUtils.isEmpty((CharSequence)attrib)) {
            return "";
        }
        if (REFERRER_POLICIES.contains(attrib = attrib.toLowerCase(Locale.ROOT))) {
            return attrib;
        }
        return "";
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public void setReferrerPolicy(String referrerPolicy) {
        this.getDomNodeOrDie().setAttribute("referrerPolicy", referrerPolicy);
    }

    @JsxGetter
    public String getSearch() {
        String query;
        block3: {
            try {
                query = this.getUrl().getQuery();
                if (query != null) break block3;
                return "";
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
        return "?" + query;
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    @JsxGetter
    public String getHash() {
        String hash;
        block3: {
            try {
                hash = this.getUrl().getRef();
                if (hash != null) break block3;
                return "";
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
        return "#" + hash;
    }

    @JsxSetter
    public void setHash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    @JsxGetter
    public String getHost() {
        try {
            URL url = this.getUrl();
            int port = url.getPort();
            String host = url.getHost();
            if (port == -1) {
                return host;
            }
            return String.valueOf(host) + ":" + port;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getHostname() {
        try {
            return this.getUrl().getHost();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    @JsxGetter
    public String getPathname() {
        HtmlAnchor anchor;
        String href;
        URL url;
        block7: {
            try {
                url = this.getUrl();
                if (url.getProtocol().startsWith("http") || !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_NONE_HTTP_URL)) break block7;
                return "";
            }
            catch (MalformedURLException e) {
                HtmlAnchor anchor2 = (HtmlAnchor)this.getDomNodeOrDie();
                if (anchor2.getHrefAttribute().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_BROKEN_URL)) {
                    return "";
                }
                return "/";
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute()).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_UPPER_CASE_DRIVE_LETTERS)) {
                href = StringUtils.capitalize((String)href);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_PREFIX_WIN_DRIVES_URL)) {
                href = "/" + href;
            }
            return href;
        }
        return url.getPath();
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() {
        int port;
        block3: {
            try {
                port = this.getUrl().getPort();
                if (port != -1) break block3;
                return "";
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
        return Integer.toString(port);
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() {
        block4: {
            try {
                HtmlAnchor anchor;
                String href;
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) || (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute().toLowerCase(Locale.ROOT)).length() <= 1 || !Character.isLetter(href.charAt(0)) || ':' != href.charAt(1)) break block4;
                return "file:";
            }
            catch (MalformedURLException e) {
                HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
                if (anchor.getHrefAttribute().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_FOR_BROKEN_URL)) {
                    return ":";
                }
                return StringUtils.substringBefore((String)anchor.getHrefAttribute(), (String)"/");
            }
        }
        return String.valueOf(this.getUrl().getProtocol()) + ":";
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        String bareProtocol = StringUtils.substringBefore((String)protocol, (String)":");
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol));
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    static String getDefaultValue(HtmlElement element) {
        String href = element.getAttribute("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            return "";
        }
        href = href.trim();
        SgmlPage page = element.getPage();
        if (page == null || !page.isHtmlPage()) {
            return href;
        }
        try {
            return HtmlAnchor.getTargetUrl(href, (HtmlPage)page).toExternalForm();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        return htmlElement.asText();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.setTextContent(text);
    }

    @JsxGetter
    public String getCharset() {
        return this.getDomNodeOrDie().getAttribute("charset");
    }

    @JsxSetter
    public void setCharset(String charset) {
        this.getDomNodeOrDie().setAttribute("charset", charset);
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttribute("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }

    @JsxGetter
    public String getHreflang() {
        return this.getDomNodeOrDie().getAttribute("hreflang");
    }

    @JsxSetter
    public void setHreflang(String hreflang) {
        this.getDomNodeOrDie().setAttribute("hreflang", hreflang);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getOrigin() {
        if (!this.getDomNodeOrDie().hasAttribute("href")) {
            return "";
        }
        try {
            return String.valueOf(this.getUrl().getProtocol()) + "://" + this.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void setOrigin(String origin) {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getUsername() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void setUsername(String username) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getPassword() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void setPassword(String password) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getDownload() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void setDownload(String download) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getPing() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getPingAttribute();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public void setPing(String ping) {
        this.getDomNodeOrDie().setAttribute("ping", ping);
    }

    @JsxGetter
    public String getShape() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter
    public void setShape(String shape) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttribute("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public DOMTokenList getRelList() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getProtocolLong() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(propertyName="Methods", value={@WebBrowser(value=BrowserName.IE)})
    public String getMethods() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(propertyName="Methods", value={@WebBrowser(value=BrowserName.IE)})
    public void setMethods(String methods) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getMimeType() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setMimeType(String mimeType) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getNameProp() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUrn() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setUrn(String urn) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }
}

