/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.ArrayUtils;

@JsxClass(domClass=HtmlParagraph.class)
public class HTMLParagraphElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLParagraphElement() {
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttribute("clear");
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setClear(String clear) {
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            throw Context.reportRuntimeError((String)("Invalid clear property value: '" + clear + "'."));
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }
}

