/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.intl;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.host.intl.AbstractDateTimeFormatter;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

class DefaultDateTimeFormatter
implements AbstractDateTimeFormatter {
    private DateTimeFormatter formatter_;
    private Chronology chronology_;

    DefaultDateTimeFormatter(String locale, BrowserVersion browserVersion, String pattern) {
        this.formatter_ = DateTimeFormatter.ofPattern(pattern);
        if (!(!locale.startsWith("ar") || browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_AR_DZ_ASCII_DIGITS) && ("ar-DZ".equals(locale) || "ar-LY".equals(locale) || "ar-MA".equals(locale) || "ar-TN".equals(locale)))) {
            DecimalStyle decimalStyle = DecimalStyle.STANDARD.withZeroDigit('\u0660');
            this.formatter_ = this.formatter_.withDecimalStyle(decimalStyle);
        }
        switch (locale) {
            case "ja-JP-u-ca-japanese": {
                this.chronology_ = JapaneseChronology.INSTANCE;
                break;
            }
            case "ar": {
                if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK)) break;
                this.chronology_ = HijrahChronology.INSTANCE;
                break;
            }
            case "ar-SA": {
                if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_AR_DZ_ASCII_DIGITS)) break;
                this.chronology_ = HijrahChronology.INSTANCE;
                break;
            }
            case "ar-SD": {
                if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK)) break;
                this.chronology_ = HijrahChronology.INSTANCE;
                break;
            }
            case "th": 
            case "th-TH": {
                this.chronology_ = ThaiBuddhistChronology.INSTANCE;
            }
        }
    }

    @Override
    public String format(Date date) {
        Comparable<ChronoZonedDateTime<?>> zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        if (this.chronology_ != null) {
            zonedDateTime = this.chronology_.date((TemporalAccessor)((Object)zonedDateTime));
        }
        return this.formatter_.format((TemporalAccessor)((Object)zonedDateTime));
    }
}

