/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class FormData
extends SimpleScriptable {
    private final List<NameValuePair> requestParameters_ = new ArrayList<NameValuePair>();

    public FormData() {
    }

    @JsxConstructor
    public FormData(Object formObj) {
        if (formObj instanceof HTMLFormElement) {
            HTMLFormElement form = (HTMLFormElement)formObj;
            this.requestParameters_.addAll(form.getHtmlForm().getParameterListForSubmit(null));
        }
    }

    @JsxFunction
    public void append(String name, Object value, Object filename) {
        if (value instanceof File) {
            File file = (File)value;
            String fileName = null;
            String contentType = null;
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            if (StringUtils.isEmpty((CharSequence)(contentType = file.getType()))) {
                contentType = "application/octet-stream";
            }
            this.requestParameters_.add(new KeyDataPair(name, file.getFile(), fileName, contentType, null));
        } else {
            this.requestParameters_.add(new NameValuePair(name, Context.toString((Object)value)));
        }
    }

    @JsxFunction(functionName="delete", value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void delete_js(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Iterator<NameValuePair> iter = this.requestParameters_.iterator();
        while (iter.hasNext()) {
            NameValuePair pair = iter.next();
            if (!name.equals(pair.getName())) continue;
            iter.remove();
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String get(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return pair.getValue();
        }
        return null;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Scriptable getAll(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Context.getCurrentContext().newArray((Scriptable)this, 0);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            values.add(pair.getValue());
        }
        Object[] stringValues = values.toArray(new Object[values.size()]);
        return Context.getCurrentContext().newArray((Scriptable)this, stringValues);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public boolean has(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return true;
        }
        return false;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void set(String name, Object value, Object filename) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        int pos = -1;
        Iterator<NameValuePair> iter = this.requestParameters_.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            NameValuePair pair = iter.next();
            if (name.equals(pair.getName())) {
                iter.remove();
                if (pos < 0) {
                    pos = idx;
                }
            }
            ++idx;
        }
        if (pos < 0) {
            pos = this.requestParameters_.size();
        }
        if (value instanceof File) {
            File file = (File)value;
            String fileName = null;
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            this.requestParameters_.add(pos, new KeyDataPair(name, file.getFile(), fileName, file.getType(), null));
        } else {
            this.requestParameters_.add(pos, new NameValuePair(name, Context.toString((Object)value)));
        }
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setEncodingType(FormEncodingType.MULTIPART);
        webRequest.setRequestParameters(this.requestParameters_);
    }
}

