/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.htmlparser.impl.ByteReadable;
import nu.validator.htmlparser.impl.EncodingInfo;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MetaSniffer
implements Locator {
    private static final Pattern CONTENT = Pattern.compile("^[^;]*;[\\x09\\x0A\\x0B\\x0C\\x0D\\x20]*[cC][hH][aA][rR][sS][eE][tT][\\x09\\x0A\\x0B\\x0C\\x0D\\x20]*=[\\x09\\x0A\\x0B\\x0C\\x0D\\x20]*(?:(?:([^'\"\\x09\\x0A\\x0B\\x0C\\x0D\\x20][^\\x09\\x0A\\x0B\\x0C\\x0D\\x20]*)(?:[\\x09\\x0A\\x0B\\x0C\\x0D\\x20].*)?)|(?:\"([^\"]*)\".*)|(?:'([^']*)'.*))$", 32);
    private final ByteReadable source;
    private final ErrorHandler errorHandler;
    private CharsetDecoder charsetDecoder = null;
    private StringBuilder attributeName = new StringBuilder();
    private StringBuilder attributeValue = new StringBuilder();
    private MetaState metaState = MetaState.NO;
    private int unread = -1;
    private int line = 1;
    private int col = 0;
    private boolean prevWasCR = false;
    private final Locator locator;

    public MetaSniffer(ByteReadable source, ErrorHandler eh, Locator locator) {
        this.source = source;
        this.errorHandler = eh;
        this.locator = locator;
    }

    private int read() throws IOException, StopSniffingException {
        if (this.unread == -1) {
            int b = this.source.readByte();
            switch (b) {
                case -1: {
                    throw new StopSniffingException();
                }
                case 10: {
                    if (!this.prevWasCR) {
                        ++this.line;
                        this.col = 0;
                    }
                    this.prevWasCR = false;
                    break;
                }
                case 13: {
                    ++this.line;
                    this.col = 0;
                    this.prevWasCR = true;
                    break;
                }
                default: {
                    ++this.col;
                    this.prevWasCR = false;
                }
            }
            return b;
        }
        int b = this.unread;
        this.unread = -1;
        return b;
    }

    private void unread(int b) {
        this.unread = b;
    }

    public CharsetDecoder sniff() throws SAXException, IOException {
        try {
            while (true) {
                if (this.read() != 60) {
                    continue;
                }
                this.markup();
            }
        }
        catch (StopSniffingException e) {
            return this.charsetDecoder;
        }
    }

    private void markup() throws SAXException, StopSniffingException, IOException {
        int b = this.read();
        if (b == 33) {
            this.markupDecl();
        } else if (b == 47) {
            this.endTag();
        } else if (b == 63) {
            this.consumeUntilAndIncludingGt();
        } else if (b == 77 || b == 109) {
            this.metaState = MetaState.M;
            this.tag();
        } else if (b >= 65 && b <= 90 || b >= 97 && b <= 122) {
            this.metaState = MetaState.NO;
            this.tag();
        }
    }

    private void tag() throws SAXException, StopSniffingException, IOException {
        int b;
        block6: while (true) {
            b = this.read();
            switch (b) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: 
                case 60: 
                case 62: {
                    break block6;
                }
                case 69: 
                case 101: {
                    if (this.metaState == MetaState.M) {
                        this.metaState = MetaState.E;
                        continue block6;
                    }
                    this.metaState = MetaState.NO;
                    continue block6;
                }
                case 84: 
                case 116: {
                    if (this.metaState == MetaState.E) {
                        this.metaState = MetaState.T;
                        continue block6;
                    }
                    this.metaState = MetaState.NO;
                    continue block6;
                }
                case 65: 
                case 97: {
                    if (this.metaState == MetaState.T) {
                        this.metaState = MetaState.A;
                        continue block6;
                    }
                    this.metaState = MetaState.NO;
                    continue block6;
                }
                default: {
                    this.metaState = MetaState.NO;
                    continue block6;
                }
            }
            break;
        }
        this.unread(b);
        if (b != 60) {
            while (this.attribute()) {
            }
        }
    }

    private boolean attribute() throws SAXException, StopSniffingException, IOException {
        int b;
        block22: while (true) {
            b = this.read();
            switch (b) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: 
                case 47: {
                    continue block22;
                }
            }
            break;
        }
        if (b == 60) {
            this.unread(b);
            return false;
        }
        if (b == 62) {
            return false;
        }
        this.attributeName.setLength(0);
        this.attributeValue.setLength(0);
        this.unread(b);
        block23: while (true) {
            b = this.read();
            switch (b) {
                case 61: {
                    break block23;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    block24: while (true) {
                        b = this.read();
                        switch (b) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                continue block24;
                            }
                        }
                        break;
                    }
                    break block23;
                }
                case 47: {
                    return true;
                }
                case 60: {
                    this.unread(b);
                    return false;
                }
                case 62: {
                    return false;
                }
                default: {
                    if (this.metaState != MetaState.A) continue block23;
                    if (b >= 65 && b <= 90) {
                        this.attributeName.append((char)(b + 32));
                        continue block23;
                    }
                    this.attributeName.append((char)b);
                    continue block23;
                }
            }
            break;
        }
        if (b != 61) {
            this.unread(b);
            return true;
        }
        block25: while (true) {
            b = this.read();
            switch (b) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    continue block25;
                }
            }
            break;
        }
        switch (b) {
            case 34: {
                this.quotedAttribute(34);
                return true;
            }
            case 39: {
                this.quotedAttribute(39);
                return true;
            }
            case 60: {
                this.unread(b);
                return false;
            }
            case 62: {
                return false;
            }
        }
        this.unread(b);
        return this.unquotedAttribute();
    }

    private boolean unquotedAttribute() throws SAXException, StopSniffingException, IOException {
        while (true) {
            int b = this.read();
            switch (b) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    this.checkAttribute();
                    return true;
                }
                case 62: {
                    this.checkAttribute();
                    return false;
                }
                case 60: {
                    this.checkAttribute();
                    this.unread(b);
                    return false;
                }
            }
            if (this.metaState != MetaState.A) continue;
            this.attributeValue.append((char)b);
        }
    }

    private void checkAttribute() throws SAXException, StopSniffingException {
        if (this.metaState == MetaState.A) {
            Matcher m;
            String name = this.attributeName.toString();
            if ("charset".equals(name)) {
                this.tryCharset(this.attributeValue.toString().trim());
            } else if ("content".equals(name) && (m = CONTENT.matcher(this.attributeValue)).matches()) {
                String value = null;
                for (int i = 1; i < 4; ++i) {
                    value = m.group(i);
                    if (value == null) continue;
                    this.tryCharset(value);
                    break;
                }
            }
        }
    }

    private void tryCharset(String encoding) throws SAXException, StopSniffingException {
        encoding = encoding.toUpperCase();
        try {
            if ("UTF-16".equals(encoding) || "UTF-16BE".equals(encoding) || "UTF-16LE".equals(encoding) || "UTF-32".equals(encoding) || "UTF-32BE".equals(encoding) || "UTF-32LE".equals(encoding)) {
                this.charsetDecoder = Charset.forName("UTF-8").newDecoder();
                this.err("The internal character encoding declaration specified \u201c" + encoding + "\u201d which is not a rough superset of ASCII. Using \u201cUTF-8\u201d instead.");
                throw new StopSniffingException();
            }
            Charset cs = Charset.forName(encoding);
            String canonName = cs.name();
            if (!EncodingInfo.isAsciiSuperset(canonName)) {
                this.err("The encoding \u201c" + encoding + "\u201d is not an ASCII superset and, therefore, cannot be used in an internal encoding declaration. Continuing the sniffing algorithm.");
                return;
            }
            if (canonName.startsWith("X-") || canonName.startsWith("x-") || canonName.startsWith("Mac")) {
                if (encoding.startsWith("X-")) {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding. (Charmod C022)");
                } else {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding and did\u2019t start with \u201cX-\u201d. (Charmod C023)");
                }
            } else if (!canonName.equalsIgnoreCase(encoding)) {
                this.err("The encoding \u201c" + encoding + "\u201d is not the preferred name of the character encoding in use. The preferred name is \u201c" + canonName + "\u201d. (Charmod C024)");
            }
            if (EncodingInfo.isObscure(canonName)) {
                this.warn("The character encoding \u201c" + encoding + "\u201d is not widely supported. Better interoperability may be achieved by using \u201cUTF-8\u201d.");
            }
            this.charsetDecoder = cs.newDecoder();
            throw new StopSniffingException();
        }
        catch (IllegalCharsetNameException e) {
            this.err("Illegal character encoding name: \u201c" + encoding + "\u201d. Will continue sniffing.");
        }
        catch (UnsupportedCharsetException e) {
            this.err("Unsupported character encoding name: \u201c" + encoding + "\u201d. Will continue sniffing.");
        }
    }

    private void err(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this);
            this.errorHandler.error(spe);
        }
    }

    private void warn(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this);
            this.errorHandler.warning(spe);
        }
    }

    private void quotedAttribute(int delim) throws SAXException, StopSniffingException, IOException {
        while (true) {
            int b;
            if ((b = this.read()) == delim) {
                this.checkAttribute();
                return;
            }
            if (this.metaState != MetaState.A) continue;
            this.attributeValue.append((char)b);
        }
    }

    private void consumeUntilAndIncludingGt() throws IOException, StopSniffingException {
        while (this.read() != 62) {
        }
    }

    private void endTag() throws SAXException, StopSniffingException, IOException {
        int b = this.read();
        if (b >= 65 && b <= 90 || b >= 97 && b <= 122) {
            this.metaState = MetaState.NO;
            this.tag();
        } else {
            this.consumeUntilAndIncludingGt();
        }
    }

    private void markupDecl() throws IOException, StopSniffingException {
        if (this.read() == 45) {
            this.comment();
        } else {
            this.consumeUntilAndIncludingGt();
        }
    }

    private void comment() throws IOException, StopSniffingException {
        if (this.read() == 45) {
            int hyphensSeen = 2;
            while (true) {
                int b;
                if ((b = this.read()) == 45) {
                    ++hyphensSeen;
                    continue;
                }
                if (b == 62) {
                    if (hyphensSeen >= 2) {
                        return;
                    }
                    hyphensSeen = 0;
                    continue;
                }
                hyphensSeen = 0;
            }
        }
        this.consumeUntilAndIncludingGt();
    }

    public int getColumnNumber() {
        return this.col;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getPublicId() {
        if (this.locator != null) {
            return this.locator.getPublicId();
        }
        return null;
    }

    public String getSystemId() {
        if (this.locator != null) {
            return this.locator.getSystemId();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MetaState {
        NO,
        M,
        E,
        T,
        A;

    }

    private class StopSniffingException
    extends Exception {
        private StopSniffingException() {
        }
    }
}

