/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.io.IOException;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.CommandFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftpletcontainer.FtpletContainer;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.listener.Listener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFtpHandler
implements FtpHandler {
    private final Logger LOG = LoggerFactory.getLogger(DefaultFtpHandler.class);
    private static final String[] NON_AUTHENTICATED_COMMANDS = new String[]{"USER", "PASS", "AUTH", "QUIT", "PROT", "PBSZ"};
    private FtpServerContext context;
    private Listener listener;

    public void init(FtpServerContext context, Listener listener) {
        this.context = context;
        this.listener = listener;
    }

    public void sessionCreated(FtpIoSession session) throws Exception {
        session.setListener(this.listener);
        ServerFtpStatistics stats = (ServerFtpStatistics)this.context.getFtpStatistics();
        if (stats != null) {
            stats.setOpenConnection(session);
        }
    }

    public void sessionOpened(FtpIoSession session) throws Exception {
        this.context.getFtpletContainer().onConnect(session.getFtpletSession());
        session.updateLastAccessTime();
        session.write((Object)LocalizedFtpReply.translate(session, null, this.context, 220, null, null));
    }

    public void sessionClosed(FtpIoSession session) throws Exception {
        ServerFtpStatistics stats;
        try {
            this.context.getFtpletContainer().onDisconnect(session.getFtpletSession());
        }
        catch (Exception e) {
            this.LOG.warn("Ftplet threw an exception on disconnect", (Throwable)e);
        }
        FileSystemView fs = session.getFileSystemView();
        if (fs != null) {
            try {
                fs.dispose();
            }
            catch (Exception e) {
                this.LOG.warn("FileSystemView threw an exception on disposal", (Throwable)e);
            }
        }
        if ((stats = (ServerFtpStatistics)this.context.getFtpStatistics()) != null) {
            stats.setLogout(session);
            stats.setCloseConnection(session);
        }
    }

    public void exceptionCaught(FtpIoSession session, Throwable cause) throws Exception {
        if (cause instanceof WriteToClosedSessionException) {
            WriteToClosedSessionException writeToClosedSessionException = (WriteToClosedSessionException)cause;
            this.LOG.warn("Client closed connection before all replies could be sent, last reply was {}", (Object)writeToClosedSessionException.getRequest());
        } else {
            this.LOG.error("Exception caught, closing session", cause);
        }
        session.close(false).awaitUninterruptibly(10000L);
    }

    private boolean isCommandOkWithoutAuthentication(String command) {
        boolean okay = false;
        for (String allowed : NON_AUTHENTICATED_COMMANDS) {
            if (!allowed.equals(command)) continue;
            okay = true;
            break;
        }
        return okay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(FtpIoSession session, FtpRequest request) throws Exception {
        block17: {
            try {
                FtpletResult ftpletRet;
                session.updateLastAccessTime();
                String commandName = request.getCommand();
                CommandFactory commandFactory = this.context.getCommandFactory();
                Command command = commandFactory.getCommand(commandName);
                if (!session.isLoggedIn() && !this.isCommandOkWithoutAuthentication(commandName)) {
                    session.write((Object)LocalizedFtpReply.translate(session, request, this.context, 530, "permission", null));
                    return;
                }
                FtpletContainer ftplets = this.context.getFtpletContainer();
                try {
                    ftpletRet = ftplets.beforeCommand(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletResult.DISCONNECT;
                }
                if (ftpletRet == FtpletResult.DISCONNECT) {
                    session.close(false).awaitUninterruptibly(10000L);
                    return;
                }
                if (ftpletRet == FtpletResult.SKIP) break block17;
                if (command != null) {
                    FtpIoSession e = session;
                    synchronized (e) {
                        command.execute(session, this.context, request);
                    }
                } else {
                    session.write((Object)LocalizedFtpReply.translate(session, request, this.context, 502, "not.implemented", null));
                }
                try {
                    ftpletRet = ftplets.afterCommand(session.getFtpletSession(), request, session.getLastReply());
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletResult.DISCONNECT;
                }
                if (ftpletRet == FtpletResult.DISCONNECT) {
                    session.close(false).awaitUninterruptibly(10000L);
                    return;
                }
            }
            catch (Exception ex) {
                try {
                    session.write((Object)LocalizedFtpReply.translate(session, request, this.context, 550, null, null));
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                this.LOG.warn("RequestHandler.service()", (Throwable)ex);
            }
        }
    }

    public void sessionIdle(FtpIoSession session, IdleStatus status) throws Exception {
        this.LOG.info("Session idle, closing");
        session.close(false).awaitUninterruptibly(10000L);
    }

    public void messageSent(FtpIoSession session, FtpReply reply) throws Exception {
    }
}

