/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.impl.DefaultFtpSession;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;
import org.apache.ftpserver.util.IoUtils;

public class IODataConnection
implements DataConnection {
    private static final byte[] EOL = System.getProperty("line.separator").getBytes();
    private FtpIoSession session;
    private Socket socket;
    private ServerDataConnectionFactory factory;

    public IODataConnection(Socket socket, FtpIoSession session, ServerDataConnectionFactory factory) {
        this.session = session;
        this.socket = socket;
        this.factory = factory;
    }

    private InputStream getDataInputStream() throws IOException {
        try {
            Socket dataSoc = this.socket;
            if (dataSoc == null) {
                throw new IOException("Cannot open data connection.");
            }
            InputStream is = dataSoc.getInputStream();
            if (this.factory.isZipMode()) {
                is = new InflaterInputStream(is);
            }
            return is;
        }
        catch (IOException ex) {
            this.factory.closeDataConnection();
            throw ex;
        }
    }

    private OutputStream getDataOutputStream() throws IOException {
        try {
            Socket dataSoc = this.socket;
            if (dataSoc == null) {
                throw new IOException("Cannot open data connection.");
            }
            OutputStream os = dataSoc.getOutputStream();
            if (this.factory.isZipMode()) {
                os = new DeflaterOutputStream(os);
            }
            return os;
        }
        catch (IOException ex) {
            this.factory.closeDataConnection();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long transferFromClient(FtpSession session, OutputStream out) throws IOException {
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)session.getUser().authorize((AuthorizationRequest)transferRateRequest);
        int maxRate = 0;
        if (transferRateRequest != null) {
            maxRate = transferRateRequest.getMaxUploadRate();
        }
        InputStream is = this.getDataInputStream();
        try {
            long l = this.transfer(session, false, is, out, maxRate);
            return l;
        }
        finally {
            IoUtils.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long transferToClient(FtpSession session, InputStream in) throws IOException {
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)session.getUser().authorize((AuthorizationRequest)transferRateRequest);
        int maxRate = 0;
        if (transferRateRequest != null) {
            maxRate = transferRateRequest.getMaxDownloadRate();
        }
        OutputStream out = this.getDataOutputStream();
        try {
            long l = this.transfer(session, true, in, out, maxRate);
            return l;
        }
        finally {
            IoUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void transferToClient(FtpSession session, String str) throws IOException {
        OutputStream out = this.getDataOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(out, "UTF-8");
            writer.write(str);
            if (session instanceof DefaultFtpSession) {
                ((DefaultFtpSession)session).increaseWrittenDataBytes(str.getBytes("UTF-8").length);
            }
        }
        finally {
            if (writer != null) {
                ((Writer)writer).flush();
            }
            IoUtils.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long transfer(FtpSession session, boolean isWrite, InputStream in, OutputStream out, int maxRate) throws IOException {
        long transferredSize = 0L;
        boolean isAscii = session.getDataType() == DataType.ASCII;
        long startTime = System.currentTimeMillis();
        byte[] buff = new byte[4096];
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = IoUtils.getBufferedInputStream(in);
            bos = IoUtils.getBufferedOutputStream(out);
            DefaultFtpSession defaultFtpSession = null;
            if (session instanceof DefaultFtpSession) {
                defaultFtpSession = (DefaultFtpSession)session;
            }
            int lastByte = 0;
            while (true) {
                int count;
                if (maxRate > 0) {
                    long currRate;
                    long interval = System.currentTimeMillis() - startTime;
                    if (interval == 0L) {
                        interval = 1L;
                    }
                    if ((currRate = transferredSize * 1000L / interval) > (long)maxRate) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
                if ((count = bis.read(buff)) == -1) {
                    break;
                }
                if (defaultFtpSession != null) {
                    if (isWrite) {
                        defaultFtpSession.increaseWrittenDataBytes(count);
                    } else {
                        defaultFtpSession.increaseReadDataBytes(count);
                    }
                }
                if (isAscii) {
                    for (int i = 0; i < count; ++i) {
                        int b = buff[i];
                        if (isWrite) {
                            if (b == 10 && lastByte != 13) {
                                bos.write(13);
                            }
                            bos.write(b);
                        } else if (b != 10) {
                            if (b == 13) {
                                bos.write(EOL);
                            } else {
                                bos.write(b);
                            }
                        }
                        lastByte = b;
                    }
                } else {
                    bos.write(buff, 0, count);
                }
                transferredSize += (long)count;
                this.notifyObserver();
            }
        }
        finally {
            if (bos != null) {
                bos.flush();
            }
        }
        return transferredSize;
    }

    protected void notifyObserver() {
        this.session.updateLastAccessTime();
    }
}

