/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Profile;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class RequireActiveProfile
extends AbstractNonCacheableEnforcerRule {
    public String profiles = null;
    public boolean all = true;

    public void execute(EnforcerRuleHelper theHelper) throws EnforcerRuleException {
        ArrayList<String> missingProfiles = new ArrayList<String>();
        try {
            MavenProject project = (MavenProject)theHelper.evaluate("${project}");
            if (StringUtils.isNotEmpty((String)this.profiles)) {
                String[] profs;
                for (String profile : profs = this.profiles.split(",")) {
                    if (this.isProfileActive(project, profile)) continue;
                    missingProfiles.add(profile);
                }
                boolean fail = false;
                if (!missingProfiles.isEmpty()) {
                    fail = true;
                }
                if (fail) {
                    StringBuilder buf = new StringBuilder();
                    if (this.message != null) {
                        buf.append(this.message + "\n");
                    }
                    for (String profile : missingProfiles) {
                        buf.append("Profile \"" + profile + "\" is not activated.\n");
                    }
                    throw new EnforcerRuleException(buf.toString());
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to retrieve the project.", (Exception)((Object)e));
        }
    }

    protected boolean isProfileActive(MavenProject project, String profileName) {
        List activeProfiles = project.getActiveProfiles();
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            for (Profile profile : activeProfiles) {
                if (!profile.getId().equals(profileName)) continue;
                return true;
            }
        }
        return false;
    }
}

