/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.surefire.junit.JUnitStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;

public class TestListenerInvocationHandler
implements InvocationHandler {
    private static final String START_TEST = "startTest";
    private static final String ADD_FAILURE = "addFailure";
    private static final String ADD_ERROR = "addError";
    private static final String END_TEST = "endTest";
    private final Set failedTestsSet = new HashSet();
    private RunListener reporter;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public TestListenerInvocationHandler(RunListener reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter is null");
        }
        this.reporter = reporter;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(START_TEST)) {
            this.handleStartTest(args);
        } else if (methodName.equals(ADD_ERROR)) {
            this.handleAddError(args);
        } else if (methodName.equals(ADD_FAILURE)) {
            this.handleAddFailure(args);
        } else if (methodName.equals(END_TEST)) {
            this.handleEndTest(args);
        }
        return null;
    }

    public void handleStartTest(Object[] args) {
        SimpleReportEntry report = new SimpleReportEntry(args[0].getClass().getName(), args[0].toString());
        this.reporter.testStarting((ReportEntry)report);
    }

    private void handleAddError(Object[] args) throws IllegalAccessException, InvocationTargetException {
        SimpleReportEntry report = SimpleReportEntry.withException((String)args[0].getClass().getName(), (String)args[0].toString(), (StackTraceWriter)this.getStackTraceWriter(args));
        this.reporter.testError((ReportEntry)report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private JUnitStackTraceWriter getStackTraceWriter(Object[] args) throws IllegalAccessException, InvocationTargetException {
        String testName;
        try {
            Method m = args[0].getClass().getMethod("getName", EMPTY_CLASS_ARRAY);
            testName = (String)m.invoke(args[0], (Object[])EMPTY_STRING_ARRAY);
        }
        catch (NoSuchMethodException e) {
            testName = "UNKNOWN";
        }
        return new JUnitStackTraceWriter(args[0].getClass().getName(), testName, (Throwable)args[1]);
    }

    private void handleAddFailure(Object[] args) throws IllegalAccessException, InvocationTargetException {
        SimpleReportEntry report = SimpleReportEntry.withException((String)args[0].getClass().getName(), (String)args[0].toString(), (StackTraceWriter)this.getStackTraceWriter(args));
        this.reporter.testFailed((ReportEntry)report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleEndTest(Object[] args) {
        boolean testHadFailed = this.failedTestsSet.remove(new FailedTest(args[0], Thread.currentThread()));
        if (!testHadFailed) {
            SimpleReportEntry report = new SimpleReportEntry(args[0].getClass().getName(), args[0].toString());
            this.reporter.testSucceeded((ReportEntry)report);
        }
    }

    private static class FailedTest {
        private Object testThatFailed;
        private Thread threadOnWhichTestFailed;

        FailedTest(Object testThatFailed, Thread threadOnWhichTestFailed) {
            if (testThatFailed == null) {
                throw new NullPointerException("testThatFailed is null");
            }
            if (threadOnWhichTestFailed == null) {
                throw new NullPointerException("threadOnWhichTestFailed is null");
            }
            this.testThatFailed = testThatFailed;
            this.threadOnWhichTestFailed = threadOnWhichTestFailed;
        }

        public boolean equals(Object obj) {
            boolean retVal = true;
            if (obj == null || this.getClass() != obj.getClass()) {
                retVal = false;
            } else {
                FailedTest ft = (FailedTest)obj;
                if (ft.testThatFailed != this.testThatFailed) {
                    retVal = false;
                } else if (!ft.threadOnWhichTestFailed.equals(this.threadOnWhichTestFailed)) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.threadOnWhichTestFailed.hashCode();
        }
    }
}

