/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.storage.DataTransfer;
import org.apache.sis.internal.storage.MemoryDataTransfer;
import org.apache.sis.internal.storage.Region;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.resources.Errors;

public final class HyperRectangleReader {
    private final DataTransfer reader;
    private final long origin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperRectangleReader(byte dataType, ChannelDataInput input, long origin) throws DataStoreException {
        switch (dataType) {
            case 3: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.BytesReader(null);
                break;
            }
            case 2: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.CharsReader((char[])null);
                break;
            }
            case 4: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.ShortsReader((short[])null);
                break;
            }
            case 5: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.IntsReader((int[])null);
                break;
            }
            case 6: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.LongsReader((long[])null);
                break;
            }
            case 7: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.FloatsReader((float[])null);
                break;
            }
            case 8: {
                ChannelDataInput channelDataInput = input;
                channelDataInput.getClass();
                this.reader = channelDataInput.new ChannelDataInput.DoublesReader((double[])null);
                break;
            }
            default: {
                throw new DataStoreException(Errors.format((short)118, (Object)dataType));
            }
        }
        this.origin = origin;
        ByteBuffer buffer = input.buffer;
        int pos = buffer.position();
        int lim = buffer.limit();
        try {
            buffer.position(0).limit(buffer.capacity());
            this.reader.createView();
        }
        finally {
            buffer.limit(lim).position(pos);
        }
    }

    public HyperRectangleReader(String filename, Buffer data) throws IOException {
        this.reader = new MemoryDataTransfer(filename, data).reader();
        this.origin = 0L;
    }

    public String filename() {
        return this.reader.filename();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Region region) throws IOException {
        int contiguousDataLength = region.targetLength(region.contiguousDataDimension);
        long[] strides = new long[region.getDimension() - region.contiguousDataDimension];
        int[] cursor = new int[strides.length];
        int sizeShift = this.reader.dataSizeShift();
        long streamPosition = this.origin + (region.startAt << sizeShift);
        int arrayPosition = 0;
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = region.skips[i + region.contiguousDataDimension] + (long)contiguousDataLength << sizeShift;
            assert (strides[i] > 0L) : i;
        }
        try {
            this.reader.createDataArray(region.targetLength(region.getDimension()));
            Buffer view = this.reader.view();
            block4: while (true) {
                this.reader.seek(streamPosition);
                assert (this.reader.view() == view);
                this.reader.readFully(view, arrayPosition, contiguousDataLength);
                for (int i = 0; i < cursor.length; ++i) {
                    int n = i;
                    cursor[n] = cursor[n] + 1;
                    if (cursor[n] < region.targetSize[region.contiguousDataDimension + i]) {
                        streamPosition += strides[i];
                        arrayPosition += contiguousDataLength;
                        continue block4;
                    }
                    cursor[i] = 0;
                }
                break;
            }
            Object object = this.reader.dataArray();
            return object;
        }
        finally {
            this.reader.setDest(null);
        }
    }
}

