/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;

final class Store
extends DataStore {
    private final String name;
    private Reader source;
    private final List<Object> objects = new ArrayList<Object>();
    private Metadata metadata;

    public Store(StorageConnector connector) throws DataStoreException {
        this.name = connector.getStorageName();
        this.source = connector.getStorageAs(Reader.class);
        connector.closeAllExcept(this.source);
        if (this.source == null) {
            throw new DataStoreException(Errors.format((short)7, (Object)this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws DataStoreException {
        Reader in = this.source;
        if (in != null) {
            try {
                String wkt;
                this.source = null;
                try {
                    int n;
                    char[] buffer = new char[2048];
                    int length = 0;
                    while ((n = in.read(buffer, length, buffer.length - length)) >= 0) {
                        if ((length += n) < buffer.length) continue;
                        if (n >= 0x1FFFFF) {
                            throw new DataStoreException(Errors.format((short)153));
                        }
                        buffer = Arrays.copyOf(buffer, n << 1);
                    }
                    wkt = String.valueOf(buffer, 0, length);
                }
                finally {
                    in.close();
                }
                ParsePosition pos = new ParsePosition(0);
                WKTFormat parser = new WKTFormat(null, null);
                do {
                    this.objects.add(parser.parse((CharSequence)wkt, pos));
                    pos.setIndex(CharSequences.skipLeadingWhitespaces((CharSequence)wkt, (int)pos.getIndex(), (int)wkt.length()));
                    Warnings warnings = parser.getWarnings();
                    if (warnings == null) continue;
                    LogRecord record = new LogRecord(Level.WARNING, warnings.toString());
                    record.setSourceClassName(Store.class.getName());
                    record.setSourceMethodName("getMetadata");
                    this.listeners.warning(record);
                } while (pos.getIndex() < wkt.length());
            }
            catch (IOException e) {
                throw new DataStoreException(Errors.format((short)8, (Object)"WKT", (Object)this.name), e);
            }
            catch (ParseException e) {
                throw new DataStoreException(Errors.format((short)8, (Object)"WKT", (Object)this.name), e);
            }
        }
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.parse();
            DefaultMetadata md = null;
            for (Object object : this.objects) {
                if (!(object instanceof ReferenceSystem)) continue;
                if (md == null) {
                    md = new DefaultMetadata();
                }
                md.getReferenceSystemInfo().add((ReferenceSystem)object);
            }
            this.metadata = md;
        }
        return this.metadata;
    }

    @Override
    public void close() throws DataStoreException {
        Reader s = this.source;
        this.source = null;
        this.objects.clear();
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
    }
}

