/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.sis.internal.storage.wkt.Store;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Version;

public class StoreProvider
extends DataStoreProvider {
    public static final String MIME_TYPE = "application/wkt";
    static final int READ_AHEAD_LIMIT = 2048;
    static final int MIN_LENGTH = 6;
    static final int MAX_LENGTH = 14;
    private static final Set<String> KEYWORDS = StoreProvider.keywords();

    static Set<String> keywords() {
        HashSet<String> s = new HashSet<String>(22);
        s.add("GeodeticCRS");
        s.add("GeodCRS");
        s.add("GeogCS");
        s.add("GeocCS");
        s.add("VerticalCRS");
        s.add("VertCRS");
        s.add("Vert_CS");
        s.add("TimeCRS");
        s.add("ImageCRS");
        s.add("EngineeringCRS");
        s.add("EngCRS");
        s.add("Local_CS");
        s.add("CompoundCRS");
        s.add("Compd_CS");
        s.add("ProjectedCRS");
        s.add("ProjCRS");
        s.add("ProjCS");
        s.add("Fitted_CS");
        s.add("BoundCRS");
        return s;
    }

    private static int nextAfterSpaces(ByteBuffer buffer, Reader reader) throws IOException {
        int c;
        if (buffer != null) {
            while (buffer.hasRemaining()) {
                char c2 = (char)buffer.get();
                if (Character.isWhitespace(c2)) continue;
                return c2;
            }
            return -1;
        }
        while ((c = reader.read()) >= 0 && Character.isWhitespace(c)) {
        }
        return c;
    }

    private static boolean isValidChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storage) throws DataStoreException {
        char[] keyword = null;
        int pos = 0;
        try {
            Reader reader;
            ByteBuffer buffer = storage.getStorageAs(ByteBuffer.class);
            if (buffer != null) {
                buffer.mark();
                reader = null;
            } else {
                reader = storage.getStorageAs(Reader.class);
                if (reader == null) {
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                reader.mark(2048);
            }
            int c = StoreProvider.nextAfterSpaces(buffer, reader);
            if (StoreProvider.isValidChar(c)) {
                keyword = new char[14];
                do {
                    if (pos >= 14) {
                        keyword = null;
                        break;
                    }
                    keyword[pos++] = (char)c;
                } while (StoreProvider.isValidChar(c = buffer == null ? reader.read() : (buffer.hasRemaining() ? (int)buffer.get() : -1)));
                if (Character.isWhitespace(c)) {
                    c = StoreProvider.nextAfterSpaces(buffer, reader);
                }
                if (c != 91 && c != 40) {
                    keyword = null;
                }
            }
            if (buffer != null) {
                buffer.reset();
            } else {
                reader.reset();
            }
            if (c < 0) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        int length = pos;
        if (pos >= 6) {
            int version = 1;
            keyword[0] = (char)(keyword[0] & 0xFFFFFFDF);
            int n = --pos;
            keyword[n] = (char)(keyword[n] & 0xFFFFFFDF);
            int n2 = --pos;
            keyword[n2] = (char)(keyword[n2] & 0xFFFFFFDF);
            if (keyword[n2] == 'R') {
                int n3 = --pos;
                keyword[n3] = (char)(keyword[n3] & 0xFFFFFFDF);
                version = 2;
            }
            while (--pos != 0) {
                if (keyword[pos] == '_') continue;
                int n4 = pos;
                keyword[n4] = (char)(keyword[n4] | 0x20);
            }
            if (KEYWORDS.contains(String.valueOf(keyword, 0, length))) {
                return new ProbeResult(true, MIME_TYPE, Version.valueOf((int[])new int[]{version}));
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storage) throws DataStoreException {
        return new Store(storage);
    }
}

