/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;

abstract class MimeTypeDetector {
    private static final Map<String, String> TYPES = new HashMap<String, String>();
    private static final byte[] XMLNS;
    private static final int MAX_ASCII = 126;
    private byte[] buffer = new byte[32];
    private int length;
    boolean insufficientBytes;

    MimeTypeDetector() {
    }

    private void add(int c) {
        if (this.length == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
        }
        this.buffer[this.length++] = (byte)c;
    }

    abstract int read() throws IOException;

    private int readAfter(int search) throws IOException {
        int c;
        boolean isQuote = false;
        while ((c = this.read()) >= 0) {
            if (c == 34) {
                isQuote = !isQuote;
                continue;
            }
            if (c != search || isQuote) continue;
            return this.read();
        }
        return -1;
    }

    private int afterSpaces(int c) throws IOException {
        while (c <= 32 && c >= 0) {
            c = this.read();
        }
        return c;
    }

    private int matches(byte[] word, int n, char separator) throws IOException {
        int c = this.afterSpaces(this.read());
        for (int i = 0; i < n; ++i) {
            if (c != word[i]) {
                return c >= 0 ? 0 : -1;
            }
            c = this.read();
        }
        return (c = this.afterSpaces(c)) == separator ? 1 : (c >= 0 ? 0 : -1);
    }

    final String getMimeType() throws IOException {
        int c;
        block16: {
            if (this.readAfter(63) != 62) {
                return null;
            }
            while ((c = this.readAfter(60)) == 33) {
                do {
                    c = this.readAfter(45);
                    while (c == 45) {
                        c = this.read();
                    }
                    if (c >= 0) continue;
                    return null;
                } while (c != 62);
            }
            c = this.afterSpaces(c);
            while (c > 32 && c != 58) {
                if (c == 62 || c > 126) {
                    return null;
                }
                this.add(c);
                c = this.read();
            }
            if ((c = this.afterSpaces(c)) != 58) {
                return null;
            }
            do {
                int m;
                if ((m = this.matches(XMLNS, XMLNS.length, ':')) != 0) {
                    if (m < 0) {
                        return null;
                    }
                    m = this.matches(this.buffer, this.length, '=');
                    if (m != 0) {
                        if (m < 0) {
                            return null;
                        }
                        break block16;
                    }
                }
                while ((c = this.read()) >= 32) {
                }
            } while (c >= 0);
            return null;
        }
        this.length = 0;
        c = this.afterSpaces(this.read());
        if (c != 34) {
            return null;
        }
        c = this.afterSpaces(this.read());
        do {
            if (c < 0 || c > 126) {
                return null;
            }
            this.add(c);
        } while ((c = this.read()) != 34);
        return TYPES.get(new String(this.buffer, 0, this.length, "US-ASCII"));
    }

    final ProbeResult probeContent() throws DataStoreException {
        String mimeType;
        try {
            mimeType = this.getMimeType();
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        if (mimeType == null) {
            if (this.insufficientBytes) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            mimeType = "application/xml";
        }
        return new ProbeResult(true, mimeType, null);
    }

    static {
        TYPES.put("http://www.opengis.net/gml/3.2", "application/gml+xml");
        TYPES.put("http://www.isotc211.org/2005/gmd", "application/vnd.iso.19139+xml");
        TYPES.put("http://www.opengis.net/cat/csw/2.0.2", "application/vnd.ogc.csw_xml");
        XMLNS = new byte[]{120, 109, 108, 110, 115};
    }
}

