/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.xml.MimeTypeDetector;
import org.apache.sis.internal.storage.xml.Store;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

public class StoreProvider
extends DataStoreProvider {
    public static final String MIME_TYPE = "application/xml";
    private static final int READ_AHEAD_LIMIT = 2048;
    private static final byte[] HEADER = new byte[]{60, 63, 120, 109, 108, 32};

    @Override
    public ProbeResult probeContent(StorageConnector storage) throws DataStoreException {
        final ByteBuffer buffer = storage.getStorageAs(ByteBuffer.class);
        if (buffer != null) {
            if (buffer.remaining() < HEADER.length) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            for (int i = 0; i < HEADER.length; ++i) {
                if (buffer.get(i) == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            buffer.position(HEADER.length);
            ProbeResult result = new MimeTypeDetector(){

                @Override
                int read() {
                    if (buffer.hasRemaining()) {
                        return buffer.get();
                    }
                    this.insufficientBytes = buffer.limit() != buffer.capacity();
                    return -1;
                }
            }.probeContent();
            buffer.position(0);
            return result;
        }
        final Reader reader = storage.getStorageAs(Reader.class);
        if (reader != null) {
            try {
                reader.mark(HEADER.length + 2048);
                for (int i = 0; i < HEADER.length; ++i) {
                    if (reader.read() == HEADER[i]) continue;
                    reader.reset();
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                ProbeResult result = new MimeTypeDetector(){
                    private int remaining = 2048;

                    @Override
                    int read() throws IOException {
                        return --this.remaining >= 0 ? reader.read() : -1;
                    }
                }.probeContent();
                reader.reset();
                return result;
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storage) throws DataStoreException {
        return new Store(storage);
    }
}

