/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.sis.internal.jdk7.AutoCloseable;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.metadata.Metadata;

@AutoCloseable
public abstract class DataStore
implements Localized {
    private Locale locale = Locale.getDefault();
    protected final WarningListeners<DataStore> listeners = new WarningListeners((Object)this);

    protected DataStore() {
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        this.locale = locale;
    }

    public abstract Metadata getMetadata() throws DataStoreException;

    public void addWarningListener(WarningListener<? super DataStore> listener) throws IllegalArgumentException {
        this.listeners.addWarningListener(listener);
    }

    public void removeWarningListener(WarningListener<? super DataStore> listener) throws NoSuchElementException {
        this.listeners.removeWarningListener(listener);
    }

    public abstract void close() throws DataStoreException;
}

