/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreRegistry;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.Static;

public final class DataStores
extends Static {
    private static volatile DataStoreRegistry registry;

    private DataStores() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DataStoreRegistry registry() {
        DataStoreRegistry r = registry;
        if (r != null) return r;
        Class<DataStores> clazz = DataStores.class;
        synchronized (DataStores.class) {
            r = registry;
            if (r != null) return r;
            registry = r = new DataStoreRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return r;
        }
    }

    public static String probeContentType(Object storage) throws DataStoreException {
        return DataStores.registry().probeContentType(storage);
    }

    public static DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        return DataStores.registry().open(storage);
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.storage"){

            protected void classpathChanged() {
                registry = null;
            }
        });
    }
}

