/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.sql.DataSource;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.storage.ChannelImageInputStream;
import org.apache.sis.internal.storage.IOUtilities;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InputStreamAdapter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;

public class StorageConnector
implements Serializable {
    private static final long serialVersionUID = 2524083964906593093L;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int MINIMAL_BUFFER_SIZE = 256;
    private final Object storage;
    private transient String name;
    private transient String extension;
    private transient Map<Class<?>, Object> views;
    private transient Map<Object, Object> viewsToClose;
    private transient Map<OptionKey<?>, Object> options;

    public StorageConnector(Object storage) {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)storage);
        this.storage = storage;
    }

    public <T> T getOption(OptionKey<T> key) {
        ArgumentChecks.ensureNonNull((String)"key", key);
        return (T)key.getValueFrom(this.options);
    }

    public <T> void setOption(OptionKey<T> key, T value) {
        ArgumentChecks.ensureNonNull((String)"key", key);
        this.options = key.setValueInto(this.options, value);
    }

    public Object getStorage() {
        return this.storage;
    }

    public String getStorageName() {
        if (this.name == null) {
            this.name = IOUtilities.filename(this.storage);
            if (this.name == null) {
                this.name = Classes.getShortClassName((Object)this.storage);
            }
        }
        return this.name;
    }

    public String getFileExtension() {
        if (this.extension == null) {
            this.extension = IOUtilities.extension(this.storage);
        }
        return this.extension;
    }

    public <T> T getStorageAs(Class<T> type) throws IllegalArgumentException, DataStoreException {
        Object value;
        ArgumentChecks.ensureNonNull((String)"type", type);
        if (this.views != null) {
            Object view = this.views.get(type);
            if (view != null) {
                if (view == this.storage && view instanceof InputStream) {
                    try {
                        this.resetInputStream();
                    }
                    catch (IOException e) {
                        throw new DataStoreException(Errors.format((short)9, (Object)this.getStorageName()), e);
                    }
                }
                return view != Void.TYPE ? (T)type.cast(view) : null;
            }
        } else {
            this.views = new IdentityHashMap();
        }
        boolean done = false;
        try {
            if (type == ByteBuffer.class) {
                this.createByteBuffer();
                done = true;
            } else if (type == DataInput.class) {
                this.createDataInput();
                done = true;
            } else if (type == ChannelDataInput.class) {
                this.createChannelDataInput(false);
                done = true;
            }
        }
        catch (IOException e) {
            throw new DataStoreException(Errors.format((short)7, (Object)this.getStorageName()), e);
        }
        if (done) {
            return this.getView(type);
        }
        try {
            value = this.createView(type);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataStoreException(Errors.format((short)7, (Object)this.getStorageName()), e);
        }
        T view = type.cast(value);
        this.addView(type, view);
        return view;
    }

    private void resetInputStream() throws IOException {
        ChannelDataInput channel = this.getView(ChannelDataInput.class);
        if (channel != null) {
            ((InputStream)this.storage).reset();
            channel.buffer.limit(0);
            channel.setStreamPosition(0L);
        }
    }

    private void createChannelDataInput(boolean asImageInputStream) throws IOException {
        if (this.storage instanceof InputStream) {
            ((InputStream)this.storage).mark(4096);
        }
        ReadableByteChannel channel = IOUtilities.open(this.storage, (String)this.getOption(OptionKey.URL_ENCODING), (Object[])this.getOption(OptionKey.OPEN_OPTIONS));
        ChannelDataInput asDataInput = null;
        if (channel != null) {
            this.addViewToClose(channel, this.storage);
            ByteBuffer buffer = (ByteBuffer)this.getOption(OptionKey.BYTE_BUFFER);
            if (buffer == null) {
                buffer = ByteBuffer.allocate(4096);
            }
            String name = this.getStorageName();
            asDataInput = asImageInputStream ? new ChannelImageInputStream(name, channel, buffer, false) : new ChannelDataInput(name, channel, buffer, false);
            this.addViewToClose(asDataInput, channel);
        }
        this.addView(ChannelDataInput.class, asDataInput);
    }

    private void createDataInput() throws IOException {
        DataInput asDataInput;
        if (this.storage instanceof DataInput) {
            asDataInput = (DataInput)this.storage;
        } else {
            ChannelDataInput c;
            if (!this.views.containsKey(ChannelDataInput.class)) {
                this.createChannelDataInput(true);
            }
            if ((c = this.getView(ChannelDataInput.class)) == null) {
                asDataInput = ImageIO.createImageInputStream(this.storage);
                this.addViewToClose(asDataInput, this.storage);
            } else if (c instanceof DataInput) {
                asDataInput = (DataInput)((Object)c);
            } else {
                asDataInput = new ChannelImageInputStream(c);
                if (this.views.put(ChannelDataInput.class, asDataInput) != c) {
                    throw new ConcurrentModificationException();
                }
                this.addViewToClose(asDataInput, c.channel);
            }
        }
        this.addView(DataInput.class, asDataInput);
    }

    private void createByteBuffer() throws IOException, DataStoreException {
        if (!this.views.containsKey(ChannelDataInput.class)) {
            this.createChannelDataInput(false);
        }
        ByteBuffer asByteBuffer = null;
        ChannelDataInput c = this.getView(ChannelDataInput.class);
        if (c != null) {
            asByteBuffer = c.buffer.asReadOnlyBuffer();
        } else {
            ImageInputStream in = this.getStorageAs(ImageInputStream.class);
            if (in != null) {
                in.mark();
                byte[] buffer = new byte[256];
                int n = in.read(buffer);
                in.reset();
                if (n >= 1) {
                    asByteBuffer = ByteBuffer.wrap(buffer).order(in.getByteOrder());
                    asByteBuffer.limit(n);
                }
            }
        }
        this.addView(ByteBuffer.class, asByteBuffer);
    }

    final boolean prefetch() throws DataStoreException {
        try {
            ByteBuffer buffer;
            ChannelDataInput c = this.getView(ChannelDataInput.class);
            if (c != null) {
                return c.prefetch() >= 0;
            }
            ImageInputStream input = this.getView(ImageInputStream.class);
            if (input != null && (buffer = this.getView(ByteBuffer.class)) != null) {
                int p = buffer.limit();
                int n = input.read(buffer.array(), p, buffer.capacity() - p);
                if (n >= 0) {
                    buffer.limit(p + n);
                    return true;
                }
            }
        }
        catch (IOException e) {
            throw new DataStoreException(Errors.format((short)9, (Object)this.getStorageName()), e);
        }
        return false;
    }

    private Object createView(Class<?> type) throws IllegalArgumentException, Exception {
        if (type == String.class) {
            return IOUtilities.toString(this.storage);
        }
        if (type == Connection.class) {
            if (this.storage instanceof Connection) {
                return this.storage;
            }
            if (this.storage instanceof DataSource) {
                Connection c = ((DataSource)this.storage).getConnection();
                this.addViewToClose(c, this.storage);
                return c;
            }
            return null;
        }
        if (type == ImageInputStream.class) {
            DataInput input = this.getStorageAs(DataInput.class);
            return input instanceof ImageInputStream ? input : null;
        }
        if (type == InputStream.class) {
            if (this.storage instanceof InputStream) {
                this.resetInputStream();
                return this.storage;
            }
            DataInput input = this.getStorageAs(DataInput.class);
            if (input instanceof InputStream) {
                return input;
            }
            if (input instanceof ImageInputStream) {
                InputStreamAdapter c = new InputStreamAdapter((ImageInputStream)input);
                this.addViewToClose(c, input);
                return c;
            }
            return null;
        }
        if (type == Reader.class) {
            if (this.storage instanceof Reader) {
                return this.storage;
            }
            InputStream input = this.getStorageAs(InputStream.class);
            if (input != null) {
                Charset encoding = (Charset)this.getOption(OptionKey.ENCODING);
                InputStreamReader c = encoding != null ? new InputStreamReader(input, encoding) : new InputStreamReader(input);
                this.addViewToClose(c, input);
                return c;
            }
            return null;
        }
        return ObjectConverters.convert((Object)this.storage, type);
    }

    private <T> void addView(Class<T> type, T view) {
        if (this.views.put(type, view != null ? view : Void.TYPE) != null) {
            throw new ConcurrentModificationException();
        }
    }

    private <T> T getView(Class<T> type) {
        Object view = this.views.get(type);
        return view != Void.TYPE ? (T)type.cast(view) : null;
    }

    private void addViewToClose(Object input, Object delegate) {
        if (this.viewsToClose == null) {
            this.viewsToClose = new IdentityHashMap<Object, Object>(4);
        }
        if (this.viewsToClose.put(input, delegate) != null) {
            throw new AssertionError(input);
        }
    }

    public void closeAllExcept(Object view) throws DataStoreException {
        Map<Object, Object> toClose = this.viewsToClose;
        this.viewsToClose = Collections.emptyMap();
        this.views = Collections.emptyMap();
        if (toClose == null) {
            if (this.storage != view && JDK7.isAutoCloseable((Object)this.storage)) {
                try {
                    JDK7.close((Object)this.storage);
                }
                catch (Exception e) {
                    throw new DataStoreException(e);
                }
            }
            return;
        }
        toClose.put(this.storage, null);
        if (view != null) {
            LinkedList<Object> deferred = new LinkedList<Object>();
            Object doNotClose = view;
            do {
                Iterator<Map.Entry<Object, Object>> it = toClose.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    if (entry.getValue() != doNotClose) continue;
                    deferred.add(entry.getKey());
                    it.remove();
                }
            } while ((doNotClose = deferred.poll()) != null);
        }
        Object[] doNotClose = view;
        while (doNotClose != null) {
            doNotClose = toClose.remove(doNotClose);
        }
        for (Object delegate : toClose.values().toArray()) {
            toClose.remove(delegate);
        }
        DataStoreException failure = null;
        for (Object c : toClose.keySet()) {
            if (!JDK7.isAutoCloseable((Object)c)) continue;
            try {
                JDK7.close((Object)c);
            }
            catch (Exception e) {
                if (failure != null) continue;
                failure = new DataStoreException(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(Classes.getShortClassName((Object)this)).append("[\u201c").append(this.getStorageName()).append('\u201d');
        if (this.options != null) {
            buffer.append(", options=").append(this.options);
        }
        return buffer.append(']').toString();
    }
}

