/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;

public abstract class PublicKeyKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private PGPPublicKey pubKey;

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        this.pubKey = pGPPublicKey;
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: {
                break;
            }
            case 16: 
            case 20: {
                break;
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pGPPublicKey.getAlgorithm());
            }
        }
    }

    public BigInteger[] processSessionInfo(byte[] byArray) throws PGPException {
        BigInteger[] bigIntegerArray;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray)};
                break;
            }
            case 16: 
            case 20: {
                byte[] byArray2 = new byte[byArray.length / 2];
                byte[] byArray3 = new byte[byArray.length / 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
                bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray2), new BigInteger(1, byArray3)};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return bigIntegerArray;
    }

    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        return new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, byArray)));
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2) throws PGPException;
}

